/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.FileExtension;
import org.bsc.markdown.MarkdownProcessor;
import org.bsc.mojo.AbstractBaseConfluenceMojo;
import org.bsc.mojo.configuration.MarkdownProcessorInfo;

@Mojo(name="blogpost", requiresProject=false, threadSafe=true)
public class ConfluenceBlogpostMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(alias="markdownProcessor")
    private MarkdownProcessorInfo markdownProcessorInfo = new MarkdownProcessorInfo();
    @Parameter(property="blog.title")
    private String title;
    @Parameter(property="blog.content")
    private File content;
    @Parameter(property="blog.version", defaultValue="0")
    private int version;

    private final Charset getCharset() {
        if (this.encoding == null) {
            this.getLog().debug((CharSequence)"encoding is null! default charset will be used");
            return Charset.defaultCharset();
        }
        try {
            Charset result = Charset.forName(this.encoding);
            return result;
        }
        catch (UnsupportedCharsetException e) {
            this.getLog().warn((CharSequence)String.format("encoding [%s] is not valid! default charset will be used", this.encoding));
            return Charset.defaultCharset();
        }
    }

    @Override
    public void execute(ConfluenceService confluenceService) throws Exception {
        if (this.title == null) {
            throw new IllegalArgumentException("blogTitle cannot be null!. Check configuration");
        }
        if (this.content == null) {
            throw new IllegalArgumentException("blogInfo.content cannot be null!. Check configuration");
        }
        if (!this.content.exists()) {
            throw new IllegalArgumentException(String.format("blogContent [%s] doesn't exists!. Check configuration", this.content));
        }
        if (!this.content.isFile()) {
            throw new IllegalArgumentException(String.format("blogContent [%s] isn't a file!. Check configuration", this.content));
        }
        Path path = this.content.toPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        this.getLog().debug((CharSequence)String.format("Blog representation = %s", representation));
        String contentData = Files.toString((File)this.content, (Charset)this.getCharset());
        ConfluenceService.Storage storage = ConfluenceService.Storage.of((String)(isMarkdown ? MarkdownProcessor.shared.load().processMarkdown(contentData) : contentData), (ConfluenceService.Storage.Representation)representation);
        ConfluenceService.Model.Blogpost blogpost = confluenceService.createBlogpost(this.getSpaceKey(), this.title, storage, this.version);
        ((CompletableFuture)confluenceService.addBlogpost(blogpost).thenAccept(result -> this.getLog().info((CharSequence)String.format("Blog [%s] succesfully posted!", result.getTitle())))).join();
    }
}

