/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown.commonmark;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bsc.markdown.MarkdownParserContext;
import org.bsc.markdown.MarkdownVisitorHelper;
import org.bsc.markdown.commonmark.extension.NoticeBlock;
import org.bsc.markdown.commonmark.extension.NoticeBlockExtension;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;

public class CommonmarkConfluenceWikiVisitor
implements Visitor {
    private Stack<StringBuilder> bufferStack = new Stack();
    private final MarkdownParserContext parseContext;

    public static Parser parser() {
        return new Parser();
    }

    public CommonmarkConfluenceWikiVisitor(MarkdownParserContext parseContext) {
        this.parseContext = parseContext;
        this.bufferStack.push(new StringBuilder(512000));
    }

    private StringBuilder buffer() {
        return this.bufferStack.peek();
    }

    private boolean isParentRoot(Node node) {
        return node.getParent() instanceof Document;
    }

    public static String escapeMarkdownText(Node node, String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (node != null && node.getParent() instanceof TableCell) {
            return text;
        }
        BiFunction<String, String, String> replaceAll = (pattern, value) -> {
            Matcher m = Pattern.compile(pattern).matcher((CharSequence)value);
            boolean result = m.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                do {
                    m.appendReplacement(sb, " $2");
                    sb.setCharAt(sb.length() - 2, '\\');
                } while (result = m.find());
                m.appendTail(sb);
                return sb.toString();
            }
            return value;
        };
        String[] leftS = new String[]{"(\\\\)?(\\[)", "(\\\\)?(\\{)"};
        String[] rightS = new String[]{"(\\\\)?(])", "(\\\\)?(\\})"};
        return replaceAll.andThen(result -> (String)replaceAll.apply(rightS[0], (String)result)).andThen(result -> (String)replaceAll.apply(rightS[1], (String)result)).andThen(result -> (String)replaceAll.apply(leftS[0], (String)result)).apply(leftS[1], text);
    }

    public void visit(Paragraph node) {
        ChildrenProcessor p = this.processChildren(node);
        if (this.isParentRoot((Node)node)) {
            p.post("\n", new Object[0]);
        } else if (node.getParent() instanceof ListBlock) {
            p.pre("\n", new Object[0]);
        }
        p.process();
    }

    public void visit(HardLineBreak node) {
        this.processChildren(node).pre("\\\\", new Object[0]).process();
    }

    public void visit(SoftLineBreak node) {
        this.processChildren(node).process(false);
    }

    public void visit(Text node) {
        String literal = CommonmarkConfluenceWikiVisitor.escapeMarkdownText((Node)node, node.getLiteral());
        this.processChildren(node).pre(literal, new Object[0]).process(false);
    }

    public void visit(Heading node) {
        this.processChildren(node).pre(String.format("h%s. ", node.getLevel()), new Object[0]).process();
    }

    public void visit(ListItem node) {
        this.processChildren(node).process(false);
    }

    public void visit(OrderedList node) {
        Block parent = node.getParent();
        ChildrenProcessor p = parent instanceof ListItem ? this.processChildren(node).map(arg_0 -> CommonmarkConfluenceWikiVisitor.lambda$visit$4((Node)parent, arg_0)) : this.processChildren(node).map(n -> "# ");
        p.process(false);
    }

    public void visit(BulletList node) {
        Block parent = node.getParent();
        ChildrenProcessor p = parent instanceof ListItem ? this.processChildren(node).map(arg_0 -> CommonmarkConfluenceWikiVisitor.lambda$visit$6((Node)parent, arg_0)) : this.processChildren(node).map(n -> "* ");
        p.process(false);
    }

    public void visit(BlockQuote node) {
        this.processChildren(node).pre("{quote}\n", new Object[0]).post("{quote}\n", new Object[0]).process(this.isParentRoot((Node)node));
    }

    public void visit(Code node) {
        String literal = CommonmarkConfluenceWikiVisitor.escapeMarkdownText((Node)node, node.getLiteral());
        this.processChildren(node).pre("{{%s}}", literal).process(false);
    }

    public void visit(Document node) {
        this.processChildren(node).process(false);
    }

    public void visit(FencedCodeBlock node) {
        Function<String, String> info = v -> v == null || v.length() == 0 ? "" : ":" + v;
        this.processChildren(node).pre("{code%s}\n%s", info.apply(node.getInfo()), node.getLiteral()).post("{code}", new Object[0]).process();
    }

    public void visit(Emphasis node) {
        this.processChildren(node).pre("_", new Object[0]).post("_", new Object[0]).process(false);
    }

    public void visit(StrongEmphasis node) {
        this.processChildren(node).pre("*", new Object[0]).post("*", new Object[0]).process(false);
    }

    public void visit(Image node) {
        String destination = MarkdownVisitorHelper.processImageUrl((String)node.getDestination(), (MarkdownParserContext)this.parseContext);
        this.processChildren(node).pre("!%s|", destination, node.getTitle()).post("!", new Object[0]).process(this.isParentRoot((Node)node));
    }

    public void visit(LinkReferenceDefinition node) {
        this.processChildren(node).process();
    }

    public void visit(Link node) {
        String destination = MarkdownVisitorHelper.processLinkUrl((String)node.getDestination(), (MarkdownParserContext)this.parseContext);
        this.processChildren(node).pre("[", new Object[0]).captureOutput(v -> this.buffer().append(v)).post("|%s%s]", destination, Optional.ofNullable(node.getTitle()).map(v -> "|" + v).orElse("")).process(this.isParentRoot((Node)node));
    }

    public void visit(ThematicBreak node) {
        this.processChildren(node).pre("----", new Object[0]).process();
    }

    public void visit(TableBlock node) {
        this.processChildren(node).process(false);
    }

    public void visit(TableHead node) {
        this.processChildren(node).process(false);
    }

    public void visit(TableBody node) {
        this.processChildren(node).process(false);
    }

    public void visit(TableRow node) {
        ChildrenProcessor p = this.processChildren(node).pre("|", new Object[0]);
        if (node.getParent() instanceof TableHead) {
            p.post("|", new Object[0]);
        }
        p.process();
    }

    public void visit(TableCell node) {
        ChildrenProcessor p = this.processChildren(node);
        if (node.isHeader()) {
            p.pre("|", new Object[0]);
        }
        p.post("|", new Object[0]).process(false);
    }

    public void visit(HtmlBlock node) {
        this.processChildren(node).pre("{html}\n%s\n", node.getLiteral()).post("{html}", new Object[0]).process();
    }

    public void visit(Strikethrough node) {
        this.processChildren(node).pre("-", new Object[0]).post("-", new Object[0]).process(false);
    }

    public void visit(NoticeBlock node) {
        String type = node.getType().getTagName();
        ChildrenProcessor p = this.processChildren(node);
        if (node.getTitle().isPresent()) {
            p.pre("{%s:title=%s}\n", type, node.getTitle().get());
        } else {
            p.pre("{%s}\n", type);
        }
        p.post("{%s}\n", type).process(this.isParentRoot((Node)node));
    }

    public void visit(CustomNode node) {
        if (node instanceof Strikethrough) {
            this.visit((Strikethrough)node);
            return;
        }
        if (node instanceof TableCell) {
            this.visit((TableCell)node);
            return;
        }
        if (node instanceof TableRow) {
            this.visit((TableRow)node);
            return;
        }
        if (node instanceof TableHead) {
            this.visit((TableHead)node);
            return;
        }
        if (node instanceof TableBody) {
            this.visit((TableBody)node);
            return;
        }
        this.processChildren(node).pre("<<CSTN type=\"%s\">>", node.getClass().getSimpleName()).post("<</CSTN>>", new Object[0]).process();
    }

    public void visit(CustomBlock node) {
        if (node instanceof TableBlock) {
            this.visit((TableBlock)node);
            return;
        }
        if (node instanceof NoticeBlock) {
            this.visit((NoticeBlock)node);
            return;
        }
        this.processChildren(node).pre("<<CSTB type=\"%s\">>", node.getClass().getSimpleName()).post("<</CSTB>>", new Object[0]).process();
    }

    public void visit(HtmlInline node) {
        this.processChildren(node).pre("<<HTMI>>", new Object[0]).post("<</HTMI>>", new Object[0]).process();
    }

    public void visit(IndentedCodeBlock node) {
        this.processChildren(node).pre("<<ICB>>", new Object[0]).post("<</ICB>>", new Object[0]).process();
    }

    public String toString() {
        return this.buffer().toString();
    }

    protected <T extends Node> ChildrenProcessor processChildren(T parent) {
        return new ChildrenProcessor(this, parent, false);
    }

    private static /* synthetic */ Object lambda$visit$6(Node parent, Object n) {
        return parent.getParent() instanceof OrderedList ? "#* " : "** ";
    }

    private static /* synthetic */ Object lambda$visit$4(Node parent, Object n) {
        return parent.getParent() instanceof OrderedList ? "## " : "*# ";
    }

    class ChildrenProcessor<T extends Node> {
        private final boolean debug;
        Optional<String> pre = Optional.empty();
        Optional<String> post = Optional.empty();
        Optional<Consumer<Node>> forEach = Optional.empty();
        Optional<Function<Node, String>> map = Optional.empty();
        Optional<Consumer<String>> captureOutput = Optional.empty();
        final T parent;
        final /* synthetic */ CommonmarkConfluenceWikiVisitor this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ChildrenProcessor(T parent, boolean debug) {
            this.this$0 = (CommonmarkConfluenceWikiVisitor)this$0;
            this.parent = parent;
            this.debug = debug;
        }

        public ChildrenProcessor(T parent) {
            this(this$0, (Node)parent, false);
        }

        ChildrenProcessor captureOutput(Consumer<String> v) {
            this.captureOutput = Optional.ofNullable(v);
            return this;
        }

        ChildrenProcessor pre(String v, Object ... args) {
            this.pre = Optional.ofNullable(String.format(v, args));
            return this;
        }

        ChildrenProcessor post(String v, Object ... args) {
            this.post = Optional.ofNullable(String.format(v, args));
            return this;
        }

        <A extends Node> ChildrenProcessor map(Function<Node, String> v) {
            this.map = Optional.ofNullable(v);
            return this;
        }

        void process() {
            this.process(true);
        }

        void process(boolean writeln) {
            if (this.debug) {
                this.this$0.buffer().append(String.format("<%s>", this.parent.getClass().getSimpleName()));
            }
            this.pre.ifPresent(v -> this.this$0.buffer().append((String)v));
            this.captureOutput.ifPresent(consumer -> this.this$0.bufferStack.push(new StringBuilder()));
            Node node = this.parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                if (this.map.isPresent()) {
                    this.this$0.buffer().append(this.map.get().apply(node));
                }
                node.accept((Visitor)this.this$0);
                node = next;
            }
            this.captureOutput.ifPresent(consumer -> consumer.accept(((StringBuilder)this.this$0.bufferStack.pop()).toString()));
            this.post.ifPresent(v -> this.this$0.buffer().append((String)v));
            if (this.debug) {
                this.this$0.buffer().append(String.format("</%s>", this.parent.getClass().getSimpleName()));
            }
            if (writeln) {
                this.this$0.buffer().append('\n');
            }
        }
    }

    public static class Parser {
        private final List<Extension> extensions = Arrays.asList(StrikethroughExtension.create(), TablesExtension.create(), NoticeBlockExtension.create());
        private final org.commonmark.parser.Parser parser = org.commonmark.parser.Parser.builder().extensions(this.extensions).build();

        public final Node parse(String content) {
            return this.parser.parse(content);
        }
    }
}

