/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.security.util.PasswordChange;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.web.controller.account.ChangePasswordForm;
import org.broadleafcommerce.core.web.controller.account.validator.ChangePasswordValidator;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class BroadleafChangePasswordController
extends BroadleafAbstractController {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blChangePasswordValidator")
    protected ChangePasswordValidator changePasswordValidator;
    protected String passwordChangedMessage = "Password successfully changed";
    protected static String changePasswordView = "account/changePassword";
    protected static String changePasswordRedirect = "redirect:/account/password";

    public String viewChangePassword(HttpServletRequest request, Model model) {
        return this.getChangePasswordView();
    }

    public String processChangePassword(HttpServletRequest request, Model model, ChangePasswordForm form, BindingResult result, RedirectAttributes redirectAttributes) throws ServiceException {
        PasswordChange passwordChange = new PasswordChange(CustomerState.getCustomer().getUsername());
        passwordChange.setCurrentPassword(form.getCurrentPassword());
        passwordChange.setNewPassword(form.getNewPassword());
        passwordChange.setNewPasswordConfirm(form.getNewPasswordConfirm());
        this.changePasswordValidator.validate(passwordChange, (Errors)result);
        if (result.hasErrors()) {
            return this.getChangePasswordView();
        }
        this.customerService.changePassword(passwordChange);
        return this.getChangePasswordRedirect();
    }

    public String getChangePasswordView() {
        return changePasswordView;
    }

    public String getChangePasswordRedirect() {
        return changePasswordRedirect;
    }

    public String getPasswordChangedMessage() {
        return this.passwordChangedMessage;
    }
}

