/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog.taglib;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.profile.core.domain.Address;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GoogleAnalyticsTag
extends SimpleTagSupport {
    private static final Log LOG = LogFactory.getLog(GoogleAnalyticsTag.class);
    protected String webPropertyId;
    private Order order;

    protected String getWebPropertyIdDefault() {
        return BLCSystemProperty.resolveSystemProperty((String)"googleAnalytics.webPropertyId");
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public String getWebPropertyId() {
        if (this.webPropertyId == null) {
            return this.getWebPropertyIdDefault();
        }
        return this.webPropertyId;
    }

    public void setWebPropertyId(String webPropertyId) {
        this.webPropertyId = webPropertyId;
    }

    public void doTag() throws JspException, IOException {
        JspWriter out = this.getJspContext().getOut();
        String webPropertyId = this.getWebPropertyId();
        if (webPropertyId == null) {
            ServletContext sc = ((PageContext)this.getJspContext()).getServletContext();
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
            context.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 1, false);
        }
        if (webPropertyId.equals("UA-XXXXXXX-X")) {
            LOG.warn((Object)"googleAnalytics.webPropertyId has not been overridden in a custom property file. Please set this in order to properly use the Google Analytics tag");
        }
        out.println(this.analytics(webPropertyId, this.order));
        super.doTag();
    }

    protected String analytics(String webPropertyId, Order order) {
        StringBuffer sb = new StringBuffer();
        sb.append("<script type=\"text/javascript\">");
        sb.append("var _gaq = _gaq || [];");
        sb.append("_gaq.push(['_setAccount', '" + webPropertyId + "']);");
        sb.append("_gaq.push(['_trackPageview']);");
        if (order != null) {
            Address paymentAddress = null;
            for (OrderPayment payment : order.getPayments()) {
                if (!payment.isActive() || !PaymentType.CREDIT_CARD.equals((Object)payment.getType())) continue;
                paymentAddress = payment.getBillingAddress();
            }
            sb.append("_gaq.push(['_addTrans','" + order.getId() + "'");
            sb.append(",'" + order.getName() + "'");
            sb.append(",'" + order.getTotal() + "'");
            sb.append(",'" + order.getTotalTax() + "'");
            sb.append(",'" + order.getTotalShipping() + "'");
            if (paymentAddress != null) {
                sb.append(",'" + paymentAddress.getCity() + "'");
                sb.append(",'" + paymentAddress.getState().getName() + "'");
                sb.append(",'" + paymentAddress.getCountry().getName() + "'");
            }
            sb.append("]);");
            for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                for (FulfillmentGroupItem fulfillmentGroupItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                    DiscreteOrderItem orderItem = (DiscreteOrderItem)fulfillmentGroupItem.getOrderItem();
                    sb.append("_gaq.push(['_addItem','" + order.getId() + "'");
                    sb.append(",'" + orderItem.getSku().getId() + "'");
                    sb.append(",'" + orderItem.getSku().getName() + "'");
                    sb.append(",' " + orderItem.getProduct().getDefaultCategory() + "'");
                    sb.append(",'" + orderItem.getPrice() + "'");
                    sb.append(",'" + orderItem.getQuantity() + "'");
                    sb.append("]);");
                }
            }
            sb.append("_gaq.push(['_trackTrans']);");
        }
        sb.append(" (function() {var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);})();");
        sb.append("</script>");
        return sb.toString();
    }
}

