/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api;

import com.sun.jersey.core.impl.provider.entity.XMLListElementProvider;
import com.sun.jersey.core.impl.provider.entity.XMLRootElementProvider;
import com.sun.jersey.json.impl.provider.entity.JSONListElementProvider;
import com.sun.jersey.json.impl.provider.entity.JSONRootElementProvider;
import com.sun.jersey.spi.inject.Injectable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;

@Scope(value="singleton")
@Provider
@Produces(value={"application/json", "application/xml", "text/xml"})
@Consumes(value={"application/json", "application/xml", "text/xml"})
public class BroadleafMessageBodyReaderWriter
implements MessageBodyReader<Object>,
MessageBodyWriter<Object>,
ContextResolver<JAXBContext>,
ApplicationContextAware {
    protected static HashMap<String, Class<?>> typeMap = null;
    protected ApplicationContext applicationContext;
    @Context
    protected Providers ps;
    @Context
    protected Injectable<XMLInputFactory> xif;
    @Context
    protected Injectable<SAXParserFactory> spf;
    protected JAXBContext jaxbContext = null;
    protected XMLListElementProvider.App xmlListProvider;
    protected JSONListElementProvider.App jsonListProvider;
    protected XMLRootElementProvider.App xmlRootElementProvider;
    protected JSONRootElementProvider.App jsonRootElementProvider;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isWriteable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Type lookupType = this.getLookupType(type, genericType);
        return this.getApiWrapper(type, lookupType) != null;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        this.initializeProviders();
        Type lookupType = this.getLookupType(type, genericType);
        if (this.getApiWrapper(type, lookupType) != null) {
            genericType = this.getApiWrapper(type, lookupType);
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            if (Collection.class.isAssignableFrom(type)) {
                return this.jsonListProvider.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
            }
            if (type.isArray()) {
                return this.jsonListProvider.readFrom((Class)genericType, genericType, annotations, mediaType, httpHeaders, entityStream);
            }
            return this.jsonRootElementProvider.readFrom((Class)genericType, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) || mediaType.isCompatible(MediaType.TEXT_XML_TYPE)) {
            if (Collection.class.isAssignableFrom(type)) {
                return this.xmlListProvider.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
            }
            if (type.isArray()) {
                return this.xmlListProvider.readFrom((Class)genericType, genericType, annotations, mediaType, httpHeaders, entityStream);
            }
            return this.xmlRootElementProvider.readFrom((Class)genericType, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        return null;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.initializeProviders();
        Type lookupType = this.getLookupType(type, genericType);
        if (this.getApiWrapper(type, lookupType) != null) {
            genericType = this.getApiWrapper(type, lookupType);
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            if (Collection.class.isAssignableFrom(type)) {
                this.jsonListProvider.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
            } else if (type.isArray()) {
                this.jsonListProvider.writeTo(t, (Class)genericType, genericType, annotations, mediaType, httpHeaders, entityStream);
            } else {
                this.jsonRootElementProvider.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
            }
        } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) || mediaType.isCompatible(MediaType.TEXT_XML_TYPE)) {
            if (Collection.class.isAssignableFrom(type)) {
                this.xmlListProvider.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
            } else if (type.isArray()) {
                this.xmlListProvider.writeTo(t, (Class)genericType, genericType, annotations, mediaType, httpHeaders, entityStream);
            } else {
                this.xmlRootElementProvider.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
            }
        }
    }

    private void initializeProviders() {
        if (this.jsonListProvider == null) {
            this.jsonListProvider = new JSONListElementProvider.App(this.ps);
        }
        if (this.xmlListProvider == null) {
            this.xmlListProvider = new XMLListElementProvider.App(this.xif, this.ps);
        }
        if (this.xmlRootElementProvider == null) {
            this.xmlRootElementProvider = new XMLRootElementProvider.App(this.spf, this.ps);
        }
        if (this.jsonRootElementProvider == null) {
            this.jsonRootElementProvider = new JSONRootElementProvider.App(this.ps);
        }
    }

    protected Type getLookupType(Class<?> type, Type genericType) {
        Type lookupType = genericType;
        if (Collection.class.isAssignableFrom(type)) {
            ParameterizedType pt = (ParameterizedType)((Object)genericType);
            lookupType = pt.getActualTypeArguments()[0];
        } else if (type.isArray()) {
            lookupType = type.getComponentType();
        }
        return lookupType;
    }

    protected Type getApiWrapper(Class<?> type, Type lookupType) {
        this.initializeTypeMap();
        if (lookupType instanceof Class) {
            Class<?> clz = typeMap.get(((Class)lookupType).getName());
            if (clz == null) {
                return null;
            }
            if (Collection.class.isAssignableFrom(type)) {
                Type[] paramType = new Type[]{clz};
                return new ParameterizedTypeImpl(paramType, type, null);
            }
            if (type.isArray()) {
                return Array.newInstance(clz, 0).getClass();
            }
            return clz;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getContext(Class<?> ignored) {
        if (this.jaxbContext == null) {
            BroadleafMessageBodyReaderWriter broadleafMessageBodyReaderWriter = this;
            synchronized (broadleafMessageBodyReaderWriter) {
                this.initializeTypeMap();
                if (!typeMap.isEmpty()) {
                    try {
                        this.jaxbContext = JAXBContext.newInstance((Class[])typeMap.values().toArray(new Class[typeMap.size()]));
                    }
                    catch (JAXBException e) {
                        throw new RuntimeException("Error creating a JAXBContext", e);
                    }
                }
            }
        }
        return this.jaxbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeTypeMap() {
        if (typeMap == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (typeMap == null) {
                    typeMap = new HashMap();
                    Map apiWrappers = this.applicationContext.getBeansWithAnnotation(XmlRootElement.class);
                    for (Object obj : apiWrappers.values()) {
                        typeMap.put(obj.getClass().getName(), obj.getClass());
                    }
                }
            }
        }
    }

    protected class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Class<?> rawType;
        private Type ownerType;

        public ParameterizedTypeImpl(Type[] actualTypeArguments, Class<?> rawType, Type ownerType) {
            this.actualTypeArguments = actualTypeArguments;
            this.rawType = rawType;
            this.ownerType = ownerType != null ? ownerType : rawType.getDeclaringClass();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.actualTypeArguments.clone();
        }
    }
}

