/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KemCiphertextInfo
extends ASN1Object {
    private final AlgorithmIdentifier kem;
    private final ASN1OctetString ct;

    private KemCiphertextInfo(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("sequence size should 2");
        }
        this.kem = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(0));
        this.ct = ASN1OctetString.getInstance((Object)seq.getObjectAt(1));
    }

    public KemCiphertextInfo(AlgorithmIdentifier kem, ASN1OctetString ct) {
        this.kem = kem;
        this.ct = ct;
    }

    public static KemCiphertextInfo getInstance(Object o) {
        if (o instanceof KemCiphertextInfo) {
            return (KemCiphertextInfo)((Object)o);
        }
        if (o != null) {
            return new KemCiphertextInfo(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public AlgorithmIdentifier getKem() {
        return this.kem;
    }

    public ASN1OctetString getCt() {
        return this.ct;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence((ASN1Encodable)this.kem, (ASN1Encodable)this.ct);
    }
}

