/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.MessageSignerAdapter;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSASigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.PQCUtil;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamSigner;

public class BcTlsSLHDSASigner
extends BcTlsSigner {
    private final int signatureScheme;

    public static BcTlsSLHDSASigner create(BcTlsCrypto crypto, SLHDSAPrivateKeyParameters privateKey, int signatureScheme) {
        if (signatureScheme != PQCUtil.getSLHDSASignatureScheme(privateKey.getParameters())) {
            return null;
        }
        return new BcTlsSLHDSASigner(crypto, privateKey, signatureScheme);
    }

    private BcTlsSLHDSASigner(BcTlsCrypto crypto, SLHDSAPrivateKeyParameters privateKey, int signatureScheme) {
        super(crypto, (AsymmetricKeyParameter)privateKey);
        if (!SignatureScheme.isSLHDSA(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = signatureScheme;
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) {
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        SLHDSASigner signer = new SLHDSASigner();
        signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        return new BcTlsStreamSigner((Signer)new MessageSignerAdapter((MessageSigner)signer));
    }
}

