/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.GCMUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceAEADCipherImpl
implements TlsAEADCipherImpl {
    private static final boolean canDoAEAD = JceAEADCipherImpl.checkForAEAD();
    private final JcaTlsCrypto crypto;
    private final JcaJceHelper helper;
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private final int keySize;
    private final String algorithmParamsName;
    private SecretKey key;
    private byte[] noncePre7;
    private int macSizePre7;

    private static boolean checkForAEAD() {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Cipher.class.getMethod("updateAAD", byte[].class) != null;
                }
                catch (Exception ignore) {
                    return Boolean.FALSE;
                }
            }
        });
    }

    private static String getAlgParamsName(JcaJceHelper helper, String cipherName) {
        try {
            String algName = cipherName.contains("CCM") ? "CCM" : "GCM";
            helper.createAlgorithmParameters(algName);
            return algName;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JceAEADCipherImpl(JcaTlsCrypto crypto, JcaJceHelper helper, String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        this.crypto = crypto;
        this.helper = helper;
        this.cipher = helper.createCipher(cipherName);
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.cipherMode = isEncrypting ? 1 : 2;
        this.algorithmParamsName = JceAEADCipherImpl.getAlgParamsName(helper, cipherName);
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        if (this.keySize != keyLen) {
            throw new IllegalStateException();
        }
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    @Override
    public void init(byte[] nonce, int macSize) {
        SecureRandom random = this.crypto.getSecureRandom();
        try {
            if (canDoAEAD && this.algorithmParamsName != null) {
                AlgorithmParameters algParams = this.helper.createAlgorithmParameters(this.algorithmParamsName);
                if (GCMUtil.isGCMParameterSpecAvailable()) {
                    algParams.init(GCMUtil.createGCMParameterSpec(macSize * 8, nonce));
                } else {
                    algParams.init(new GCMParameters(nonce, macSize).getEncoded());
                }
                this.cipher.init(this.cipherMode, (Key)this.key, algParams, random);
            } else {
                if (this.noncePre7 == null || this.noncePre7.length != nonce.length) {
                    this.noncePre7 = new byte[nonce.length];
                }
                System.arraycopy(nonce, 0, this.noncePre7, 0, nonce.length);
                this.macSizePre7 = macSize;
                this.noncePre7[0] = (byte)(this.noncePre7[0] ^ 0x80);
                AEADParameterSpec params = new AEADParameterSpec(this.noncePre7, this.macSizePre7 * 8, null);
                this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)params, random);
                this.noncePre7[0] = (byte)(this.noncePre7[0] ^ 0x80);
            }
        }
        catch (Exception e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public int getOutputSize(int inputLength) {
        return this.cipher.getOutputSize(inputLength);
    }

    @Override
    public int doFinal(byte[] additionalData, byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        if (!Arrays.isNullOrEmpty((byte[])additionalData)) {
            if (canDoAEAD) {
                this.cipher.updateAAD(additionalData);
            } else {
                try {
                    SecureRandom random = this.crypto.getSecureRandom();
                    AEADParameterSpec params = new AEADParameterSpec(this.noncePre7, this.macSizePre7 * 8, additionalData);
                    this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)params, random);
                }
                catch (Exception e) {
                    throw Exceptions.ioException(e.getMessage(), e);
                }
            }
        }
        try {
            return this.cipher.doFinal(input, inputOffset, inputLength, output, outputOffset);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("", e);
        }
    }
}

