/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;

public class PQCUtil {
    public static ASN1ObjectIdentifier getMLDSAObjectidentifier(int signatureScheme) {
        switch (signatureScheme) {
            case 2308: {
                return NISTObjectIdentifiers.id_ml_dsa_44;
            }
            case 2309: {
                return NISTObjectIdentifiers.id_ml_dsa_65;
            }
            case 2310: {
                return NISTObjectIdentifiers.id_ml_dsa_87;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getMLDSASignatureScheme(MLDSAParameters parameters) {
        if (MLDSAParameters.ml_dsa_44 == parameters) {
            return 2308;
        }
        if (MLDSAParameters.ml_dsa_65 == parameters) {
            return 2309;
        }
        if (MLDSAParameters.ml_dsa_87 == parameters) {
            return 2310;
        }
        throw new IllegalArgumentException();
    }

    public static boolean supportsMLDSA(AlgorithmIdentifier pubKeyAlgID, ASN1ObjectIdentifier mlDsaAlgOid) {
        return pubKeyAlgID.getAlgorithm().equals((ASN1Primitive)mlDsaAlgOid) && pubKeyAlgID.getParameters() == null;
    }
}

