/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.interfaces.MLKEMPublicKey;
import org.bouncycastle.jcajce.spec.MLKEMParameterSpec;
import org.bouncycastle.jcajce.spec.MLKEMPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class KemUtil {
    KemUtil() {
    }

    static PublicKey decodePublicKey(JcaTlsCrypto crypto, String kemName, byte[] encoding) throws TlsFatalAlert {
        try {
            KeyFactory kf = crypto.getHelper().createKeyFactory(kemName);
            if (kf.getProvider() instanceof BouncyCastleProvider) {
                try {
                    MLKEMParameterSpec params = MLKEMParameterSpec.fromName((String)kemName);
                    MLKEMPublicKeySpec keySpec = new MLKEMPublicKeySpec(params, encoding);
                    return kf.generatePublic((KeySpec)keySpec);
                }
                catch (Exception params) {
                    // empty catch block
                }
            }
            X509EncodedKeySpec keySpec = KemUtil.createX509EncodedKeySpec(KemUtil.getAlgorithmOID(kemName), encoding);
            return kf.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    static byte[] encodePublicKey(PublicKey publicKey) throws TlsFatalAlert {
        if (publicKey instanceof MLKEMPublicKey) {
            return ((MLKEMPublicKey)publicKey).getPublicData();
        }
        if (!"X.509".equals(publicKey.getFormat())) {
            throw new TlsFatalAlert(80, "Public key format unrecognized");
        }
        try {
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            return spki.getPublicKeyData().getOctets();
        }
        catch (Exception e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    static KeyFactory getKeyFactory(JcaTlsCrypto crypto, String kemName) {
        try {
            return crypto.getHelper().createKeyFactory(kemName);
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static KeyGenerator getKeyGenerator(JcaTlsCrypto crypto, String kemName) {
        try {
            return crypto.getHelper().createKeyGenerator(kemName);
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static KeyPairGenerator getKeyPairGenerator(JcaTlsCrypto crypto, String kemName) {
        try {
            KeyPairGenerator keyPairGenerator = crypto.getHelper().createKeyPairGenerator("ML-KEM");
            keyPairGenerator.initialize((AlgorithmParameterSpec)MLKEMParameterSpec.fromName((String)kemName), crypto.getSecureRandom());
            return keyPairGenerator;
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static boolean isKemSupported(JcaTlsCrypto crypto, String kemName) {
        return kemName != null && KemUtil.getKeyFactory(crypto, kemName) != null && KemUtil.getKeyGenerator(crypto, kemName) != null && KemUtil.getKeyPairGenerator(crypto, kemName) != null;
    }

    private static X509EncodedKeySpec createX509EncodedKeySpec(ASN1ObjectIdentifier oid, byte[] encoding) throws IOException {
        AlgorithmIdentifier algID = new AlgorithmIdentifier(oid);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(algID, encoding);
        return new X509EncodedKeySpec(spki.getEncoded("DER"));
    }

    private static ASN1ObjectIdentifier getAlgorithmOID(String kemName) {
        if ("ML-KEM-512".equalsIgnoreCase(kemName)) {
            return NISTObjectIdentifiers.id_alg_ml_kem_512;
        }
        if ("ML-KEM-768".equalsIgnoreCase(kemName)) {
            return NISTObjectIdentifiers.id_alg_ml_kem_768;
        }
        if ("ML-KEM-1024".equalsIgnoreCase(kemName)) {
            return NISTObjectIdentifiers.id_alg_ml_kem_1024;
        }
        throw new IllegalArgumentException("unknown kem name " + kemName);
    }
}

