/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import org.bouncycastle.jcajce.spec.DHExtendedPublicKeySpec;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DHUtil {
    DHUtil() {
    }

    static AlgorithmParameterSpec createInitSpec(DHGroup dhGroup) {
        return new DHDomainParameterSpec(dhGroup.getP(), dhGroup.getQ(), dhGroup.getG(), dhGroup.getL());
    }

    static KeySpec createPublicKeySpec(BigInteger y, DHParameterSpec dhSpec) {
        return new DHExtendedPublicKeySpec(y, dhSpec);
    }

    static AlgorithmParameters getAlgorithmParameters(JcaTlsCrypto crypto, DHGroup dhGroup) {
        return DHUtil.getAlgorithmParameters(crypto, DHUtil.createInitSpec(dhGroup));
    }

    static AlgorithmParameters getAlgorithmParameters(JcaTlsCrypto crypto, AlgorithmParameterSpec initSpec) {
        try {
            AlgorithmParameters dhAlgParams = crypto.getHelper().createAlgorithmParameters("DiffieHellman");
            dhAlgParams.init(initSpec);
            DHParameterSpec dhSpec = dhAlgParams.getParameterSpec(DHParameterSpec.class);
            if (null != dhSpec) {
                return dhAlgParams;
            }
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static DHParameterSpec getDHParameterSpec(JcaTlsCrypto crypto, DHGroup dhGroup) {
        return DHUtil.getDHParameterSpec(crypto, DHUtil.createInitSpec(dhGroup));
    }

    static DHParameterSpec getDHParameterSpec(JcaTlsCrypto crypto, AlgorithmParameterSpec initSpec) {
        try {
            AlgorithmParameters dhAlgParams = crypto.getHelper().createAlgorithmParameters("DiffieHellman");
            dhAlgParams.init(initSpec);
            DHParameterSpec dhSpec = dhAlgParams.getParameterSpec(DHParameterSpec.class);
            if (null != dhSpec) {
                return dhSpec;
            }
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static BigInteger getQ(DHParameterSpec dhSpec) {
        return dhSpec instanceof DHDomainParameterSpec ? ((DHDomainParameterSpec)dhSpec).getQ() : null;
    }

    static boolean isGroupSupported(JcaTlsCrypto crypto, DHGroup dhGroup) {
        return null != dhGroup && null != DHUtil.getDHParameterSpec(crypto, dhGroup);
    }
}

