/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsMLKemDomain;

public class BcTlsMLKem
implements TlsAgreement {
    protected final BcTlsMLKemDomain domain;
    protected KyberPrivateKeyParameters privateKey;
    protected KyberPublicKeyParameters publicKey;
    protected TlsSecret secret;

    public BcTlsMLKem(BcTlsMLKemDomain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretWithEncapsulation encap = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(encap.getSecret());
            return encap.getEncapsulation();
        }
        AsymmetricCipherKeyPair kp = this.domain.generateKeyPair();
        this.privateKey = (KyberPrivateKeyParameters)kp.getPrivate();
        return this.domain.encodePublicKey((KyberPublicKeyParameters)kp.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(peerValue);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, peerValue);
            this.privateKey = null;
        }
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        TlsSecret secret = this.secret;
        this.secret = null;
        return secret;
    }
}

