/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKemDomain;

public class JceTlsMLKem
implements TlsAgreement {
    protected final JceTlsMLKemDomain domain;
    protected KyberPrivateKeyParameters privateKey;
    protected KyberPublicKeyParameters publicKey;
    protected TlsSecret secret;

    public JceTlsMLKem(JceTlsMLKemDomain domain) {
        this.domain = domain;
    }

    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretWithEncapsulation encap = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(encap.getSecret());
            return encap.getEncapsulation();
        }
        AsymmetricCipherKeyPair kp = this.domain.generateKeyPair();
        this.privateKey = (KyberPrivateKeyParameters)kp.getPrivate();
        return this.domain.encodePublicKey((KyberPublicKeyParameters)kp.getPublic());
    }

    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(peerValue);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, peerValue);
            this.privateKey = null;
        }
    }

    public TlsSecret calculateSecret() throws IOException {
        TlsSecret secret = this.secret;
        this.secret = null;
        return secret;
    }
}

