/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.util.Integers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GCMUtil {
    static final Constructor<AlgorithmParameterSpec> gcmParameterSpec = GCMUtil.getConstructor();

    GCMUtil() {
    }

    static AlgorithmParameterSpec createGCMParameterSpec(final int tLen, final byte[] src) throws Exception {
        if (gcmParameterSpec == null) {
            throw new IllegalStateException();
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<AlgorithmParameterSpec>(){

            @Override
            public AlgorithmParameterSpec run() throws Exception {
                return gcmParameterSpec.newInstance(Integers.valueOf((int)tLen), src);
            }
        });
    }

    static boolean isGCMParameterSpecAvailable() {
        return gcmParameterSpec != null;
    }

    private static Constructor<AlgorithmParameterSpec> getConstructor() {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor<AlgorithmParameterSpec>>(){

            @Override
            public Constructor<AlgorithmParameterSpec> run() {
                try {
                    Class<?> clazz;
                    String className = "javax.crypto.spec.GCMParameterSpec";
                    ClassLoader classLoader = GCMUtil.class.getClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    if ((clazz = classLoader.loadClass(className)) != null && AlgorithmParameterSpec.class.isAssignableFrom(clazz)) {
                        Class<?> typedClazz = clazz;
                        return typedClazz.getConstructor(Integer.TYPE, byte[].class);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

