/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.OldCertUtil;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SSLSessionUtil;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

abstract class ProvSSLSessionBase
extends BCExtendedSSLSession {
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final AtomicReference<ProvSSLSessionContext> sslSessionContext;
    protected final boolean isFips;
    protected final JcaTlsCrypto crypto;
    protected final String peerHost;
    protected final int peerPort;
    protected final long creationTime;
    protected final SSLSession exportSSLSession;
    protected final AtomicLong lastAccessedTime;

    ProvSSLSessionBase(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort) {
        this.sslSessionContext = new AtomicReference<ProvSSLSessionContext>(sslSessionContext);
        this.isFips = null == sslSessionContext ? false : sslSessionContext.getSSLContext().isFips();
        this.crypto = null == sslSessionContext ? null : sslSessionContext.getCrypto();
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.creationTime = System.currentTimeMillis();
        this.exportSSLSession = SSLSessionUtil.exportSSLSession(this);
        this.lastAccessedTime = new AtomicLong(this.creationTime);
    }

    protected abstract int getCipherSuiteTLS();

    protected abstract byte[] getIDArray();

    protected abstract JsseSecurityParameters getJsseSecurityParameters();

    protected abstract JsseSessionParameters getJsseSessionParameters();

    protected abstract Certificate getLocalCertificateTLS();

    protected abstract Certificate getPeerCertificateTLS();

    protected abstract ProtocolVersion getProtocolTLS();

    protected abstract void invalidateTLS();

    SSLSession getExportSSLSession() {
        return this.exportSSLSession;
    }

    void accessedAt(long accessTime) {
        long current = this.lastAccessedTime.get();
        if (accessTime > current) {
            this.lastAccessedTime.compareAndSet(current, accessTime);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProvSSLSessionBase)) {
            return false;
        }
        ProvSSLSessionBase other = (ProvSSLSessionBase)obj;
        return Arrays.areEqual((byte[])this.getIDArray(), (byte[])other.getIDArray());
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String getCipherSuite() {
        return ProvSSLContextSpi.getCipherSuiteName(this.getCipherSuiteTLS());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        byte[] id = this.getIDArray();
        return TlsUtils.isNullOrEmpty(id) ? TlsUtils.EMPTY_BYTES : (byte[])id.clone();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime.get();
    }

    public java.security.cert.Certificate[] getLocalCertificates() {
        java.security.cert.Certificate[] chain;
        if (null != this.crypto && null != (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getLocalCertificateTLS())) && chain.length > 0) {
            return chain;
        }
        return null;
    }

    public Principal getLocalPrincipal() {
        if (null != this.crypto) {
            return JsseUtils.getSubject(this.crypto, this.getLocalCertificateTLS());
        }
        return null;
    }

    public int getPacketBufferSize() {
        ProtocolVersion protocolVersion = this.getProtocolTLS();
        if (null == protocolVersion || !TlsUtils.isTLSv11(protocolVersion)) {
            return 18443;
        }
        if (TlsUtils.isTLSv13(protocolVersion)) {
            return 16911;
        }
        return 17413;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return OldCertUtil.getPeerCertificateChain(this);
    }

    public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        java.security.cert.Certificate[] chain;
        if (null != this.crypto && null != (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getPeerCertificateTLS())) && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal;
        if (null != this.crypto && null != (principal = JsseUtils.getSubject(this.crypto, this.getPeerCertificateTLS()))) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getProtocol() {
        return ProvSSLContextSpi.getProtocolVersionName(this.getProtocolTLS());
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.sslSessionContext.get();
    }

    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.getIDArray());
    }

    public final void invalidate() {
        this.implInvalidate(true);
    }

    final void invalidatedBySessionContext() {
        this.implInvalidate(false);
    }

    public boolean isFipsMode() {
        return this.isFips;
    }

    public boolean isValid() {
        if (null == this.sslSessionContext.get()) {
            return false;
        }
        return !TlsUtils.isNullOrEmpty(this.getIDArray());
    }

    public void putValue(String name, Object value) {
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    public void removeValue(String name) {
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    public String toString() {
        return "Session(" + this.getCreationTime() + "|" + this.getCipherSuite() + ")";
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    private void implInvalidate(boolean removeFromSessionContext) {
        if (removeFromSessionContext) {
            ProvSSLSessionContext context = this.sslSessionContext.getAndSet(null);
            if (null != context) {
                context.removeSession(this.getIDArray());
            }
        } else {
            this.sslSessionContext.set(null);
        }
        this.invalidateTLS();
    }
}

