/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.util.Arrays;

public class RSAUtil {
    private static final byte[] RSAPSSParams_256_A;
    private static final byte[] RSAPSSParams_384_A;
    private static final byte[] RSAPSSParams_512_A;
    private static final byte[] RSAPSSParams_256_B;
    private static final byte[] RSAPSSParams_384_B;
    private static final byte[] RSAPSSParams_512_B;

    public static boolean supportsPKCS1(AlgorithmIdentifier pubKeyAlgID) {
        ASN1ObjectIdentifier oid = pubKeyAlgID.getAlgorithm();
        return PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)oid) || X509ObjectIdentifiers.id_ea_rsa.equals((ASN1Primitive)oid);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean supportsPSS_PSS(short signatureAlgorithm, AlgorithmIdentifier pubKeyAlgID) {
        void var6_7;
        void var5_6;
        byte[] encoded;
        ASN1ObjectIdentifier oid = pubKeyAlgID.getAlgorithm();
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)oid)) {
            return false;
        }
        ASN1Encodable pssParams = pubKeyAlgID.getParameters();
        if (null == pssParams || pssParams instanceof ASN1Null) {
            switch (signatureAlgorithm) {
                case 9: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return false;
        }
        try {
            encoded = pssParams.toASN1Primitive().getEncoded("DER");
        }
        catch (Exception e) {
            return false;
        }
        switch (signatureAlgorithm) {
            case 9: {
                byte[] expected_A = RSAPSSParams_256_A;
                byte[] expected_B = RSAPSSParams_256_B;
                break;
            }
            case 10: {
                byte[] expected_A = RSAPSSParams_384_A;
                byte[] expected_B = RSAPSSParams_384_B;
                break;
            }
            case 11: {
                byte[] expected_A = RSAPSSParams_512_A;
                byte[] expected_B = RSAPSSParams_512_B;
                break;
            }
            default: {
                return false;
            }
        }
        return Arrays.areEqual((byte[])var5_6, (byte[])encoded) || Arrays.areEqual((byte[])var6_7, (byte[])encoded);
    }

    public static boolean supportsPSS_RSAE(AlgorithmIdentifier pubKeyAlgID) {
        ASN1ObjectIdentifier oid = pubKeyAlgID.getAlgorithm();
        return PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)oid);
    }

    static {
        AlgorithmIdentifier sha256Identifier_A = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        AlgorithmIdentifier sha384Identifier_A = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384);
        AlgorithmIdentifier sha512Identifier_A = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512);
        AlgorithmIdentifier sha256Identifier_B = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier sha384Identifier_B = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier sha512Identifier_B = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier mgf1SHA256Identifier_A = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)sha256Identifier_A);
        AlgorithmIdentifier mgf1SHA384Identifier_A = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)sha384Identifier_A);
        AlgorithmIdentifier mgf1SHA512Identifier_A = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)sha512Identifier_A);
        AlgorithmIdentifier mgf1SHA256Identifier_B = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)sha256Identifier_B);
        AlgorithmIdentifier mgf1SHA384Identifier_B = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)sha384Identifier_B);
        AlgorithmIdentifier mgf1SHA512Identifier_B = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)sha512Identifier_B);
        ASN1Integer sha256Size = new ASN1Integer((long)TlsCryptoUtils.getHashOutputSize(4));
        ASN1Integer sha384Size = new ASN1Integer((long)TlsCryptoUtils.getHashOutputSize(5));
        ASN1Integer sha512Size = new ASN1Integer((long)TlsCryptoUtils.getHashOutputSize(6));
        ASN1Integer trailerField = new ASN1Integer(1L);
        try {
            RSAPSSParams_256_A = new RSASSAPSSparams(sha256Identifier_A, mgf1SHA256Identifier_A, sha256Size, trailerField).getEncoded("DER");
            RSAPSSParams_384_A = new RSASSAPSSparams(sha384Identifier_A, mgf1SHA384Identifier_A, sha384Size, trailerField).getEncoded("DER");
            RSAPSSParams_512_A = new RSASSAPSSparams(sha512Identifier_A, mgf1SHA512Identifier_A, sha512Size, trailerField).getEncoded("DER");
            RSAPSSParams_256_B = new RSASSAPSSparams(sha256Identifier_B, mgf1SHA256Identifier_B, sha256Size, trailerField).getEncoded("DER");
            RSAPSSParams_384_B = new RSASSAPSSparams(sha384Identifier_B, mgf1SHA384Identifier_B, sha384Size, trailerField).getEncoded("DER");
            RSAPSSParams_512_B = new RSASSAPSSparams(sha512Identifier_B, mgf1SHA512Identifier_B, sha512Size, trailerField).getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

