/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.legacy.crypto.sike.Fpx;
import org.bouncycastle.pqc.legacy.crypto.sike.Internal;
import org.bouncycastle.pqc.legacy.crypto.sike.Isogeny;
import org.bouncycastle.pqc.legacy.crypto.sike.P434;
import org.bouncycastle.pqc.legacy.crypto.sike.P503;
import org.bouncycastle.pqc.legacy.crypto.sike.P610;
import org.bouncycastle.pqc.legacy.crypto.sike.P751;
import org.bouncycastle.pqc.legacy.crypto.sike.SIDH;
import org.bouncycastle.pqc.legacy.crypto.sike.SIDH_Compressed;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SIKEEngine {
    protected Internal params;
    protected Isogeny isogeny;
    protected Fpx fpx;
    private SIDH sidh;
    private SIDH_Compressed sidhCompressed;
    private boolean isCompressed;

    public int getDefaultSessionKeySize() {
        return this.params.MSG_BYTES * 8;
    }

    public int getCipherTextSize() {
        return this.params.CRYPTO_CIPHERTEXTBYTES;
    }

    public int getPrivateKeySize() {
        return this.params.CRYPTO_SECRETKEYBYTES;
    }

    public int getPublicKeySize() {
        return this.params.CRYPTO_PUBLICKEYBYTES;
    }

    public SIKEEngine(int ver, boolean isCompressed) {
        this.isCompressed = isCompressed;
        switch (ver) {
            case 434: {
                this.params = new P434(isCompressed);
                break;
            }
            case 503: {
                this.params = new P503(isCompressed);
                break;
            }
            case 610: {
                this.params = new P610(isCompressed);
                break;
            }
            case 751: {
                this.params = new P751(isCompressed);
                break;
            }
        }
        this.fpx = new Fpx(this);
        this.isogeny = new Isogeny(this);
        if (isCompressed) {
            this.sidhCompressed = new SIDH_Compressed(this);
        }
        this.sidh = new SIDH(this);
    }

    public int crypto_kem_keypair(byte[] pk, byte[] sk, SecureRandom random) {
        byte[] s = new byte[this.params.MSG_BYTES];
        random.nextBytes(s);
        if (this.isCompressed) {
            byte[] random_digits = new byte[this.params.SECRETKEY_A_BYTES];
            random.nextBytes(random_digits);
            random_digits[0] = (byte)(random_digits[0] & 0xFE);
            int n = this.params.SECRETKEY_A_BYTES - 1;
            random_digits[n] = (byte)(random_digits[n] & this.params.MASK_ALICE);
            System.arraycopy(s, 0, sk, 0, this.params.MSG_BYTES);
            System.arraycopy(random_digits, 0, sk, this.params.MSG_BYTES, this.params.SECRETKEY_A_BYTES);
            this.sidhCompressed.EphemeralKeyGeneration_A_extended(sk, pk);
            System.arraycopy(pk, 0, sk, this.params.MSG_BYTES + this.params.SECRETKEY_A_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        } else {
            byte[] random_digits = new byte[this.params.SECRETKEY_B_BYTES];
            random.nextBytes(random_digits);
            int n = this.params.SECRETKEY_B_BYTES - 1;
            random_digits[n] = (byte)(random_digits[n] & this.params.MASK_BOB);
            System.arraycopy(s, 0, sk, 0, this.params.MSG_BYTES);
            System.arraycopy(random_digits, 0, sk, this.params.MSG_BYTES, this.params.SECRETKEY_B_BYTES);
            this.sidh.EphemeralKeyGeneration_B(sk, pk);
            System.arraycopy(pk, 0, sk, this.params.MSG_BYTES + this.params.SECRETKEY_B_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        }
        return 0;
    }

    public int crypto_kem_enc(byte[] ct, byte[] ss, byte[] pk, SecureRandom random) {
        if (this.isCompressed) {
            byte[] ephemeralsk = new byte[this.params.SECRETKEY_B_BYTES];
            byte[] jinvariant = new byte[this.params.FP2_ENCODED_BYTES];
            byte[] h = new byte[this.params.MSG_BYTES];
            byte[] temp = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
            byte[] tmp = new byte[this.params.MSG_BYTES];
            random.nextBytes(tmp);
            System.arraycopy(tmp, 0, temp, 0, this.params.MSG_BYTES);
            System.arraycopy(pk, 0, temp, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
            SHAKEDigest digest = new SHAKEDigest(256);
            digest.update(temp, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
            digest.doFinal(ephemeralsk, 0, this.params.SECRETKEY_B_BYTES);
            this.sidhCompressed.FormatPrivKey_B(ephemeralsk);
            this.sidhCompressed.EphemeralKeyGeneration_B_extended(ephemeralsk, ct, 1);
            this.sidhCompressed.EphemeralSecretAgreement_B(ephemeralsk, pk, jinvariant);
            digest.update(jinvariant, 0, this.params.FP2_ENCODED_BYTES);
            digest.doFinal(h, 0, this.params.MSG_BYTES);
            for (int i = 0; i < this.params.MSG_BYTES; ++i) {
                ct[i + this.params.PARTIALLY_COMPRESSED_CHUNK_CT] = (byte)(temp[i] ^ h[i]);
            }
            System.arraycopy(ct, 0, temp, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
            digest.update(temp, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
            digest.doFinal(ss, 0, this.params.CRYPTO_BYTES);
            return 0;
        }
        byte[] ephemeralsk = new byte[this.params.SECRETKEY_A_BYTES];
        byte[] jinvariant = new byte[this.params.FP2_ENCODED_BYTES];
        byte[] h = new byte[this.params.MSG_BYTES];
        byte[] temp = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
        byte[] tmp = new byte[this.params.MSG_BYTES];
        random.nextBytes(tmp);
        System.arraycopy(tmp, 0, temp, 0, this.params.MSG_BYTES);
        System.arraycopy(pk, 0, temp, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        SHAKEDigest digest = new SHAKEDigest(256);
        digest.update(temp, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
        digest.doFinal(ephemeralsk, 0, this.params.SECRETKEY_A_BYTES);
        int n = this.params.SECRETKEY_A_BYTES - 1;
        ephemeralsk[n] = (byte)(ephemeralsk[n] & this.params.MASK_ALICE);
        this.sidh.EphemeralKeyGeneration_A(ephemeralsk, ct);
        this.sidh.EphemeralSecretAgreement_A(ephemeralsk, pk, jinvariant);
        digest.update(jinvariant, 0, this.params.FP2_ENCODED_BYTES);
        digest.doFinal(h, 0, this.params.MSG_BYTES);
        for (int i = 0; i < this.params.MSG_BYTES; ++i) {
            ct[i + this.params.CRYPTO_PUBLICKEYBYTES] = (byte)(temp[i] ^ h[i]);
        }
        System.arraycopy(ct, 0, temp, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
        digest.update(temp, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
        digest.doFinal(ss, 0, this.params.CRYPTO_BYTES);
        return 0;
    }

    public int crypto_kem_dec(byte[] ss, byte[] ct, byte[] sk) {
        if (this.isCompressed) {
            byte[] ephemeralsk_ = new byte[this.params.SECRETKEY_B_BYTES];
            byte[] jinvariant_ = new byte[this.params.FP2_ENCODED_BYTES + 2 * this.params.FP2_ENCODED_BYTES + this.params.SECRETKEY_A_BYTES];
            byte[] h_ = new byte[this.params.MSG_BYTES];
            byte[] temp = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
            byte[] tphiBKA_t = jinvariant_;
            this.sidhCompressed.EphemeralSecretAgreement_A_extended(sk, this.params.MSG_BYTES, ct, jinvariant_, 1);
            SHAKEDigest digest = new SHAKEDigest(256);
            digest.update(jinvariant_, 0, this.params.FP2_ENCODED_BYTES);
            digest.doFinal(h_, 0, this.params.MSG_BYTES);
            for (int i = 0; i < this.params.MSG_BYTES; ++i) {
                temp[i] = (byte)(ct[i + this.params.PARTIALLY_COMPRESSED_CHUNK_CT] ^ h_[i]);
            }
            System.arraycopy(sk, this.params.MSG_BYTES + this.params.SECRETKEY_A_BYTES, temp, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
            digest.update(temp, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
            digest.doFinal(ephemeralsk_, 0, this.params.SECRETKEY_B_BYTES);
            this.sidhCompressed.FormatPrivKey_B(ephemeralsk_);
            byte selector = this.sidhCompressed.validate_ciphertext(ephemeralsk_, ct, sk, this.params.MSG_BYTES + this.params.SECRETKEY_A_BYTES + this.params.CRYPTO_PUBLICKEYBYTES, tphiBKA_t, this.params.FP2_ENCODED_BYTES);
            this.fpx.ct_cmov(temp, sk, this.params.MSG_BYTES, selector);
            System.arraycopy(ct, 0, temp, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
            digest.update(temp, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
            digest.doFinal(ss, 0, this.params.CRYPTO_BYTES);
            return 0;
        }
        byte[] ephemeralsk_ = new byte[this.params.SECRETKEY_A_BYTES];
        byte[] jinvariant_ = new byte[this.params.FP2_ENCODED_BYTES];
        byte[] h_ = new byte[this.params.MSG_BYTES];
        byte[] c0_ = new byte[this.params.CRYPTO_PUBLICKEYBYTES];
        byte[] temp = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
        this.sidh.EphemeralSecretAgreement_B(sk, ct, jinvariant_);
        SHAKEDigest digest = new SHAKEDigest(256);
        digest.update(jinvariant_, 0, this.params.FP2_ENCODED_BYTES);
        digest.doFinal(h_, 0, this.params.MSG_BYTES);
        for (int i = 0; i < this.params.MSG_BYTES; ++i) {
            temp[i] = (byte)(ct[i + this.params.CRYPTO_PUBLICKEYBYTES] ^ h_[i]);
        }
        System.arraycopy(sk, this.params.MSG_BYTES + this.params.SECRETKEY_B_BYTES, temp, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        digest.update(temp, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
        digest.doFinal(ephemeralsk_, 0, this.params.SECRETKEY_A_BYTES);
        int n = this.params.SECRETKEY_A_BYTES - 1;
        ephemeralsk_[n] = (byte)(ephemeralsk_[n] & this.params.MASK_ALICE);
        this.sidh.EphemeralKeyGeneration_A(ephemeralsk_, c0_);
        byte selector = this.fpx.ct_compare(c0_, ct, this.params.CRYPTO_PUBLICKEYBYTES);
        this.fpx.ct_cmov(temp, sk, this.params.MSG_BYTES, selector);
        System.arraycopy(ct, 0, temp, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
        digest.update(temp, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
        digest.doFinal(ss, 0, this.params.CRYPTO_BYTES);
        return 0;
    }
}

