/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincsplus;

import org.bouncycastle.pqc.crypto.sphincsplus.HarakaSBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HarakaSXof
extends HarakaSBase {
    public String getAlgorithmName() {
        return "Haraka-S";
    }

    public HarakaSXof(byte[] pkSeed) {
        byte[] buf = new byte[640];
        this.update(pkSeed, 0, pkSeed.length);
        this.doFinal(buf, 0, buf.length);
        this.haraka512_rc = new long[10][8];
        this.haraka256_rc = new int[10][8];
        for (int i = 0; i < 10; ++i) {
            this.interleaveConstant32(this.haraka256_rc[i], buf, i << 5);
            this.interleaveConstant(this.haraka512_rc[i], buf, i << 6);
        }
    }

    public void update(byte[] input, int inOff, int len) {
        int i = inOff;
        int loop = len + this.off >> 5;
        for (int j = 0; j < loop; ++j) {
            while (this.off < 32) {
                int n = this.off++;
                this.buffer[n] = (byte)(this.buffer[n] ^ input[i++]);
            }
            this.haraka512Perm(this.buffer);
            this.off = 0;
        }
        while (i < inOff + len) {
            int n = this.off++;
            this.buffer[n] = (byte)(this.buffer[n] ^ input[i++]);
        }
    }

    public void update(byte input) {
        int n = this.off++;
        this.buffer[n] = (byte)(this.buffer[n] ^ input);
        if (this.off == 32) {
            this.haraka512Perm(this.buffer);
            this.off = 0;
        }
    }

    public int doFinal(byte[] out, int outOff, int len) {
        int outLen = len;
        int n = this.off;
        this.buffer[n] = (byte)(this.buffer[n] ^ 0x1F);
        this.buffer[31] = (byte)(this.buffer[31] ^ 0x80);
        this.off = 0;
        while (len > 0) {
            int i;
            this.haraka512Perm(this.buffer);
            for (i = 0; i < 32 && i + outOff < out.length; ++i) {
                out[i + outOff] = this.buffer[i];
            }
            outOff += i;
            len -= i;
        }
        if (len != 0) {
            byte[] d = new byte[64];
            this.haraka512Perm(d);
            System.arraycopy(d, 0, out, outOff, -len);
        }
        this.reset();
        return outLen;
    }
}

