/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincsplus;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.sphincsplus.HarakaSBase;
import org.bouncycastle.pqc.crypto.sphincsplus.HarakaSXof;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HarakaS512Digest
extends HarakaSBase
implements Digest {
    public HarakaS512Digest(HarakaSXof base) {
        this.haraka512_rc = base.haraka512_rc;
    }

    @Override
    public String getAlgorithmName() {
        return "HarakaS-512";
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public void update(byte in) {
        if (this.off + 1 > 64) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        this.buffer[this.off++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (this.off + len > 64) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        System.arraycopy(in, inOff, this.buffer, this.off, len);
        this.off += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] s = new byte[64];
        this.haraka512Perm(s);
        for (int i = 0; i < 64; ++i) {
            int n = i;
            s[n] = (byte)(s[n] ^ this.buffer[i]);
        }
        System.arraycopy(s, 8, out, outOff, 8);
        System.arraycopy(s, 24, out, outOff + 8, 8);
        System.arraycopy(s, 32, out, outOff + 16, 8);
        System.arraycopy(s, 48, out, outOff + 24, 8);
        this.reset();
        return s.length;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

