/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.pqc.crypto.hqc.Utils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ReedMuller {
    ReedMuller() {
    }

    static void encodeSub(Codeword codeword, int m) {
        int word1 = ReedMuller.Bit0Mask(m >> 7);
        word1 ^= ReedMuller.Bit0Mask(m >> 0) & 0xAAAAAAAA;
        word1 ^= ReedMuller.Bit0Mask(m >> 1) & 0xCCCCCCCC;
        word1 ^= ReedMuller.Bit0Mask(m >> 2) & 0xF0F0F0F0;
        word1 ^= ReedMuller.Bit0Mask(m >> 3) & 0xFF00FF00;
        codeword.type32[0] = word1 ^= ReedMuller.Bit0Mask(m >> 4) & 0xFFFF0000;
        codeword.type32[1] = word1 ^= ReedMuller.Bit0Mask(m >> 5);
        codeword.type32[3] = word1 ^= ReedMuller.Bit0Mask(m >> 6);
        codeword.type32[2] = word1 ^= ReedMuller.Bit0Mask(m >> 5);
    }

    private static void hadamardTransform(int[] srcCode, int[] desCode) {
        int[] srcCodeCopy = Arrays.clone(srcCode);
        int[] desCodeCopy = Arrays.clone(desCode);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 64; ++j) {
                desCodeCopy[j] = srcCodeCopy[2 * j] + srcCodeCopy[2 * j + 1];
                desCodeCopy[j + 64] = srcCodeCopy[2 * j] - srcCodeCopy[2 * j + 1];
            }
            int[] tmp = Arrays.clone(srcCodeCopy);
            srcCodeCopy = Arrays.clone(desCodeCopy);
            desCodeCopy = Arrays.clone(tmp);
        }
        System.arraycopy(desCodeCopy, 0, srcCode, 0, srcCode.length);
        System.arraycopy(srcCodeCopy, 0, desCode, 0, desCode.length);
    }

    private static void expandThenSum(int[] desCode, Codeword[] srcCode, int off, int mulParam) {
        int j;
        int i;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 32; ++j) {
                long ii = srcCode[0 + off].type32[i] >> j & 1;
                desCode[i * 32 + j] = srcCode[0 + off].type32[i] >> j & 1;
            }
        }
        for (i = 1; i < mulParam; ++i) {
            for (j = 0; j < 4; ++j) {
                for (int k = 0; k < 32; ++k) {
                    int n = j * 32 + k;
                    desCode[n] = desCode[n] + (srcCode[i + off].type32[j] >> k & 1);
                }
            }
        }
    }

    private static int findPeaks(int[] input) {
        int peakAbsVal = 0;
        int peakVal = 0;
        int peakPos = 0;
        for (int i = 0; i < 128; ++i) {
            int t = input[i];
            int posMask = t > 0 ? -1 : 0;
            int abs = posMask & t | ~posMask & -t;
            peakVal = abs > peakAbsVal ? t : peakVal;
            peakPos = abs > peakAbsVal ? i : peakPos;
            peakAbsVal = abs > peakAbsVal ? abs : peakAbsVal;
        }
        int tmp = peakVal > 0 ? 1 : 0;
        return peakPos |= 128 * tmp;
    }

    private static int Bit0Mask(int b) {
        return -(b & 1) & 0xFFFFFFFF;
    }

    public static void encode(long[] codeword, long[] m, int n1, int mulParam) {
        int i;
        byte[] mBytes = new byte[n1];
        Utils.fromLongArrayToByteArray(mBytes, m, n1 * 8);
        Codeword[] codewordCopy = new Codeword[n1 * mulParam];
        for (i = 0; i < codewordCopy.length; ++i) {
            codewordCopy[i] = new Codeword();
        }
        for (i = 0; i < n1; ++i) {
            int pos = i * mulParam;
            ReedMuller.encodeSub(codewordCopy[pos], mBytes[i]);
            for (int j = 1; j < mulParam; ++j) {
                codewordCopy[pos + j] = codewordCopy[pos];
            }
        }
        int[] cwd64 = new int[codewordCopy.length * 4];
        int off = 0;
        for (int i2 = 0; i2 < codewordCopy.length; ++i2) {
            System.arraycopy(codewordCopy[i2].type32, 0, cwd64, off, codewordCopy[i2].type32.length);
            off += 4;
        }
        Utils.fromByte32ArrayToLongArray(codeword, cwd64);
    }

    public static void decode(long[] m, long[] codeword, int n1, int mulParam) {
        byte[] mBytes = new byte[n1];
        Utils.fromLongArrayToByteArray(mBytes, m, n1 * 8);
        Codeword[] codewordCopy = new Codeword[codeword.length / 2];
        int[] byteCodeWords = new int[codeword.length * 2];
        Utils.fromLongArrayToByte32Array(byteCodeWords, codeword);
        for (int i = 0; i < codewordCopy.length; ++i) {
            codewordCopy[i] = new Codeword();
            for (int j = 0; j < 4; ++j) {
                codewordCopy[i].type32[j] = byteCodeWords[i * 4 + j];
            }
        }
        int[] expandedCodeword = new int[128];
        for (int i = 0; i < n1; ++i) {
            ReedMuller.expandThenSum(expandedCodeword, codewordCopy, i * mulParam, mulParam);
            int[] tmp = new int[128];
            ReedMuller.hadamardTransform(expandedCodeword, tmp);
            tmp[0] = tmp[0] - 64 * mulParam;
            int t = ReedMuller.findPeaks(tmp);
            mBytes[i] = (byte)ReedMuller.findPeaks(tmp);
        }
        int[] cwd64 = new int[codewordCopy.length * 4];
        int off = 0;
        for (int i = 0; i < codewordCopy.length; ++i) {
            System.arraycopy(codewordCopy[i].type32, 0, cwd64, off, codewordCopy[i].type32.length);
            off += 4;
        }
        Utils.fromByte32ArrayToLongArray(codeword, cwd64);
        Utils.fromByteArrayToLongArray(m, mBytes);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Codeword {
        int[] type32 = new int[4];
        int[] type8 = new int[16];
    }
}

