/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.pqc.legacy.crypto.gmss.GMSSLeaf;
import org.bouncycastle.pqc.legacy.crypto.gmss.GMSSParameters;
import org.bouncycastle.pqc.legacy.crypto.gmss.GMSSRootCalc;
import org.bouncycastle.pqc.legacy.crypto.gmss.GMSSRootSig;
import org.bouncycastle.pqc.legacy.crypto.gmss.Treehash;

public class GMSSPrivateKey
extends ASN1Object {
    private ASN1Primitive primitive;

    private GMSSPrivateKey(ASN1Sequence mtsPrivateKey) {
        ASN1Sequence indexPart = (ASN1Sequence)mtsPrivateKey.getObjectAt(0);
        int[] index = new int[indexPart.size()];
        for (int i = 0; i < indexPart.size(); ++i) {
            index[i] = GMSSPrivateKey.checkBigIntegerInIntRange(indexPart.getObjectAt(i));
        }
        ASN1Sequence curSeedsPart = (ASN1Sequence)mtsPrivateKey.getObjectAt(1);
        byte[][] curSeeds = new byte[curSeedsPart.size()][];
        for (int i = 0; i < curSeeds.length; ++i) {
            curSeeds[i] = ((DEROctetString)curSeedsPart.getObjectAt(i)).getOctets();
        }
        ASN1Sequence nextNextSeedsPart = (ASN1Sequence)mtsPrivateKey.getObjectAt(2);
        byte[][] nextNextSeeds = new byte[nextNextSeedsPart.size()][];
        for (int i = 0; i < nextNextSeeds.length; ++i) {
            nextNextSeeds[i] = ((DEROctetString)nextNextSeedsPart.getObjectAt(i)).getOctets();
        }
        ASN1Sequence curAuthPart0 = (ASN1Sequence)mtsPrivateKey.getObjectAt(3);
        byte[][][] curAuth = new byte[curAuthPart0.size()][][];
        for (int i = 0; i < curAuth.length; ++i) {
            ASN1Sequence curAuthPart1 = (ASN1Sequence)curAuthPart0.getObjectAt(i);
            curAuth[i] = new byte[curAuthPart1.size()][];
            for (int j = 0; j < curAuth[i].length; ++j) {
                curAuth[i][j] = ((DEROctetString)curAuthPart1.getObjectAt(j)).getOctets();
            }
        }
        ASN1Sequence nextAuthPart0 = (ASN1Sequence)mtsPrivateKey.getObjectAt(4);
        byte[][][] nextAuth = new byte[nextAuthPart0.size()][][];
        for (int i = 0; i < nextAuth.length; ++i) {
            ASN1Sequence nextAuthPart1 = (ASN1Sequence)nextAuthPart0.getObjectAt(i);
            nextAuth[i] = new byte[nextAuthPart1.size()][];
            for (int j = 0; j < nextAuth[i].length; ++j) {
                nextAuth[i][j] = ((DEROctetString)nextAuthPart1.getObjectAt(j)).getOctets();
            }
        }
        ASN1Sequence seqOfcurTreehash0 = (ASN1Sequence)mtsPrivateKey.getObjectAt(5);
        Treehash[][] curTreehash = new Treehash[seqOfcurTreehash0.size()][];
    }

    public GMSSPrivateKey(int[] index, byte[][] currentSeed, byte[][] nextNextSeed, byte[][][] currentAuthPath, byte[][][] nextAuthPath, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, byte[][][] keep, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, AlgorithmIdentifier digestAlg) {
        AlgorithmIdentifier[] names = new AlgorithmIdentifier[]{digestAlg};
        this.primitive = this.encode(index, currentSeed, nextNextSeed, currentAuthPath, nextAuthPath, keep, currentTreehash, nextTreehash, currentStack, nextStack, currentRetain, nextRetain, nextNextLeaf, upperLeaf, upperTreehashLeaf, minTreehash, nextRoot, nextNextRoot, currentRootSig, nextRootSig, gmssParameterset, names);
    }

    private ASN1Primitive encode(int[] index, byte[][] currentSeeds, byte[][] nextNextSeeds, byte[][][] currentAuthPaths, byte[][][] nextAuthPaths, byte[][][] keep, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, AlgorithmIdentifier[] algorithms) {
        int k;
        int tailLength;
        int j;
        int i;
        ASN1EncodableVector result = new ASN1EncodableVector();
        ASN1EncodableVector indexPart = new ASN1EncodableVector();
        for (int i2 = 0; i2 < index.length; ++i2) {
            indexPart.add(new ASN1Integer(index[i2]));
        }
        result.add(new DERSequence(indexPart));
        ASN1EncodableVector curSeedsPart = new ASN1EncodableVector();
        for (int i3 = 0; i3 < currentSeeds.length; ++i3) {
            curSeedsPart.add(new DEROctetString(currentSeeds[i3]));
        }
        result.add(new DERSequence(curSeedsPart));
        ASN1EncodableVector nextNextSeedsPart = new ASN1EncodableVector();
        for (int i4 = 0; i4 < nextNextSeeds.length; ++i4) {
            nextNextSeedsPart.add(new DEROctetString(nextNextSeeds[i4]));
        }
        result.add(new DERSequence(nextNextSeedsPart));
        ASN1EncodableVector curAuthPart0 = new ASN1EncodableVector();
        ASN1EncodableVector curAuthPart1 = new ASN1EncodableVector();
        for (int i5 = 0; i5 < currentAuthPaths.length; ++i5) {
            for (int j2 = 0; j2 < currentAuthPaths[i5].length; ++j2) {
                curAuthPart0.add(new DEROctetString(currentAuthPaths[i5][j2]));
            }
            curAuthPart1.add(new DERSequence(curAuthPart0));
            curAuthPart0 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(curAuthPart1));
        ASN1EncodableVector nextAuthPart0 = new ASN1EncodableVector();
        ASN1EncodableVector nextAuthPart1 = new ASN1EncodableVector();
        for (int i6 = 0; i6 < nextAuthPaths.length; ++i6) {
            for (int j3 = 0; j3 < nextAuthPaths[i6].length; ++j3) {
                nextAuthPart0.add(new DEROctetString(nextAuthPaths[i6][j3]));
            }
            nextAuthPart1.add(new DERSequence(nextAuthPart0));
            nextAuthPart0 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(nextAuthPart1));
        ASN1EncodableVector seqOfTreehash0 = new ASN1EncodableVector();
        ASN1EncodableVector seqOfTreehash1 = new ASN1EncodableVector();
        ASN1EncodableVector seqOfStat = new ASN1EncodableVector();
        ASN1EncodableVector seqOfByte = new ASN1EncodableVector();
        ASN1EncodableVector seqOfInt = new ASN1EncodableVector();
        for (i = 0; i < currentTreehash.length; ++i) {
            for (j = 0; j < currentTreehash[i].length; ++j) {
                seqOfStat.add(new DERSequence(algorithms[0]));
                tailLength = currentTreehash[i][j].getStatInt()[1];
                seqOfByte.add(new DEROctetString(currentTreehash[i][j].getStatByte()[0]));
                seqOfByte.add(new DEROctetString(currentTreehash[i][j].getStatByte()[1]));
                seqOfByte.add(new DEROctetString(currentTreehash[i][j].getStatByte()[2]));
                for (k = 0; k < tailLength; ++k) {
                    seqOfByte.add(new DEROctetString(currentTreehash[i][j].getStatByte()[3 + k]));
                }
                seqOfStat.add(new DERSequence(seqOfByte));
                seqOfByte = new ASN1EncodableVector();
                seqOfInt.add(new ASN1Integer(currentTreehash[i][j].getStatInt()[0]));
                seqOfInt.add(new ASN1Integer(tailLength));
                seqOfInt.add(new ASN1Integer(currentTreehash[i][j].getStatInt()[2]));
                seqOfInt.add(new ASN1Integer(currentTreehash[i][j].getStatInt()[3]));
                seqOfInt.add(new ASN1Integer(currentTreehash[i][j].getStatInt()[4]));
                seqOfInt.add(new ASN1Integer(currentTreehash[i][j].getStatInt()[5]));
                for (k = 0; k < tailLength; ++k) {
                    seqOfInt.add(new ASN1Integer(currentTreehash[i][j].getStatInt()[6 + k]));
                }
                seqOfStat.add(new DERSequence(seqOfInt));
                seqOfInt = new ASN1EncodableVector();
                seqOfTreehash1.add(new DERSequence(seqOfStat));
                seqOfStat = new ASN1EncodableVector();
            }
            seqOfTreehash0.add(new DERSequence(seqOfTreehash1));
            seqOfTreehash1 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(seqOfTreehash0));
        seqOfTreehash0 = new ASN1EncodableVector();
        seqOfTreehash1 = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        for (i = 0; i < nextTreehash.length; ++i) {
            for (j = 0; j < nextTreehash[i].length; ++j) {
                seqOfStat.add(new DERSequence(algorithms[0]));
                tailLength = nextTreehash[i][j].getStatInt()[1];
                seqOfByte.add(new DEROctetString(nextTreehash[i][j].getStatByte()[0]));
                seqOfByte.add(new DEROctetString(nextTreehash[i][j].getStatByte()[1]));
                seqOfByte.add(new DEROctetString(nextTreehash[i][j].getStatByte()[2]));
                for (k = 0; k < tailLength; ++k) {
                    seqOfByte.add(new DEROctetString(nextTreehash[i][j].getStatByte()[3 + k]));
                }
                seqOfStat.add(new DERSequence(seqOfByte));
                seqOfByte = new ASN1EncodableVector();
                seqOfInt.add(new ASN1Integer(nextTreehash[i][j].getStatInt()[0]));
                seqOfInt.add(new ASN1Integer(tailLength));
                seqOfInt.add(new ASN1Integer(nextTreehash[i][j].getStatInt()[2]));
                seqOfInt.add(new ASN1Integer(nextTreehash[i][j].getStatInt()[3]));
                seqOfInt.add(new ASN1Integer(nextTreehash[i][j].getStatInt()[4]));
                seqOfInt.add(new ASN1Integer(nextTreehash[i][j].getStatInt()[5]));
                for (k = 0; k < tailLength; ++k) {
                    seqOfInt.add(new ASN1Integer(nextTreehash[i][j].getStatInt()[6 + k]));
                }
                seqOfStat.add(new DERSequence(seqOfInt));
                seqOfInt = new ASN1EncodableVector();
                seqOfTreehash1.add(new DERSequence(seqOfStat));
                seqOfStat = new ASN1EncodableVector();
            }
            seqOfTreehash0.add(new DERSequence(new DERSequence(seqOfTreehash1)));
            seqOfTreehash1 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(seqOfTreehash0));
        ASN1EncodableVector keepPart0 = new ASN1EncodableVector();
        ASN1EncodableVector keepPart1 = new ASN1EncodableVector();
        for (int i7 = 0; i7 < keep.length; ++i7) {
            for (int j4 = 0; j4 < keep[i7].length; ++j4) {
                keepPart0.add(new DEROctetString(keep[i7][j4]));
            }
            keepPart1.add(new DERSequence(keepPart0));
            keepPart0 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(keepPart1));
        ASN1EncodableVector curStackPart0 = new ASN1EncodableVector();
        ASN1EncodableVector curStackPart1 = new ASN1EncodableVector();
        for (int i8 = 0; i8 < currentStack.length; ++i8) {
            for (int j5 = 0; j5 < currentStack[i8].size(); ++j5) {
                curStackPart0.add(new DEROctetString((byte[])currentStack[i8].elementAt(j5)));
            }
            curStackPart1.add(new DERSequence(curStackPart0));
            curStackPart0 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(curStackPart1));
        ASN1EncodableVector nextStackPart0 = new ASN1EncodableVector();
        ASN1EncodableVector nextStackPart1 = new ASN1EncodableVector();
        for (int i9 = 0; i9 < nextStack.length; ++i9) {
            for (int j6 = 0; j6 < nextStack[i9].size(); ++j6) {
                nextStackPart0.add(new DEROctetString((byte[])nextStack[i9].elementAt(j6)));
            }
            nextStackPart1.add(new DERSequence(nextStackPart0));
            nextStackPart0 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(nextStackPart1));
        ASN1EncodableVector currentRetainPart0 = new ASN1EncodableVector();
        ASN1EncodableVector currentRetainPart1 = new ASN1EncodableVector();
        ASN1EncodableVector currentRetainPart2 = new ASN1EncodableVector();
        for (int i10 = 0; i10 < currentRetain.length; ++i10) {
            for (int j7 = 0; j7 < currentRetain[i10].length; ++j7) {
                for (int k2 = 0; k2 < currentRetain[i10][j7].size(); ++k2) {
                    currentRetainPart0.add(new DEROctetString((byte[])currentRetain[i10][j7].elementAt(k2)));
                }
                currentRetainPart1.add(new DERSequence(currentRetainPart0));
                currentRetainPart0 = new ASN1EncodableVector();
            }
            currentRetainPart2.add(new DERSequence(currentRetainPart1));
            currentRetainPart1 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(currentRetainPart2));
        ASN1EncodableVector nextRetainPart0 = new ASN1EncodableVector();
        ASN1EncodableVector nextRetainPart1 = new ASN1EncodableVector();
        ASN1EncodableVector nextRetainPart2 = new ASN1EncodableVector();
        for (int i11 = 0; i11 < nextRetain.length; ++i11) {
            for (int j8 = 0; j8 < nextRetain[i11].length; ++j8) {
                for (int k3 = 0; k3 < nextRetain[i11][j8].size(); ++k3) {
                    nextRetainPart0.add(new DEROctetString((byte[])nextRetain[i11][j8].elementAt(k3)));
                }
                nextRetainPart1.add(new DERSequence(nextRetainPart0));
                nextRetainPart0 = new ASN1EncodableVector();
            }
            nextRetainPart2.add(new DERSequence(nextRetainPart1));
            nextRetainPart1 = new ASN1EncodableVector();
        }
        result.add(new DERSequence(nextRetainPart2));
        ASN1EncodableVector seqOfLeaf = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        for (int i12 = 0; i12 < nextNextLeaf.length; ++i12) {
            seqOfStat.add(new DERSequence(algorithms[0]));
            byte[][] tempByte = nextNextLeaf[i12].getStatByte();
            seqOfByte.add(new DEROctetString(tempByte[0]));
            seqOfByte.add(new DEROctetString(tempByte[1]));
            seqOfByte.add(new DEROctetString(tempByte[2]));
            seqOfByte.add(new DEROctetString(tempByte[3]));
            seqOfStat.add(new DERSequence(seqOfByte));
            seqOfByte = new ASN1EncodableVector();
            int[] tempInt = nextNextLeaf[i12].getStatInt();
            seqOfInt.add(new ASN1Integer(tempInt[0]));
            seqOfInt.add(new ASN1Integer(tempInt[1]));
            seqOfInt.add(new ASN1Integer(tempInt[2]));
            seqOfInt.add(new ASN1Integer(tempInt[3]));
            seqOfStat.add(new DERSequence(seqOfInt));
            seqOfInt = new ASN1EncodableVector();
            seqOfLeaf.add(new DERSequence(seqOfStat));
            seqOfStat = new ASN1EncodableVector();
        }
        result.add(new DERSequence(seqOfLeaf));
        ASN1EncodableVector seqOfUpperLeaf = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        for (int i13 = 0; i13 < upperLeaf.length; ++i13) {
            seqOfStat.add(new DERSequence(algorithms[0]));
            byte[][] tempByte = upperLeaf[i13].getStatByte();
            seqOfByte.add(new DEROctetString(tempByte[0]));
            seqOfByte.add(new DEROctetString(tempByte[1]));
            seqOfByte.add(new DEROctetString(tempByte[2]));
            seqOfByte.add(new DEROctetString(tempByte[3]));
            seqOfStat.add(new DERSequence(seqOfByte));
            seqOfByte = new ASN1EncodableVector();
            int[] tempInt = upperLeaf[i13].getStatInt();
            seqOfInt.add(new ASN1Integer(tempInt[0]));
            seqOfInt.add(new ASN1Integer(tempInt[1]));
            seqOfInt.add(new ASN1Integer(tempInt[2]));
            seqOfInt.add(new ASN1Integer(tempInt[3]));
            seqOfStat.add(new DERSequence(seqOfInt));
            seqOfInt = new ASN1EncodableVector();
            seqOfUpperLeaf.add(new DERSequence(seqOfStat));
            seqOfStat = new ASN1EncodableVector();
        }
        result.add(new DERSequence(seqOfUpperLeaf));
        ASN1EncodableVector seqOfUpperTreehashLeaf = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        for (int i14 = 0; i14 < upperTreehashLeaf.length; ++i14) {
            seqOfStat.add(new DERSequence(algorithms[0]));
            byte[][] tempByte = upperTreehashLeaf[i14].getStatByte();
            seqOfByte.add(new DEROctetString(tempByte[0]));
            seqOfByte.add(new DEROctetString(tempByte[1]));
            seqOfByte.add(new DEROctetString(tempByte[2]));
            seqOfByte.add(new DEROctetString(tempByte[3]));
            seqOfStat.add(new DERSequence(seqOfByte));
            seqOfByte = new ASN1EncodableVector();
            int[] tempInt = upperTreehashLeaf[i14].getStatInt();
            seqOfInt.add(new ASN1Integer(tempInt[0]));
            seqOfInt.add(new ASN1Integer(tempInt[1]));
            seqOfInt.add(new ASN1Integer(tempInt[2]));
            seqOfInt.add(new ASN1Integer(tempInt[3]));
            seqOfStat.add(new DERSequence(seqOfInt));
            seqOfInt = new ASN1EncodableVector();
            seqOfUpperTreehashLeaf.add(new DERSequence(seqOfStat));
            seqOfStat = new ASN1EncodableVector();
        }
        result.add(new DERSequence(seqOfUpperTreehashLeaf));
        ASN1EncodableVector minTreehashPart = new ASN1EncodableVector();
        for (int i15 = 0; i15 < minTreehash.length; ++i15) {
            minTreehashPart.add(new ASN1Integer(minTreehash[i15]));
        }
        result.add(new DERSequence(minTreehashPart));
        ASN1EncodableVector nextRootPart = new ASN1EncodableVector();
        for (int i16 = 0; i16 < nextRoot.length; ++i16) {
            nextRootPart.add(new DEROctetString(nextRoot[i16]));
        }
        result.add(new DERSequence(nextRootPart));
        ASN1EncodableVector seqOfnextNextRoot = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRStats = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRStrings = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRBytes = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRInts = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRTreehash = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRRetain = new ASN1EncodableVector();
        for (int i17 = 0; i17 < nextNextRoot.length; ++i17) {
            int k4;
            int j9;
            seqOfnnRStats.add(new DERSequence(algorithms[0]));
            seqOfnnRStrings = new ASN1EncodableVector();
            int heightOfTree = nextNextRoot[i17].getStatInt()[0];
            int tailLength2 = nextNextRoot[i17].getStatInt()[7];
            seqOfnnRBytes.add(new DEROctetString(nextNextRoot[i17].getStatByte()[0]));
            for (j9 = 0; j9 < heightOfTree; ++j9) {
                seqOfnnRBytes.add(new DEROctetString(nextNextRoot[i17].getStatByte()[1 + j9]));
            }
            for (j9 = 0; j9 < tailLength2; ++j9) {
                seqOfnnRBytes.add(new DEROctetString(nextNextRoot[i17].getStatByte()[1 + heightOfTree + j9]));
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRBytes));
            seqOfnnRBytes = new ASN1EncodableVector();
            seqOfnnRInts.add(new ASN1Integer(heightOfTree));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[1]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[2]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[3]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[4]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[5]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[6]));
            seqOfnnRInts.add(new ASN1Integer(tailLength2));
            for (j9 = 0; j9 < heightOfTree; ++j9) {
                seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[8 + j9]));
            }
            for (j9 = 0; j9 < tailLength2; ++j9) {
                seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[8 + heightOfTree + j9]));
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRInts));
            seqOfnnRInts = new ASN1EncodableVector();
            seqOfStat = new ASN1EncodableVector();
            seqOfByte = new ASN1EncodableVector();
            seqOfInt = new ASN1EncodableVector();
            if (nextNextRoot[i17].getTreehash() != null) {
                for (j9 = 0; j9 < nextNextRoot[i17].getTreehash().length; ++j9) {
                    seqOfStat.add(new DERSequence(algorithms[0]));
                    tailLength2 = nextNextRoot[i17].getTreehash()[j9].getStatInt()[1];
                    seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[0]));
                    seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[1]));
                    seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[2]));
                    for (k4 = 0; k4 < tailLength2; ++k4) {
                        seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[3 + k4]));
                    }
                    seqOfStat.add(new DERSequence(seqOfByte));
                    seqOfByte = new ASN1EncodableVector();
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[0]));
                    seqOfInt.add(new ASN1Integer(tailLength2));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[2]));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[3]));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[4]));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[5]));
                    for (k4 = 0; k4 < tailLength2; ++k4) {
                        seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[6 + k4]));
                    }
                    seqOfStat.add(new DERSequence(seqOfInt));
                    seqOfInt = new ASN1EncodableVector();
                    seqOfnnRTreehash.add(new DERSequence(seqOfStat));
                    seqOfStat = new ASN1EncodableVector();
                }
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRTreehash));
            seqOfnnRTreehash = new ASN1EncodableVector();
            currentRetainPart0 = new ASN1EncodableVector();
            if (nextNextRoot[i17].getRetain() != null) {
                for (j9 = 0; j9 < nextNextRoot[i17].getRetain().length; ++j9) {
                    for (k4 = 0; k4 < nextNextRoot[i17].getRetain()[j9].size(); ++k4) {
                        currentRetainPart0.add(new DEROctetString((byte[])nextNextRoot[i17].getRetain()[j9].elementAt(k4)));
                    }
                    seqOfnnRRetain.add(new DERSequence(currentRetainPart0));
                    currentRetainPart0 = new ASN1EncodableVector();
                }
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRRetain));
            seqOfnnRRetain = new ASN1EncodableVector();
            seqOfnextNextRoot.add(new DERSequence(seqOfnnRStats));
            seqOfnnRStats = new ASN1EncodableVector();
        }
        result.add(new DERSequence(seqOfnextNextRoot));
        ASN1EncodableVector curRootSigPart = new ASN1EncodableVector();
        for (int i18 = 0; i18 < currentRootSig.length; ++i18) {
            curRootSigPart.add(new DEROctetString(currentRootSig[i18]));
        }
        result.add(new DERSequence(curRootSigPart));
        ASN1EncodableVector seqOfnextRootSigs = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSStats = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSStrings = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSBytes = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSInts = new ASN1EncodableVector();
        for (int i19 = 0; i19 < nextRootSig.length; ++i19) {
            seqOfnRSStats.add(new DERSequence(algorithms[0]));
            seqOfnRSStrings = new ASN1EncodableVector();
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[0]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[1]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[2]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[3]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[4]));
            seqOfnRSStats.add(new DERSequence(seqOfnRSBytes));
            seqOfnRSBytes = new ASN1EncodableVector();
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[0]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[1]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[2]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[3]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[4]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[5]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[6]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[7]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[8]));
            seqOfnRSStats.add(new DERSequence(seqOfnRSInts));
            seqOfnRSInts = new ASN1EncodableVector();
            seqOfnextRootSigs.add(new DERSequence(seqOfnRSStats));
            seqOfnRSStats = new ASN1EncodableVector();
        }
        result.add(new DERSequence(seqOfnextRootSigs));
        ASN1EncodableVector parSetPart0 = new ASN1EncodableVector();
        ASN1EncodableVector parSetPart1 = new ASN1EncodableVector();
        ASN1EncodableVector parSetPart2 = new ASN1EncodableVector();
        ASN1EncodableVector parSetPart3 = new ASN1EncodableVector();
        for (int i20 = 0; i20 < gmssParameterset.getHeightOfTrees().length; ++i20) {
            parSetPart1.add(new ASN1Integer(gmssParameterset.getHeightOfTrees()[i20]));
            parSetPart2.add(new ASN1Integer(gmssParameterset.getWinternitzParameter()[i20]));
            parSetPart3.add(new ASN1Integer(gmssParameterset.getK()[i20]));
        }
        parSetPart0.add(new ASN1Integer(gmssParameterset.getNumOfLayers()));
        parSetPart0.add(new DERSequence(parSetPart1));
        parSetPart0.add(new DERSequence(parSetPart2));
        parSetPart0.add(new DERSequence(parSetPart3));
        result.add(new DERSequence(parSetPart0));
        ASN1EncodableVector namesPart = new ASN1EncodableVector();
        for (int i21 = 0; i21 < algorithms.length; ++i21) {
            namesPart.add(algorithms[i21]);
        }
        result.add(new DERSequence(namesPart));
        return new DERSequence(result);
    }

    private static int checkBigIntegerInIntRange(ASN1Encodable a) {
        return ((ASN1Integer)a).intValueExact();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.primitive;
    }
}

