/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.rfc8032;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.math.ec.rfc7748.X25519Field;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat256;
import org.bouncycastle.util.Arrays;

public abstract class Ed25519 {
    private static final long M08L = 255L;
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int COORD_INTS = 8;
    private static final int POINT_BYTES = 32;
    private static final int SCALAR_INTS = 8;
    private static final int SCALAR_BYTES = 32;
    public static final int PREHASH_SIZE = 64;
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private static final byte[] DOM2_PREFIX = new byte[]{83, 105, 103, 69, 100, 50, 53, 53, 49, 57, 32, 110, 111, 32, 69, 100, 50, 53, 53, 49, 57, 32, 99, 111, 108, 108, 105, 115, 105, 111, 110, 115};
    private static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] L = new int[]{1559614445, 1477600026, -1560830762, 350157278, 0, 0, 0, 0x10000000};
    private static final int L0 = -50998291;
    private static final int L1 = 19280294;
    private static final int L2 = 127719000;
    private static final int L3 = -6428113;
    private static final int L4 = 5343;
    private static final int[] B_x = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] B_y = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] C_d = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] C_d2 = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] C_d4 = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static final int WNAF_WIDTH = 5;
    private static final int WNAF_WIDTH_BASE = 7;
    private static final int PRECOMP_BLOCKS = 8;
    private static final int PRECOMP_TEETH = 4;
    private static final int PRECOMP_SPACING = 8;
    private static final int PRECOMP_POINTS = 8;
    private static final int PRECOMP_MASK = 7;
    private static final Object PRECOMP_LOCK = new Object();
    private static PointPrecomp[] PRECOMP_BASE_WNAF = null;
    private static int[] PRECOMP_BASE_COMB = null;

    private static byte[] calculateS(byte[] r, byte[] k, byte[] s) {
        int[] t = new int[16];
        Ed25519.decodeScalar(r, 0, t);
        int[] u = new int[8];
        Ed25519.decodeScalar(k, 0, u);
        int[] v = new int[8];
        Ed25519.decodeScalar(s, 0, v);
        Nat256.mulAddTo(u, v, t);
        byte[] result = new byte[64];
        for (int i = 0; i < t.length; ++i) {
            Ed25519.encode32(t[i], result, i * 4);
        }
        return Ed25519.reduceScalar(result);
    }

    private static boolean checkContextVar(byte[] ctx, byte phflag) {
        return ctx == null && phflag == 0 || ctx != null && ctx.length < 256;
    }

    private static int checkPoint(int[] x, int[] y) {
        int[] t = F.create();
        int[] u = F.create();
        int[] v = F.create();
        F.sqr(x, u);
        F.sqr(y, v);
        F.mul(u, v, t);
        F.sub(v, u, v);
        F.mul(t, C_d, t);
        F.addOne(t);
        F.sub(t, v, t);
        F.normalize(t);
        return F.isZero(t);
    }

    private static int checkPoint(int[] x, int[] y, int[] z) {
        int[] t = F.create();
        int[] u = F.create();
        int[] v = F.create();
        int[] w = F.create();
        F.sqr(x, u);
        F.sqr(y, v);
        F.sqr(z, w);
        F.mul(u, v, t);
        F.sub(v, u, v);
        F.mul(v, w, v);
        F.sqr(w, w);
        F.mul(t, C_d, t);
        F.add(t, w, t);
        F.sub(t, v, t);
        F.normalize(t);
        return F.isZero(t);
    }

    private static boolean checkPointVar(byte[] p) {
        int[] t = new int[8];
        Ed25519.decode32(p, 0, t, 0, 8);
        t[7] = t[7] & Integer.MAX_VALUE;
        return !Nat256.gte(t, P);
    }

    private static boolean checkScalarVar(byte[] s, int[] n) {
        Ed25519.decodeScalar(s, 0, n);
        return !Nat256.gte(n, L);
    }

    private static byte[] copy(byte[] buf, int off, int len) {
        byte[] result = new byte[len];
        System.arraycopy(buf, off, result, 0, len);
        return result;
    }

    private static Digest createDigest() {
        return new SHA512Digest();
    }

    public static Digest createPrehash() {
        return Ed25519.createDigest();
    }

    private static int decode24(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= (bs[++off] & 0xFF) << 16;
    }

    private static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    private static void decode32(byte[] bs, int bsOff, int[] n, int nOff, int nLen) {
        for (int i = 0; i < nLen; ++i) {
            n[nOff + i] = Ed25519.decode32(bs, bsOff + i * 4);
        }
    }

    private static boolean decodePointVar(byte[] p, int pOff, boolean negate, PointAffine r) {
        byte[] py = Ed25519.copy(p, pOff, 32);
        if (!Ed25519.checkPointVar(py)) {
            return false;
        }
        int x_0 = (py[31] & 0x80) >>> 7;
        py[31] = (byte)(py[31] & 0x7F);
        F.decode(py, 0, r.y);
        int[] u = F.create();
        int[] v = F.create();
        F.sqr(r.y, u);
        F.mul(C_d, u, v);
        F.subOne(u);
        F.addOne(v);
        if (!F.sqrtRatioVar(u, v, r.x)) {
            return false;
        }
        F.normalize(r.x);
        if (x_0 == 1 && F.isZeroVar(r.x)) {
            return false;
        }
        if (negate ^ x_0 != (r.x[0] & 1)) {
            F.negate(r.x, r.x);
        }
        return true;
    }

    private static void decodeScalar(byte[] k, int kOff, int[] n) {
        Ed25519.decode32(k, kOff, n, 0, 8);
    }

    private static void dom2(Digest d, byte phflag, byte[] ctx) {
        if (ctx != null) {
            int n = DOM2_PREFIX.length;
            byte[] t = new byte[n + 2 + ctx.length];
            System.arraycopy(DOM2_PREFIX, 0, t, 0, n);
            t[n] = phflag;
            t[n + 1] = (byte)ctx.length;
            System.arraycopy(ctx, 0, t, n + 2, ctx.length);
            d.update(t, 0, t.length);
        }
    }

    private static void encode24(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
    }

    private static void encode32(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    private static void encode56(long n, byte[] bs, int off) {
        Ed25519.encode32((int)n, bs, off);
        Ed25519.encode24((int)(n >>> 32), bs, off + 4);
    }

    private static int encodePoint(PointAccum p, byte[] r, int rOff) {
        int[] x = F.create();
        int[] y = F.create();
        F.inv(p.z, y);
        F.mul(p.x, y, x);
        F.mul(p.y, y, y);
        F.normalize(x);
        F.normalize(y);
        int result = Ed25519.checkPoint(x, y);
        F.encode(y, r, rOff);
        int n = rOff + 32 - 1;
        r[n] = (byte)(r[n] | (x[0] & 1) << 7);
        return result;
    }

    public static void generatePrivateKey(SecureRandom random, byte[] k) {
        random.nextBytes(k);
    }

    public static void generatePublicKey(byte[] sk, int skOff, byte[] pk, int pkOff) {
        Digest d = Ed25519.createDigest();
        byte[] h = new byte[d.getDigestSize()];
        d.update(sk, skOff, 32);
        d.doFinal(h, 0);
        byte[] s = new byte[32];
        Ed25519.pruneScalar(h, 0, s);
        Ed25519.scalarMultBaseEncoded(s, pk, pkOff);
    }

    private static int getWindow4(int[] x, int n) {
        int w = n >>> 3;
        int b = (n & 7) << 2;
        return x[w] >>> b & 0xF;
    }

    private static byte[] getWnafVar(int[] n, int width) {
        int[] t = new int[16];
        int tPos = t.length;
        int c = 0;
        int i = 8;
        while (--i >= 0) {
            int next = n[i];
            t[--tPos] = next >>> 16 | c << 16;
            t[--tPos] = c = next;
        }
        byte[] ws = new byte[253];
        int lead = 32 - width;
        int j = 0;
        int carry = 0;
        int i2 = 0;
        while (i2 < t.length) {
            int word = t[i2];
            while (j < 16) {
                int word16 = word >>> j;
                int bit = word16 & 1;
                if (bit == carry) {
                    ++j;
                    continue;
                }
                int digit = (word16 | 1) << lead;
                carry = digit >>> 31;
                ws[(i2 << 4) + j] = (byte)(digit >> lead);
                j += width;
            }
            ++i2;
            j -= 16;
        }
        return ws;
    }

    private static void implSign(Digest d, byte[] h, byte[] s, byte[] pk, int pkOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        Ed25519.dom2(d, phflag, ctx);
        d.update(h, 32, 32);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0);
        byte[] r = Ed25519.reduceScalar(h);
        byte[] R = new byte[32];
        Ed25519.scalarMultBaseEncoded(r, R, 0);
        Ed25519.dom2(d, phflag, ctx);
        d.update(R, 0, 32);
        d.update(pk, pkOff, 32);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0);
        byte[] k = Ed25519.reduceScalar(h);
        byte[] S = Ed25519.calculateS(r, k, s);
        System.arraycopy(R, 0, sig, sigOff, 32);
        System.arraycopy(S, 0, sig, sigOff + 32, 32);
    }

    private static void implSign(byte[] sk, int skOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        if (!Ed25519.checkContextVar(ctx, phflag)) {
            throw new IllegalArgumentException("ctx");
        }
        Digest d = Ed25519.createDigest();
        byte[] h = new byte[d.getDigestSize()];
        d.update(sk, skOff, 32);
        d.doFinal(h, 0);
        byte[] s = new byte[32];
        Ed25519.pruneScalar(h, 0, s);
        byte[] pk = new byte[32];
        Ed25519.scalarMultBaseEncoded(s, pk, 0);
        Ed25519.implSign(d, h, s, pk, 0, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    private static void implSign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        if (!Ed25519.checkContextVar(ctx, phflag)) {
            throw new IllegalArgumentException("ctx");
        }
        Digest d = Ed25519.createDigest();
        byte[] h = new byte[d.getDigestSize()];
        d.update(sk, skOff, 32);
        d.doFinal(h, 0);
        byte[] s = new byte[32];
        Ed25519.pruneScalar(h, 0, s);
        Ed25519.implSign(d, h, s, pk, pkOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    private static boolean implVerify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen) {
        if (!Ed25519.checkContextVar(ctx, phflag)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] R = Ed25519.copy(sig, sigOff, 32);
        byte[] S = Ed25519.copy(sig, sigOff + 32, 32);
        if (!Ed25519.checkPointVar(R)) {
            return false;
        }
        int[] nS = new int[8];
        if (!Ed25519.checkScalarVar(S, nS)) {
            return false;
        }
        PointAffine pA = new PointAffine();
        if (!Ed25519.decodePointVar(pk, pkOff, true, pA)) {
            return false;
        }
        Digest d = Ed25519.createDigest();
        byte[] h = new byte[d.getDigestSize()];
        Ed25519.dom2(d, phflag, ctx);
        d.update(R, 0, 32);
        d.update(pk, pkOff, 32);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0);
        byte[] k = Ed25519.reduceScalar(h);
        int[] nA = new int[8];
        Ed25519.decodeScalar(k, 0, nA);
        PointAccum pR = new PointAccum();
        Ed25519.scalarMultStrausVar(nS, nA, pA, pR);
        byte[] check = new byte[32];
        return 0 != Ed25519.encodePoint(pR, check, 0) && Arrays.areEqual(check, R);
    }

    private static void invertDoubleZs(PointExtended[] points) {
        int count = points.length;
        int[] cs = F.createTable(count);
        int[] u = F.create();
        F.copy(points[0].z, 0, u, 0);
        F.copy(u, 0, cs, 0);
        int i = 0;
        while (++i < count) {
            F.mul(u, points[i].z, u);
            F.copy(u, 0, cs, i * 10);
        }
        F.add(u, u, u);
        F.invVar(u, u);
        --i;
        int[] t = F.create();
        while (i > 0) {
            int j = i--;
            F.copy(cs, i * 10, t, 0);
            F.mul(t, u, t);
            F.mul(u, points[j].z, u);
            F.copy(t, 0, points[j].z, 0);
        }
        F.copy(u, 0, points[0].z, 0);
    }

    private static boolean isNeutralElementVar(int[] x, int[] y) {
        return F.isZeroVar(x) && F.isOneVar(y);
    }

    private static boolean isNeutralElementVar(int[] x, int[] y, int[] z) {
        return F.isZeroVar(x) && F.areEqualVar(y, z);
    }

    private static void pointAdd(PointExtended p, PointExtended q, PointExtended r, PointTemp t) {
        int[] a = r.x;
        int[] b = r.y;
        int[] c = t.r0;
        int[] d = t.r1;
        int[] e = a;
        int[] f = c;
        int[] g = d;
        int[] h = b;
        F.apm(p.y, p.x, b, a);
        F.apm(q.y, q.x, d, c);
        F.mul(a, c, a);
        F.mul(b, d, b);
        F.mul(p.t, q.t, c);
        F.mul(c, C_d2, c);
        F.add(p.z, p.z, d);
        F.mul(d, q.z, d);
        F.apm(b, a, h, e);
        F.apm(d, c, g, f);
        F.mul(e, h, r.t);
        F.mul(f, g, r.z);
        F.mul(e, f, r.x);
        F.mul(h, g, r.y);
    }

    private static void pointAdd(PointPrecomp p, PointAccum r, PointTemp t) {
        int[] a = r.x;
        int[] b = r.y;
        int[] c = t.r0;
        int[] e = r.u;
        int[] f = a;
        int[] g = b;
        int[] h = r.v;
        F.apm(r.y, r.x, b, a);
        F.mul(a, p.ymx_h, a);
        F.mul(b, p.ypx_h, b);
        F.mul(r.u, r.v, c);
        F.mul(c, p.xyd, c);
        F.apm(b, a, h, e);
        F.apm(r.z, c, g, f);
        F.mul(f, g, r.z);
        F.mul(f, e, r.x);
        F.mul(g, h, r.y);
    }

    private static void pointAdd(PointPrecompZ p, PointAccum r, PointTemp t) {
        int[] a = r.x;
        int[] b = r.y;
        int[] c = t.r0;
        int[] d = r.z;
        int[] e = r.u;
        int[] f = a;
        int[] g = b;
        int[] h = r.v;
        F.apm(r.y, r.x, b, a);
        F.mul(a, p.ymx_h, a);
        F.mul(b, p.ypx_h, b);
        F.mul(r.u, r.v, c);
        F.mul(c, p.xyd, c);
        F.mul(r.z, p.z, d);
        F.apm(b, a, h, e);
        F.apm(d, c, g, f);
        F.mul(f, g, r.z);
        F.mul(f, e, r.x);
        F.mul(g, h, r.y);
    }

    private static void pointAddVar(boolean negate, PointPrecomp p, PointAccum r, PointTemp t) {
        int[] nb;
        int[] na;
        int[] a = r.x;
        int[] b = r.y;
        int[] c = t.r0;
        int[] e = r.u;
        int[] f = a;
        int[] g = b;
        int[] h = r.v;
        if (negate) {
            na = b;
            nb = a;
        } else {
            na = a;
            nb = b;
        }
        int[] nf = na;
        int[] ng = nb;
        F.apm(r.y, r.x, b, a);
        F.mul(na, p.ymx_h, na);
        F.mul(nb, p.ypx_h, nb);
        F.mul(r.u, r.v, c);
        F.mul(c, p.xyd, c);
        F.apm(b, a, h, e);
        F.apm(r.z, c, ng, nf);
        F.mul(f, g, r.z);
        F.mul(f, e, r.x);
        F.mul(g, h, r.y);
    }

    private static void pointAddVar(boolean negate, PointPrecompZ p, PointAccum r, PointTemp t) {
        int[] nb;
        int[] na;
        int[] a = r.x;
        int[] b = r.y;
        int[] c = t.r0;
        int[] d = r.z;
        int[] e = r.u;
        int[] f = a;
        int[] g = b;
        int[] h = r.v;
        if (negate) {
            na = b;
            nb = a;
        } else {
            na = a;
            nb = b;
        }
        int[] nf = na;
        int[] ng = nb;
        F.apm(r.y, r.x, b, a);
        F.mul(na, p.ymx_h, na);
        F.mul(nb, p.ypx_h, nb);
        F.mul(r.u, r.v, c);
        F.mul(c, p.xyd, c);
        F.mul(r.z, p.z, d);
        F.apm(b, a, h, e);
        F.apm(d, c, ng, nf);
        F.mul(f, g, r.z);
        F.mul(f, e, r.x);
        F.mul(g, h, r.y);
    }

    private static void pointCopy(PointAccum p, PointExtended r) {
        F.copy(p.x, 0, r.x, 0);
        F.copy(p.y, 0, r.y, 0);
        F.copy(p.z, 0, r.z, 0);
        F.mul(p.u, p.v, r.t);
    }

    private static void pointCopy(PointAffine p, PointExtended r) {
        F.copy(p.x, 0, r.x, 0);
        F.copy(p.y, 0, r.y, 0);
        F.one(r.z);
        F.mul(p.x, p.y, r.t);
    }

    private static void pointCopy(PointExtended p, PointPrecompZ r) {
        F.apm(p.y, p.x, r.ypx_h, r.ymx_h);
        F.mul(p.t, C_d2, r.xyd);
        F.add(p.z, p.z, r.z);
    }

    private static void pointDouble(PointAccum r) {
        int[] a = r.x;
        int[] b = r.y;
        int[] c = r.z;
        int[] e = r.u;
        int[] f = a;
        int[] g = b;
        int[] h = r.v;
        F.add(r.x, r.y, e);
        F.sqr(r.x, a);
        F.sqr(r.y, b);
        F.sqr(r.z, c);
        F.add(c, c, c);
        F.apm(a, b, h, g);
        F.sqr(e, e);
        F.sub(h, e, e);
        F.add(c, g, f);
        F.carry(f);
        F.mul(f, g, r.z);
        F.mul(f, e, r.x);
        F.mul(g, h, r.y);
    }

    private static void pointLookup(int block, int index, PointPrecomp p) {
        int off = block * 8 * 3 * 10;
        for (int i = 0; i < 8; ++i) {
            int cond = (i ^ index) - 1 >> 31;
            F.cmov(cond, PRECOMP_BASE_COMB, off, p.ymx_h, 0);
            F.cmov(cond, PRECOMP_BASE_COMB, off += 10, p.ypx_h, 0);
            F.cmov(cond, PRECOMP_BASE_COMB, off += 10, p.xyd, 0);
            off += 10;
        }
    }

    private static void pointLookupZ(int[] x, int n, int[] table, PointPrecompZ r) {
        int w = Ed25519.getWindow4(x, n);
        int sign = w >>> 3 ^ 1;
        int abs = (w ^ -sign) & 7;
        int off = 0;
        for (int i = 0; i < 8; ++i) {
            int cond = (i ^ abs) - 1 >> 31;
            F.cmov(cond, table, off, r.ymx_h, 0);
            F.cmov(cond, table, off += 10, r.ypx_h, 0);
            F.cmov(cond, table, off += 10, r.xyd, 0);
            F.cmov(cond, table, off += 10, r.z, 0);
            off += 10;
        }
        F.cswap(sign, r.ymx_h, r.ypx_h);
        F.cnegate(sign, r.xyd);
    }

    private static void pointPrecompute(PointAffine p, PointExtended[] points, int count, PointTemp t) {
        points[0] = new PointExtended();
        Ed25519.pointCopy(p, points[0]);
        PointExtended d = new PointExtended();
        Ed25519.pointAdd(points[0], points[0], d, t);
        for (int i = 1; i < count; ++i) {
            points[i] = new PointExtended();
            Ed25519.pointAdd(points[i - 1], d, points[i], t);
        }
    }

    private static int[] pointPrecomputeZ(PointAffine p, int count, PointTemp t) {
        PointExtended q = new PointExtended();
        Ed25519.pointCopy(p, q);
        PointExtended d = new PointExtended();
        Ed25519.pointAdd(q, q, d, t);
        PointPrecompZ r = new PointPrecompZ();
        int[] table = F.createTable(count * 4);
        int off = 0;
        int i = 0;
        while (true) {
            Ed25519.pointCopy(q, r);
            F.copy(r.ymx_h, 0, table, off);
            F.copy(r.ypx_h, 0, table, off += 10);
            F.copy(r.xyd, 0, table, off += 10);
            F.copy(r.z, 0, table, off += 10);
            off += 10;
            if (++i == count) break;
            Ed25519.pointAdd(q, d, q, t);
        }
        return table;
    }

    private static void pointPrecomputeZ(PointAffine p, PointPrecompZ[] points, int count, PointTemp t) {
        PointExtended q = new PointExtended();
        Ed25519.pointCopy(p, q);
        PointExtended d = new PointExtended();
        Ed25519.pointAdd(q, q, d, t);
        int i = 0;
        while (true) {
            PointPrecompZ r = points[i] = new PointPrecompZ();
            Ed25519.pointCopy(q, r);
            if (++i == count) break;
            Ed25519.pointAdd(q, d, q, t);
        }
    }

    private static void pointSetNeutral(PointAccum p) {
        F.zero(p.x);
        F.one(p.y);
        F.one(p.z);
        F.zero(p.u);
        F.one(p.v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void precompute() {
        Object object = PRECOMP_LOCK;
        synchronized (object) {
            if (PRECOMP_BASE_WNAF != null && PRECOMP_BASE_COMB != null) {
                return;
            }
            int wnafPoints = 32;
            int combPoints = 64;
            int totalPoints = wnafPoints + combPoints;
            PointExtended[] points = new PointExtended[totalPoints];
            PointTemp t = new PointTemp();
            PointAffine b = new PointAffine();
            F.copy(B_x, 0, b.x, 0);
            F.copy(B_y, 0, b.y, 0);
            Ed25519.pointPrecompute(b, points, wnafPoints, t);
            PointAccum p = new PointAccum();
            F.copy(B_x, 0, p.x, 0);
            F.copy(B_y, 0, p.y, 0);
            F.one(p.z);
            F.copy(p.x, 0, p.u, 0);
            F.copy(p.y, 0, p.v, 0);
            int pointsIndex = wnafPoints;
            PointExtended[] toothPowers = new PointExtended[4];
            for (int tooth = 0; tooth < 4; ++tooth) {
                toothPowers[tooth] = new PointExtended();
            }
            PointExtended u = new PointExtended();
            for (int block = 0; block < 8; ++block) {
                int tooth;
                int n = pointsIndex++;
                PointExtended pointExtended = new PointExtended();
                points[n] = pointExtended;
                PointExtended sum = pointExtended;
                for (tooth = 0; tooth < 4; ++tooth) {
                    if (tooth == 0) {
                        Ed25519.pointCopy(p, sum);
                    } else {
                        Ed25519.pointCopy(p, u);
                        Ed25519.pointAdd(sum, u, sum, t);
                    }
                    Ed25519.pointDouble(p);
                    Ed25519.pointCopy(p, toothPowers[tooth]);
                    if (block + tooth == 10) continue;
                    for (int spacing = 1; spacing < 8; ++spacing) {
                        Ed25519.pointDouble(p);
                    }
                }
                F.negate(sum.x, sum.x);
                F.negate(sum.t, sum.t);
                for (tooth = 0; tooth < 3; ++tooth) {
                    int size = 1 << tooth;
                    int j = 0;
                    while (j < size) {
                        points[pointsIndex] = new PointExtended();
                        Ed25519.pointAdd(points[pointsIndex - size], toothPowers[tooth], points[pointsIndex], t);
                        ++j;
                        ++pointsIndex;
                    }
                }
            }
            Ed25519.invertDoubleZs(points);
            PRECOMP_BASE_WNAF = new PointPrecomp[wnafPoints];
            for (int i = 0; i < wnafPoints; ++i) {
                PointExtended q = points[i];
                PointPrecomp r = Ed25519.PRECOMP_BASE_WNAF[i] = new PointPrecomp();
                F.mul(q.x, q.z, q.x);
                F.mul(q.y, q.z, q.y);
                F.apm(q.y, q.x, r.ypx_h, r.ymx_h);
                F.mul(q.x, q.y, r.xyd);
                F.mul(r.xyd, C_d4, r.xyd);
                F.normalize(r.ymx_h);
                F.normalize(r.ypx_h);
                F.normalize(r.xyd);
            }
            PRECOMP_BASE_COMB = F.createTable(combPoints * 3);
            PointPrecomp s = new PointPrecomp();
            int off = 0;
            for (int i = wnafPoints; i < totalPoints; ++i) {
                PointExtended q = points[i];
                F.mul(q.x, q.z, q.x);
                F.mul(q.y, q.z, q.y);
                F.apm(q.y, q.x, s.ypx_h, s.ymx_h);
                F.mul(q.x, q.y, s.xyd);
                F.mul(s.xyd, C_d4, s.xyd);
                F.normalize(s.ymx_h);
                F.normalize(s.ypx_h);
                F.normalize(s.xyd);
                F.copy(s.ymx_h, 0, PRECOMP_BASE_COMB, off);
                F.copy(s.ypx_h, 0, PRECOMP_BASE_COMB, off += 10);
                F.copy(s.xyd, 0, PRECOMP_BASE_COMB, off += 10);
                off += 10;
            }
        }
    }

    private static void pruneScalar(byte[] n, int nOff, byte[] r) {
        System.arraycopy(n, nOff, r, 0, 32);
        r[0] = (byte)(r[0] & 0xF8);
        r[31] = (byte)(r[31] & 0x7F);
        r[31] = (byte)(r[31] | 0x40);
    }

    private static byte[] reduceScalar(byte[] n) {
        long x00 = (long)Ed25519.decode32(n, 0) & 0xFFFFFFFFL;
        long x01 = (long)(Ed25519.decode24(n, 4) << 4) & 0xFFFFFFFFL;
        long x02 = (long)Ed25519.decode32(n, 7) & 0xFFFFFFFFL;
        long x03 = (long)(Ed25519.decode24(n, 11) << 4) & 0xFFFFFFFFL;
        long x04 = (long)Ed25519.decode32(n, 14) & 0xFFFFFFFFL;
        long x05 = (long)(Ed25519.decode24(n, 18) << 4) & 0xFFFFFFFFL;
        long x06 = (long)Ed25519.decode32(n, 21) & 0xFFFFFFFFL;
        long x07 = (long)(Ed25519.decode24(n, 25) << 4) & 0xFFFFFFFFL;
        long x08 = (long)Ed25519.decode32(n, 28) & 0xFFFFFFFFL;
        long x09 = (long)(Ed25519.decode24(n, 32) << 4) & 0xFFFFFFFFL;
        long x10 = (long)Ed25519.decode32(n, 35) & 0xFFFFFFFFL;
        long x11 = (long)(Ed25519.decode24(n, 39) << 4) & 0xFFFFFFFFL;
        long x12 = (long)Ed25519.decode32(n, 42) & 0xFFFFFFFFL;
        long x13 = (long)(Ed25519.decode24(n, 46) << 4) & 0xFFFFFFFFL;
        long x14 = (long)Ed25519.decode32(n, 49) & 0xFFFFFFFFL;
        long x15 = (long)(Ed25519.decode24(n, 53) << 4) & 0xFFFFFFFFL;
        long x16 = (long)Ed25519.decode32(n, 56) & 0xFFFFFFFFL;
        long x17 = (long)(Ed25519.decode24(n, 60) << 4) & 0xFFFFFFFFL;
        long x18 = (long)n[63] & 0xFFL;
        x09 -= x18 * -50998291L;
        x10 -= x18 * 19280294L;
        x11 -= x18 * 127719000L;
        x12 -= x18 * -6428113L;
        x13 -= x18 * 5343L;
        x17 += x16 >> 28;
        x16 &= 0xFFFFFFFL;
        x08 -= x17 * -50998291L;
        x09 -= x17 * 19280294L;
        x10 -= x17 * 127719000L;
        x11 -= x17 * -6428113L;
        x12 -= x17 * 5343L;
        x07 -= x16 * -50998291L;
        x08 -= x16 * 19280294L;
        x09 -= x16 * 127719000L;
        x10 -= x16 * -6428113L;
        x11 -= x16 * 5343L;
        x15 += x14 >> 28;
        x14 &= 0xFFFFFFFL;
        x06 -= x15 * -50998291L;
        x07 -= x15 * 19280294L;
        x08 -= x15 * 127719000L;
        x09 -= x15 * -6428113L;
        x10 -= x15 * 5343L;
        x05 -= x14 * -50998291L;
        x06 -= x14 * 19280294L;
        x07 -= x14 * 127719000L;
        x08 -= x14 * -6428113L;
        x09 -= x14 * 5343L;
        x13 += x12 >> 28;
        x12 &= 0xFFFFFFFL;
        x04 -= x13 * -50998291L;
        x05 -= x13 * 19280294L;
        x06 -= x13 * 127719000L;
        x07 -= x13 * -6428113L;
        x08 -= x13 * 5343L;
        x12 += x11 >> 28;
        x11 &= 0xFFFFFFFL;
        x03 -= x12 * -50998291L;
        x04 -= x12 * 19280294L;
        x05 -= x12 * 127719000L;
        x06 -= x12 * -6428113L;
        x07 -= x12 * 5343L;
        x11 += x10 >> 28;
        x10 &= 0xFFFFFFFL;
        x02 -= x11 * -50998291L;
        x03 -= x11 * 19280294L;
        x04 -= x11 * 127719000L;
        x05 -= x11 * -6428113L;
        x06 -= x11 * 5343L;
        x10 += x09 >> 28;
        x09 &= 0xFFFFFFFL;
        x01 -= x10 * -50998291L;
        x02 -= x10 * 19280294L;
        x03 -= x10 * 127719000L;
        x04 -= x10 * -6428113L;
        x05 -= x10 * 5343L;
        x08 += x07 >> 28;
        x07 &= 0xFFFFFFFL;
        x09 += x08 >> 28;
        long t = (x08 &= 0xFFFFFFFL) >>> 27;
        x01 -= x09 * 19280294L;
        x02 -= x09 * 127719000L;
        x03 -= x09 * -6428113L;
        x04 -= x09 * 5343L;
        x00 &= 0xFFFFFFFL;
        x01 &= 0xFFFFFFFL;
        x02 &= 0xFFFFFFFL;
        x03 &= 0xFFFFFFFL;
        x04 &= 0xFFFFFFFL;
        x05 &= 0xFFFFFFFL;
        x06 &= 0xFFFFFFFL;
        x07 &= 0xFFFFFFFL;
        x09 = (x08 += (x07 += (x06 += (x05 += (x04 += (x03 += (x02 += (x01 += (x00 -= (x09 += t) * -50998291L) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        x08 &= 0xFFFFFFFL;
        x01 += x09 & 0x12631A6L;
        x02 += x09 & 0x79CD658L;
        x03 += x09 & 0xFFFFFFFFFF9DEA2FL;
        x04 += x09 & 0x14DFL;
        x00 &= 0xFFFFFFFL;
        x01 &= 0xFFFFFFFL;
        x02 &= 0xFFFFFFFL;
        x03 &= 0xFFFFFFFL;
        x04 &= 0xFFFFFFFL;
        x05 &= 0xFFFFFFFL;
        x06 &= 0xFFFFFFFL;
        x08 += (x07 += (x06 += (x05 += (x04 += (x03 += (x02 += (x01 += (x00 += (x09 -= t) & 0xFFFFFFFFFCF5D3EDL) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        byte[] r = new byte[32];
        Ed25519.encode56(x00 | x01 << 28, r, 0);
        Ed25519.encode56(x02 | x03 << 28, r, 7);
        Ed25519.encode56(x04 | x05 << 28, r, 14);
        Ed25519.encode56(x06 | (x07 &= 0xFFFFFFFL) << 28, r, 21);
        Ed25519.encode32((int)x08, r, 28);
        return r;
    }

    private static void scalarMult(byte[] k, PointAffine p, PointAccum r) {
        int[] n = new int[8];
        Ed25519.decodeScalar(k, 0, n);
        Nat.cadd(8, ~n[0] & 1, n, L, n);
        Nat.shiftDownBit(8, n, 1);
        PointPrecompZ q = new PointPrecompZ();
        PointTemp t = new PointTemp();
        int[] table = Ed25519.pointPrecomputeZ(p, 8, t);
        Ed25519.pointSetNeutral(r);
        int w = 63;
        block0: while (true) {
            Ed25519.pointLookupZ(n, w, table, q);
            Ed25519.pointAdd(q, r, t);
            if (--w < 0) break;
            int i = 0;
            while (true) {
                if (i >= 4) continue block0;
                Ed25519.pointDouble(r);
                ++i;
            }
            break;
        }
    }

    private static void scalarMultBase(byte[] k, PointAccum r) {
        Ed25519.precompute();
        int[] n = new int[8];
        Ed25519.decodeScalar(k, 0, n);
        Nat.cadd(8, ~n[0] & 1, n, L, n);
        Nat.shiftDownBit(8, n, 1);
        for (int i = 0; i < 8; ++i) {
            n[i] = Interleave.shuffle2(n[i]);
        }
        PointPrecomp p = new PointPrecomp();
        PointTemp t = new PointTemp();
        Ed25519.pointSetNeutral(r);
        int resultSign = 0;
        int cOff = 28;
        while (true) {
            for (int b = 0; b < 8; ++b) {
                int w = n[b] >>> cOff;
                int sign = w >>> 3 & 1;
                int abs = (w ^ -sign) & 7;
                Ed25519.pointLookup(b, abs, p);
                F.cnegate(resultSign ^ sign, r.x);
                F.cnegate(resultSign ^ sign, r.u);
                resultSign = sign;
                Ed25519.pointAdd(p, r, t);
            }
            if ((cOff -= 4) < 0) break;
            Ed25519.pointDouble(r);
        }
        F.cnegate(resultSign, r.x);
        F.cnegate(resultSign, r.u);
    }

    private static void scalarMultBaseEncoded(byte[] k, byte[] r, int rOff) {
        PointAccum p = new PointAccum();
        Ed25519.scalarMultBase(k, p);
        if (0 == Ed25519.encodePoint(p, r, rOff)) {
            throw new IllegalStateException();
        }
    }

    public static void scalarMultBaseYZ(X25519.Friend friend, byte[] k, int kOff, int[] y, int[] z) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by X25519");
        }
        byte[] n = new byte[32];
        Ed25519.pruneScalar(k, kOff, n);
        PointAccum p = new PointAccum();
        Ed25519.scalarMultBase(n, p);
        if (0 == Ed25519.checkPoint(p.x, p.y, p.z)) {
            throw new IllegalStateException();
        }
        F.copy(p.y, 0, y, 0);
        F.copy(p.z, 0, z, 0);
    }

    private static void scalarMultOrderVar(PointAffine p, PointAccum r) {
        byte[] ws_p = Ed25519.getWnafVar(L, 5);
        int count = 8;
        PointPrecompZ[] tp = new PointPrecompZ[count];
        PointTemp t = new PointTemp();
        Ed25519.pointPrecomputeZ(p, tp, count, t);
        Ed25519.pointSetNeutral(r);
        int bit = 252;
        while (true) {
            byte wp;
            if ((wp = ws_p[bit]) != 0) {
                int sign = wp >> 31;
                int index = (wp ^ sign) >>> 1;
                Ed25519.pointAddVar(sign != 0, tp[index], r, t);
            }
            if (--bit < 0) break;
            Ed25519.pointDouble(r);
        }
    }

    private static void scalarMultStrausVar(int[] nb, int[] np, PointAffine p, PointAccum r) {
        Ed25519.precompute();
        byte[] ws_b = Ed25519.getWnafVar(nb, 7);
        byte[] ws_p = Ed25519.getWnafVar(np, 5);
        int count = 8;
        PointPrecompZ[] tp = new PointPrecompZ[count];
        PointTemp t = new PointTemp();
        Ed25519.pointPrecomputeZ(p, tp, count, t);
        Ed25519.pointSetNeutral(r);
        int bit = 252;
        while (true) {
            byte wp;
            byte wb;
            if ((wb = ws_b[bit]) != 0) {
                int sign = wb >> 31;
                int index = (wb ^ sign) >>> 1;
                Ed25519.pointAddVar(sign != 0, PRECOMP_BASE_WNAF[index], r, t);
            }
            if ((wp = ws_p[bit]) != 0) {
                int sign = wp >> 31;
                int index = (wp ^ sign) >>> 1;
                Ed25519.pointAddVar(sign != 0, tp[index], r, t);
            }
            if (--bit < 0) break;
            Ed25519.pointDouble(r);
        }
    }

    public static void sign(byte[] sk, int skOff, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        byte[] ctx = null;
        byte phflag = 0;
        Ed25519.implSign(sk, skOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        byte[] ctx = null;
        byte phflag = 0;
        Ed25519.implSign(sk, skOff, pk, pkOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] ctx, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        byte phflag = 0;
        Ed25519.implSign(sk, skOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        byte phflag = 0;
        Ed25519.implSign(sk, skOff, pk, pkOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte phflag = 1;
        Ed25519.implSign(sk, skOff, ctx, phflag, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte phflag = 1;
        Ed25519.implSign(sk, skOff, pk, pkOff, ctx, phflag, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, Digest ph, byte[] sig, int sigOff) {
        byte[] m = new byte[64];
        if (64 != ph.doFinal(m, 0)) {
            throw new IllegalArgumentException("ph");
        }
        byte phflag = 1;
        Ed25519.implSign(sk, skOff, ctx, phflag, m, 0, m.length, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, Digest ph, byte[] sig, int sigOff) {
        byte[] m = new byte[64];
        if (64 != ph.doFinal(m, 0)) {
            throw new IllegalArgumentException("ph");
        }
        byte phflag = 1;
        Ed25519.implSign(sk, skOff, pk, pkOff, ctx, phflag, m, 0, m.length, sig, sigOff);
    }

    public static boolean validatePublicKeyFull(byte[] pk, int pkOff) {
        PointAffine p = new PointAffine();
        if (!Ed25519.decodePointVar(pk, pkOff, false, p)) {
            return false;
        }
        F.normalize(p.x);
        F.normalize(p.y);
        if (Ed25519.isNeutralElementVar(p.x, p.y)) {
            return false;
        }
        PointAccum r = new PointAccum();
        Ed25519.scalarMultOrderVar(p, r);
        F.normalize(r.x);
        F.normalize(r.y);
        F.normalize(r.z);
        return Ed25519.isNeutralElementVar(r.x, r.y, r.z);
    }

    public static boolean validatePublicKeyPartial(byte[] pk, int pkOff) {
        PointAffine p = new PointAffine();
        return Ed25519.decodePointVar(pk, pkOff, false, p);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] m, int mOff, int mLen) {
        byte[] ctx = null;
        byte phflag = 0;
        return Ed25519.implVerify(sig, sigOff, pk, pkOff, ctx, phflag, m, mOff, mLen);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] m, int mOff, int mLen) {
        byte phflag = 0;
        return Ed25519.implVerify(sig, sigOff, pk, pkOff, ctx, phflag, m, mOff, mLen);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff) {
        byte phflag = 1;
        return Ed25519.implVerify(sig, sigOff, pk, pkOff, ctx, phflag, ph, phOff, 64);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, Digest ph) {
        byte[] m = new byte[64];
        if (64 != ph.doFinal(m, 0)) {
            throw new IllegalArgumentException("ph");
        }
        byte phflag = 1;
        return Ed25519.implVerify(sig, sigOff, pk, pkOff, ctx, phflag, m, 0, m.length);
    }

    public static final class Algorithm {
        public static final int Ed25519 = 0;
        public static final int Ed25519ctx = 1;
        public static final int Ed25519ph = 2;
    }

    private static class F
    extends X25519Field {
        private F() {
        }
    }

    private static class PointAccum {
        int[] x = F.create();
        int[] y = F.create();
        int[] z = F.create();
        int[] u = F.create();
        int[] v = F.create();

        private PointAccum() {
        }
    }

    private static class PointAffine {
        int[] x = F.create();
        int[] y = F.create();

        private PointAffine() {
        }
    }

    private static class PointExtended {
        int[] x = F.create();
        int[] y = F.create();
        int[] z = F.create();
        int[] t = F.create();

        private PointExtended() {
        }
    }

    private static class PointPrecomp {
        int[] ymx_h = F.create();
        int[] ypx_h = F.create();
        int[] xyd = F.create();

        private PointPrecomp() {
        }
    }

    private static class PointPrecompZ {
        int[] ymx_h = F.create();
        int[] ypx_h = F.create();
        int[] xyd = F.create();
        int[] z = F.create();

        private PointPrecompZ() {
        }
    }

    private static class PointTemp {
        int[] r0 = F.create();
        int[] r1 = F.create();

        private PointTemp() {
        }
    }
}

