/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.CertificateStatus;
import org.bouncycastle.crypto.tls.CipherSuite;
import org.bouncycastle.crypto.tls.DTLSProtocol;
import org.bouncycastle.crypto.tls.DTLSRecordLayer;
import org.bouncycastle.crypto.tls.DTLSReliableHandshake;
import org.bouncycastle.crypto.tls.DTLSTransport;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.DigitallySigned;
import org.bouncycastle.crypto.tls.NewSessionTicket;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.SessionParameters;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientContextImpl;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsSession;
import org.bouncycastle.crypto.tls.TlsSessionImpl;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public DTLSTransport connect(TlsClient client, DatagramTransport transport) throws IOException {
        SessionParameters sessionParameters;
        if (client == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 1;
        ClientHandshakeState state = new ClientHandshakeState();
        state.client = client;
        state.clientContext = new TlsClientContextImpl(this.secureRandom, securityParameters);
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(client.shouldUseGMTUnixTime(), state.clientContext.getNonceRandomGenerator());
        client.init(state.clientContext);
        DTLSRecordLayer recordLayer = new DTLSRecordLayer(transport, state.clientContext, client, 22);
        TlsSession sessionToResume = state.client.getSessionToResume();
        if (sessionToResume != null && (sessionParameters = sessionToResume.exportSessionParameters()) != null) {
            state.tlsSession = sessionToResume;
            state.sessionParameters = sessionParameters;
        }
        try {
            return this.clientHandshake(state, recordLayer);
        }
        catch (TlsFatalAlert fatalAlert) {
            recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState state, DTLSRecordLayer recordLayer) throws IOException {
        boolean resumedSession;
        SecurityParameters securityParameters = state.clientContext.getSecurityParameters();
        DTLSReliableHandshake handshake = new DTLSReliableHandshake(state.clientContext, recordLayer);
        byte[] clientHelloBody = this.generateClientHello(state, state.client);
        handshake.sendMessage((short)1, clientHelloBody);
        DTLSReliableHandshake.Message serverMessage = handshake.receiveMessage();
        while (serverMessage.getType() == 3) {
            ProtocolVersion client_version;
            ProtocolVersion recordLayerVersion = recordLayer.resetDiscoveredPeerVersion();
            if (!recordLayerVersion.isEqualOrEarlierVersionOf(client_version = state.clientContext.getClientVersion())) {
                throw new TlsFatalAlert(47);
            }
            byte[] cookie = this.processHelloVerifyRequest(state, serverMessage.getBody());
            byte[] patched = DTLSClientProtocol.patchClientHelloWithCookie(clientHelloBody, cookie);
            handshake.resetHandshakeMessagesDigest();
            handshake.sendMessage((short)1, patched);
            serverMessage = handshake.receiveMessage();
        }
        if (serverMessage.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        this.reportServerVersion(state, recordLayer.getDiscoveredPeerVersion());
        this.processServerHello(state, serverMessage.getBody());
        if (state.maxFragmentLength >= 0) {
            int plainTextLimit = 1 << 8 + state.maxFragmentLength;
            recordLayer.setPlaintextLimit(plainTextLimit);
        }
        securityParameters.cipherSuite = state.selectedCipherSuite;
        securityParameters.compressionAlgorithm = state.selectedCompressionMethod;
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(state.clientContext, state.selectedCipherSuite);
        securityParameters.verifyDataLength = 12;
        handshake.notifyHelloComplete();
        boolean bl = resumedSession = state.selectedSessionID.length > 0 && state.tlsSession != null && Arrays.areEqual(state.selectedSessionID, state.tlsSession.getSessionID());
        if (resumedSession) {
            if (securityParameters.getCipherSuite() != state.sessionParameters.getCipherSuite() || securityParameters.getCompressionAlgorithm() != state.sessionParameters.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            Hashtable sessionServerExtensions = state.sessionParameters.readServerExtensions();
            securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(sessionServerExtensions);
            securityParameters.masterSecret = Arrays.clone(state.sessionParameters.getMasterSecret());
            recordLayer.initPendingEpoch(state.client.getCipher());
            byte[] expectedServerVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "server finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake.getHandshakeHash(), null));
            this.processFinished(handshake.receiveMessageBody((short)20), expectedServerVerifyData);
            byte[] clientVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "client finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake.getHandshakeHash(), null));
            handshake.sendMessage((short)20, clientVerifyData);
            handshake.finish();
            state.clientContext.setResumableSession(state.tlsSession);
            state.client.notifyHandshakeComplete();
            return new DTLSTransport(recordLayer);
        }
        this.invalidateSession(state);
        if (state.selectedSessionID.length > 0) {
            state.tlsSession = new TlsSessionImpl(state.selectedSessionID, null);
        }
        if ((serverMessage = handshake.receiveMessage()).getType() == 23) {
            this.processServerSupplementalData(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.client.processServerSupplementalData(null);
        }
        state.keyExchange = state.client.getKeyExchange();
        state.keyExchange.init(state.clientContext);
        Certificate serverCertificate = null;
        if (serverMessage.getType() == 11) {
            serverCertificate = this.processServerCertificate(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.keyExchange.skipServerCredentials();
        }
        if (serverCertificate == null || serverCertificate.isEmpty()) {
            state.allowCertificateStatus = false;
        }
        if (serverMessage.getType() == 22) {
            this.processCertificateStatus(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        }
        if (serverMessage.getType() == 12) {
            this.processServerKeyExchange(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.keyExchange.skipServerKeyExchange();
        }
        if (serverMessage.getType() == 13) {
            this.processCertificateRequest(state, serverMessage.getBody());
            TlsUtils.trackHashAlgorithms(handshake.getHandshakeHash(), state.certificateRequest.getSupportedSignatureAlgorithms());
            serverMessage = handshake.receiveMessage();
        }
        if (serverMessage.getType() == 14) {
            if (serverMessage.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        handshake.getHandshakeHash().sealHashAlgorithms();
        Vector clientSupplementalData = state.client.getClientSupplementalData();
        if (clientSupplementalData != null) {
            byte[] supplementalDataBody = DTLSClientProtocol.generateSupplementalData(clientSupplementalData);
            handshake.sendMessage((short)23, supplementalDataBody);
        }
        if (state.certificateRequest != null) {
            state.clientCredentials = state.authentication.getClientCredentials(state.certificateRequest);
            Certificate clientCertificate = null;
            if (state.clientCredentials != null) {
                clientCertificate = state.clientCredentials.getCertificate();
            }
            if (clientCertificate == null) {
                clientCertificate = Certificate.EMPTY_CHAIN;
            }
            byte[] certificateBody = DTLSClientProtocol.generateCertificate(clientCertificate);
            handshake.sendMessage((short)11, certificateBody);
        }
        if (state.clientCredentials != null) {
            state.keyExchange.processClientCredentials(state.clientCredentials);
        } else {
            state.keyExchange.skipClientCredentials();
        }
        byte[] clientKeyExchangeBody = this.generateClientKeyExchange(state);
        handshake.sendMessage((short)16, clientKeyExchangeBody);
        TlsHandshakeHash prepareFinishHash = handshake.prepareToFinish();
        securityParameters.sessionHash = TlsProtocol.getCurrentPRFHash(state.clientContext, prepareFinishHash, null);
        TlsProtocol.establishMasterSecret(state.clientContext, state.keyExchange);
        recordLayer.initPendingEpoch(state.client.getCipher());
        if (state.clientCredentials != null && state.clientCredentials instanceof TlsSignerCredentials) {
            TlsSignerCredentials signerCredentials = (TlsSignerCredentials)state.clientCredentials;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(state.clientContext, signerCredentials);
            byte[] hash = signatureAndHashAlgorithm == null ? securityParameters.getSessionHash() : prepareFinishHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            byte[] signature = signerCredentials.generateCertificateSignature(hash);
            DigitallySigned certificateVerify = new DigitallySigned(signatureAndHashAlgorithm, signature);
            byte[] certificateVerifyBody = this.generateCertificateVerify(state, certificateVerify);
            handshake.sendMessage((short)15, certificateVerifyBody);
        }
        byte[] clientVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "client finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake.getHandshakeHash(), null));
        handshake.sendMessage((short)20, clientVerifyData);
        if (state.expectSessionTicket) {
            serverMessage = handshake.receiveMessage();
            if (serverMessage.getType() == 4) {
                this.processNewSessionTicket(state, serverMessage.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        byte[] expectedServerVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "server finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake.getHandshakeHash(), null));
        this.processFinished(handshake.receiveMessageBody((short)20), expectedServerVerifyData);
        handshake.finish();
        if (state.tlsSession != null) {
            state.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.cipherSuite).setCompressionAlgorithm(securityParameters.compressionAlgorithm).setMasterSecret(securityParameters.masterSecret).setPeerCertificate(serverCertificate).setPSKIdentity(securityParameters.pskIdentity).setSRPIdentity(securityParameters.srpIdentity).build();
            state.tlsSession = TlsUtils.importSession(state.tlsSession.getSessionID(), state.sessionParameters);
            state.clientContext.setResumableSession(state.tlsSession);
        }
        state.client.notifyHandshakeComplete();
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState state, DigitallySigned certificateVerify) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificateVerify.encode(buf);
        return buf.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState state, TlsClient client) throws IOException {
        boolean noRenegSCSV;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ProtocolVersion client_version = client.getClientVersion();
        if (!client_version.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        TlsClientContextImpl context = state.clientContext;
        context.setClientVersion(client_version);
        TlsUtils.writeVersion(client_version, buf);
        SecurityParameters securityParameters = context.getSecurityParameters();
        buf.write(securityParameters.getClientRandom());
        byte[] session_id = TlsUtils.EMPTY_BYTES;
        if (state.tlsSession != null && ((session_id = state.tlsSession.getSessionID()) == null || session_id.length > 32)) {
            session_id = TlsUtils.EMPTY_BYTES;
        }
        TlsUtils.writeOpaque8(session_id, buf);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, buf);
        boolean fallback = client.isFallback();
        state.offeredCipherSuites = client.getCipherSuites();
        state.clientExtensions = client.getClientExtensions();
        securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(state.clientExtensions);
        byte[] renegExtData = TlsUtils.getExtensionData(state.clientExtensions, TlsProtocol.EXT_RenegotiationInfo);
        boolean noRenegExt = null == renegExtData;
        boolean bl = noRenegSCSV = !Arrays.contains(state.offeredCipherSuites, 255);
        if (noRenegExt && noRenegSCSV) {
            state.offeredCipherSuites = Arrays.append(state.offeredCipherSuites, 255);
        }
        if (fallback && !Arrays.contains(state.offeredCipherSuites, 22016)) {
            state.offeredCipherSuites = Arrays.append(state.offeredCipherSuites, 22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(state.offeredCipherSuites, buf);
        state.offeredCompressionMethods = new short[]{0};
        TlsUtils.writeUint8ArrayWithUint8Length(state.offeredCompressionMethods, buf);
        if (state.clientExtensions != null) {
            TlsProtocol.writeExtensions(buf, state.clientExtensions);
        }
        return buf.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState state) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        state.keyExchange.generateClientKeyExchange(buf);
        return buf.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState state) {
        if (state.sessionParameters != null) {
            state.sessionParameters.clear();
            state.sessionParameters = null;
        }
        if (state.tlsSession != null) {
            state.tlsSession.invalidate();
            state.tlsSession = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState state, byte[] body) throws IOException {
        if (state.authentication == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.certificateRequest = CertificateRequest.parse(state.clientContext, buf);
        TlsProtocol.assertEmpty(buf);
        state.keyExchange.validateCertificateRequest(state.certificateRequest);
    }

    protected void processCertificateStatus(ClientHandshakeState state, byte[] body) throws IOException {
        if (!state.allowCertificateStatus) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.certificateStatus = CertificateStatus.parse(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        byte[] cookie = TlsUtils.readOpaque8(buf);
        TlsProtocol.assertEmpty(buf);
        if (!server_version.isEqualOrEarlierVersionOf(state.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        if (!ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(server_version) && cookie.length > 32) {
            throw new TlsFatalAlert(47);
        }
        return cookie;
    }

    protected void processNewSessionTicket(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected Certificate processServerCertificate(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Certificate serverCertificate = Certificate.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.keyExchange.processServerCertificate(serverCertificate);
        state.authentication = state.client.getAuthentication();
        state.authentication.notifyServerCertificate(serverCertificate);
        return serverCertificate;
    }

    protected void processServerHello(ClientHandshakeState state, byte[] body) throws IOException {
        SecurityParameters securityParameters = state.clientContext.getSecurityParameters();
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        this.reportServerVersion(state, server_version);
        securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)buf);
        state.selectedSessionID = TlsUtils.readOpaque8(buf);
        if (state.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        state.client.notifySessionID(state.selectedSessionID);
        state.selectedCipherSuite = TlsUtils.readUint16(buf);
        if (!Arrays.contains(state.offeredCipherSuites, state.selectedCipherSuite) || state.selectedCipherSuite == 0 || CipherSuite.isSCSV(state.selectedCipherSuite) || !TlsUtils.isValidCipherSuiteForVersion(state.selectedCipherSuite, server_version)) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(state.selectedCipherSuite, (short)47);
        state.client.notifySelectedCipherSuite(state.selectedCipherSuite);
        state.selectedCompressionMethod = TlsUtils.readUint8(buf);
        if (!Arrays.contains(state.offeredCompressionMethods, state.selectedCompressionMethod)) {
            throw new TlsFatalAlert(47);
        }
        state.client.notifySelectedCompressionMethod(state.selectedCompressionMethod);
        Hashtable serverExtensions = TlsProtocol.readExtensions(buf);
        boolean serverSentExtendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(serverExtensions);
        if (serverSentExtendedMasterSecret != securityParameters.extendedMasterSecret) {
            throw new TlsFatalAlert(40);
        }
        if (serverExtensions != null) {
            boolean serverSentEncryptThenMAC;
            Enumeration e = serverExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(state.clientExtensions, extType)) {
                    throw new TlsFatalAlert(110);
                }
                if (!extType.equals(TlsExtensionsUtils.EXT_extended_master_secret)) continue;
            }
            byte[] renegExtData = (byte[])serverExtensions.get(TlsProtocol.EXT_RenegotiationInfo);
            if (renegExtData != null) {
                state.secure_renegotiation = true;
                if (!Arrays.constantTimeAreEqual(renegExtData, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
            if ((serverSentEncryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(serverExtensions)) && !TlsUtils.isBlockCipherSuite(state.selectedCipherSuite)) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = serverSentEncryptThenMAC;
            state.maxFragmentLength = DTLSClientProtocol.evaluateMaxFragmentLengthExtension(state.clientExtensions, serverExtensions, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(serverExtensions);
            state.allowCertificateStatus = TlsUtils.hasExpectedEmptyExtensionData(serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)47);
            state.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(serverExtensions, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        state.client.notifySecureRenegotiation(state.secure_renegotiation);
        if (state.clientExtensions != null) {
            state.client.processServerExtensions(serverExtensions);
        }
    }

    protected void processServerKeyExchange(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.keyExchange.processServerKeyExchange(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected void processServerSupplementalData(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Vector serverSupplementalData = TlsProtocol.readSupplementalDataMessage(buf);
        state.client.processServerSupplementalData(serverSupplementalData);
    }

    protected void reportServerVersion(ClientHandshakeState state, ProtocolVersion server_version) throws IOException {
        TlsClientContextImpl clientContext = state.clientContext;
        ProtocolVersion currentServerVersion = clientContext.getServerVersion();
        if (null == currentServerVersion) {
            clientContext.setServerVersion(server_version);
            state.client.notifyServerVersion(server_version);
        } else if (!currentServerVersion.equals(server_version)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected static byte[] patchClientHelloWithCookie(byte[] clientHelloBody, byte[] cookie) throws IOException {
        int sessionIDPos = 34;
        short sessionIDLength = TlsUtils.readUint8(clientHelloBody, sessionIDPos);
        int cookieLengthPos = sessionIDPos + 1 + sessionIDLength;
        int cookiePos = cookieLengthPos + 1;
        byte[] patched = new byte[clientHelloBody.length + cookie.length];
        System.arraycopy(clientHelloBody, 0, patched, 0, cookieLengthPos);
        TlsUtils.checkUint8(cookie.length);
        TlsUtils.writeUint8(cookie.length, patched, cookieLengthPos);
        System.arraycopy(cookie, 0, patched, cookiePos, cookie.length);
        System.arraycopy(clientHelloBody, cookiePos, patched, cookiePos + cookie.length, clientHelloBody.length - cookiePos);
        return patched;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        TlsClientContextImpl clientContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        short[] offeredCompressionMethods = null;
        Hashtable clientExtensions = null;
        byte[] selectedSessionID = null;
        int selectedCipherSuite = -1;
        short selectedCompressionMethod = (short)-1;
        boolean secure_renegotiation = false;
        short maxFragmentLength = (short)-1;
        boolean allowCertificateStatus = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateStatus certificateStatus = null;
        CertificateRequest certificateRequest = null;
        TlsCredentials clientCredentials = null;

        protected ClientHandshakeState() {
        }
    }
}

