/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.pqc.crypto.hqc.HQCKeccakRandomGenerator;
import org.bouncycastle.pqc.crypto.hqc.ReedMuller;
import org.bouncycastle.pqc.crypto.hqc.ReedSolomon;
import org.bouncycastle.pqc.crypto.hqc.Utils;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import org.bouncycastle.util.Arrays;

class HQCEngine {
    private int n;
    private int n1;
    private int n2;
    private int k;
    private int delta;
    private int w;
    private int wr;
    private int we;
    private int g;
    private int rejectionThreshold;
    private int fft;
    private int mulParam;
    private GF2mField field;
    private PolynomialGF2mSmallM reductionPoly;
    private int SEED_SIZE = 40;
    private byte G_FCT_DOMAIN = (byte)3;
    private byte H_FCT_DOMAIN = (byte)4;
    private byte K_FCT_DOMAIN = (byte)5;
    private int N_BYTE;
    private int n1n2;
    private int N_BYTE_64;
    private int K_BYTE;
    private int K_BYTE_64;
    private int N1_BYTE_64;
    private int N1N2_BYTE_64;
    private int N1N2_BYTE;
    private int N1_BYTE;
    private int[] generatorPoly;
    private int SHA512_BYTES = 64;

    public HQCEngine(int n, int n1, int n2, int k, int g, int delta, int w, int wr, int we, int rejectionThreshold, int fft, int[] generatorPoly) {
        GF2mField field;
        this.n = n;
        this.k = k;
        this.delta = delta;
        this.w = w;
        this.wr = wr;
        this.we = we;
        this.n1 = n1;
        this.n2 = n2;
        this.n1n2 = n1 * n2;
        this.generatorPoly = generatorPoly;
        this.g = g;
        this.rejectionThreshold = rejectionThreshold;
        this.fft = fft;
        this.mulParam = (int)Math.ceil(n2 / 128);
        this.N_BYTE = Utils.getByteSizeFromBitSize(n);
        this.K_BYTE = k;
        this.N_BYTE_64 = Utils.getByte64SizeFromBitSize(n);
        this.K_BYTE_64 = Utils.getByteSizeFromBitSize(k);
        this.N1_BYTE_64 = Utils.getByteSizeFromBitSize(n1);
        this.N1N2_BYTE_64 = Utils.getByte64SizeFromBitSize(n1 * n2);
        this.N1N2_BYTE = Utils.getByteSizeFromBitSize(n1 * n2);
        this.N1_BYTE = Utils.getByteSizeFromBitSize(n1);
        this.field = field = new GF2mField(1);
        PolynomialGF2mSmallM poly = new PolynomialGF2mSmallM(field, n);
        this.reductionPoly = poly.addMonomial(0);
    }

    public void genKeyPair(byte[] pk, byte[] sk, byte[] seed) {
        byte[] secretKeySeed = new byte[this.SEED_SIZE];
        HQCKeccakRandomGenerator randomGenerator = new HQCKeccakRandomGenerator(256);
        randomGenerator.randomGeneratorInit(seed, null, seed.length, 0);
        randomGenerator.squeeze(secretKeySeed, 40);
        HQCKeccakRandomGenerator secretKeySeedExpander = new HQCKeccakRandomGenerator(256);
        secretKeySeedExpander.seedExpanderInit(secretKeySeed, secretKeySeed.length);
        long[] xLongBytes = new long[this.N_BYTE_64];
        int[] yPos = new int[this.w];
        this.generateSecretKey(xLongBytes, secretKeySeedExpander, this.w);
        this.generateSecretKeyByCoordinates(yPos, secretKeySeedExpander, this.w);
        byte[] yBits = Utils.fromListOfPos1ToBitArray(yPos, this.n);
        byte[] xBits = new byte[this.n];
        Utils.fromLongArrayToBitArray(xBits, xLongBytes);
        byte[] publicKeySeed = new byte[this.SEED_SIZE];
        randomGenerator.squeeze(publicKeySeed, 40);
        HQCKeccakRandomGenerator randomPublic = new HQCKeccakRandomGenerator(256);
        randomPublic.seedExpanderInit(publicKeySeed, publicKeySeed.length);
        long[] hLongBytes = new long[this.N_BYTE_64];
        this.generatePublicKeyH(hLongBytes, randomPublic);
        byte[] hBits = new byte[this.n];
        Utils.fromLongArrayToBitArray(hBits, hLongBytes);
        PolynomialGF2mSmallM xPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(xBits));
        PolynomialGF2mSmallM yPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(yBits));
        PolynomialGF2mSmallM hPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(hBits));
        PolynomialGF2mSmallM sPoly = xPoly.add(hPoly.modKaratsubaMultiplyBigDeg(yPoly, this.reductionPoly));
        byte[] sBits = sPoly.getEncoded();
        byte[] sBytes = new byte[this.N_BYTE];
        Utils.fromBitArrayToByteArray(sBytes, sBits);
        byte[] tmpPk = Arrays.concatenate(publicKeySeed, sBytes);
        byte[] tmpSk = Arrays.concatenate(secretKeySeed, tmpPk);
        System.arraycopy(tmpPk, 0, pk, 0, tmpPk.length);
        System.arraycopy(tmpSk, 0, sk, 0, tmpSk.length);
    }

    public void encaps(byte[] u, byte[] v, byte[] K, byte[] d, byte[] pk, byte[] seed) {
        byte[] m = new byte[this.K_BYTE];
        byte[] secretKeySeed = new byte[this.SEED_SIZE];
        HQCKeccakRandomGenerator randomGenerator = new HQCKeccakRandomGenerator(256);
        randomGenerator.randomGeneratorInit(seed, null, seed.length, 0);
        randomGenerator.squeeze(secretKeySeed, 40);
        byte[] publicKeySeed = new byte[this.SEED_SIZE];
        randomGenerator.squeeze(publicKeySeed, 40);
        randomGenerator.squeeze(m, this.K_BYTE);
        long[] mLongBytes = new long[this.K_BYTE_64];
        Utils.fromByteArrayToLongArray(mLongBytes, m);
        byte[] theta = new byte[this.SHA512_BYTES];
        HQCKeccakRandomGenerator shakeDigest = new HQCKeccakRandomGenerator(256);
        shakeDigest.SHAKE256_512_ds(theta, m, m.length, new byte[]{this.G_FCT_DOMAIN});
        long[] h = new long[this.N_BYTE_64];
        byte[] s = new byte[this.N_BYTE];
        this.extractPublicKeys(h, s, pk);
        long[] uTmp = new long[this.N_BYTE_64];
        long[] vTmp = new long[this.N1N2_BYTE_64];
        this.encrypt(uTmp, vTmp, h, s, mLongBytes, theta);
        Utils.fromLongArrayToByteArray(v, vTmp, this.n1n2);
        Utils.fromLongArrayToByteArray(u, uTmp, this.n);
        shakeDigest.SHAKE256_512_ds(d, m, m.length, new byte[]{this.H_FCT_DOMAIN});
        byte[] hashInputK = new byte[this.K_BYTE + this.N_BYTE + this.N1N2_BYTE];
        hashInputK = Arrays.concatenate(m, u);
        hashInputK = Arrays.concatenate(hashInputK, v);
        shakeDigest.SHAKE256_512_ds(K, hashInputK, hashInputK.length, new byte[]{this.K_FCT_DOMAIN});
    }

    public void decaps(byte[] ss, byte[] ct, byte[] sk) {
        byte[] yBits = new byte[this.n];
        byte[] pk = new byte[40 + this.N_BYTE];
        this.extractKeysFromSecretKeys(yBits, pk, sk);
        byte[] u = new byte[this.N_BYTE];
        byte[] v = new byte[this.N1N2_BYTE];
        byte[] d = new byte[this.SHA512_BYTES];
        this.extractCiphertexts(u, v, d, ct);
        long[] mPrime = new long[this.K_BYTE_64];
        this.decrypt(mPrime, mPrime, u, v, yBits);
        byte[] mPrimeBytes = new byte[this.k];
        Utils.fromLongArrayToByteArray(mPrimeBytes, mPrime, this.k * 8);
        byte[] theta = new byte[this.SHA512_BYTES];
        HQCKeccakRandomGenerator shakeDigest = new HQCKeccakRandomGenerator(256);
        shakeDigest.SHAKE256_512_ds(theta, mPrimeBytes, mPrimeBytes.length, new byte[]{this.G_FCT_DOMAIN});
        long[] h = new long[this.N_BYTE_64];
        byte[] s = new byte[this.N_BYTE];
        this.extractPublicKeys(h, s, pk);
        long[] uTmp = new long[this.N_BYTE_64];
        long[] vTmp = new long[this.N1N2_BYTE_64];
        this.encrypt(uTmp, vTmp, h, s, mPrime, theta);
        byte[] u2Bytes = new byte[this.N_BYTE];
        byte[] v2Bytes = new byte[this.N1N2_BYTE];
        Utils.fromLongArrayToByteArray(u2Bytes, uTmp, this.n);
        Utils.fromLongArrayToByteArray(v2Bytes, vTmp, this.n1n2);
        byte[] dPrime = new byte[this.SHA512_BYTES];
        shakeDigest.SHAKE256_512_ds(dPrime, mPrimeBytes, mPrimeBytes.length, new byte[]{this.H_FCT_DOMAIN});
        byte[] hashInputK = new byte[this.K_BYTE + this.N_BYTE + this.N1N2_BYTE];
        hashInputK = Arrays.concatenate(mPrimeBytes, u);
        hashInputK = Arrays.concatenate(hashInputK, v);
        shakeDigest.SHAKE256_512_ds(ss, hashInputK, hashInputK.length, new byte[]{this.K_FCT_DOMAIN});
        boolean result = true;
        if (!Arrays.areEqual(u, u2Bytes)) {
            result = false;
        }
        if (!Arrays.areEqual(v, v2Bytes)) {
            result = false;
        }
        if (!Arrays.areEqual(d, dPrime)) {
            result = false;
        }
        if (!result) {
            for (int i = 0; i < this.getSessionKeySize(); ++i) {
                ss[i] = 0;
            }
        }
    }

    int getSessionKeySize() {
        return this.SHA512_BYTES;
    }

    private void encrypt(long[] u, long[] v, long[] h, byte[] s, long[] m, byte[] theta) {
        HQCKeccakRandomGenerator randomGenerator = new HQCKeccakRandomGenerator(256);
        randomGenerator.seedExpanderInit(theta, this.SEED_SIZE);
        long[] e = new long[this.N_BYTE_64];
        long[] r1 = new long[this.N_BYTE_64];
        int[] r2 = new int[this.wr];
        this.generateSecretKey(r1, randomGenerator, this.wr);
        this.generateSecretKeyByCoordinates(r2, randomGenerator, this.wr);
        this.generateSecretKey(e, randomGenerator, this.we);
        byte[] hBits = new byte[this.n];
        Utils.fromLongArrayToBitArray(hBits, h);
        byte[] r1Bits = new byte[this.n];
        Utils.fromLongArrayToBitArray(r1Bits, r1);
        byte[] r2Bits = new byte[this.n];
        r2Bits = Utils.fromListOfPos1ToBitArray(r2, r2Bits.length);
        byte[] eBits = new byte[this.n];
        Utils.fromLongArrayToBitArray(eBits, e);
        byte[] sBits = new byte[this.n];
        Utils.fromByteArrayToBitArray(sBits, s);
        PolynomialGF2mSmallM r1Poly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(r1Bits));
        PolynomialGF2mSmallM r2Poly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(r2Bits));
        PolynomialGF2mSmallM hPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(hBits));
        PolynomialGF2mSmallM uPoly = r1Poly.add(r2Poly.modKaratsubaMultiplyBigDeg(hPoly, this.reductionPoly));
        Utils.fromBitArrayToLongArray(u, uPoly.getEncoded());
        PolynomialGF2mSmallM sPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(sBits));
        PolynomialGF2mSmallM ePoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(eBits));
        long[] res = new long[this.N1_BYTE_64];
        ReedSolomon.encode(res, m, this.K_BYTE * 8, this.n1, this.k, this.g, this.generatorPoly);
        ReedMuller.encode(v, res, this.n1, this.mulParam);
        byte[] vBits = new byte[this.n1n2];
        Utils.fromLongArrayToBitArray(vBits, v);
        PolynomialGF2mSmallM vPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(vBits));
        vPoly = vPoly.add(sPoly.modKaratsubaMultiplyBigDeg(r2Poly, this.reductionPoly));
        vPoly = vPoly.add(ePoly);
        long[] vLongTmp = new long[this.N_BYTE_64];
        Utils.fromBitArrayToLongArray(vLongTmp, vPoly.getEncoded());
        Utils.resizeArray(v, this.n1n2, vLongTmp, this.n, this.N1N2_BYTE_64, this.N1N2_BYTE_64);
    }

    private void decrypt(long[] output, long[] m, byte[] u, byte[] v, byte[] yBits) {
        byte[] uBits = new byte[this.n];
        Utils.fromByteArrayToBitArray(uBits, u);
        byte[] vBits = new byte[this.n1n2];
        Utils.fromByteArrayToBitArray(vBits, v);
        long[] uLong = new long[this.N_BYTE_64];
        Utils.fromBitArrayToLongArray(uLong, uBits);
        long[] vLong = new long[this.N1N2_BYTE_64];
        Utils.fromBitArrayToLongArray(vLong, vBits);
        PolynomialGF2mSmallM uPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(uBits));
        PolynomialGF2mSmallM vPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(vBits));
        PolynomialGF2mSmallM yPoly = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(yBits));
        PolynomialGF2mSmallM res = vPoly.add(uPoly.modKaratsubaMultiplyBigDeg(yPoly, this.reductionPoly));
        long[] resLong = new long[this.N_BYTE_64];
        Utils.fromBitArrayToLongArray(resLong, res.getEncoded());
        long[] tmp = new long[this.N1_BYTE_64];
        ReedMuller.decode(tmp, resLong, this.n1, this.mulParam);
        ReedSolomon.decode(m, tmp, this.n1, this.fft, this.delta, this.k, this.g);
        System.arraycopy(m, 0, output, 0, output.length);
    }

    private void generateSecretKey(long[] output, HQCKeccakRandomGenerator random, int w) {
        int[] tmp = new int[w];
        this.generateSecretKeyByCoordinates(tmp, random, w);
        for (int i = 0; i < w; ++i) {
            int index = tmp[i] / 64;
            int pos = tmp[i] % 64;
            long t = 1L << pos;
            int n = index;
            output[n] = output[n] | t;
        }
    }

    private void generateSecretKeyByCoordinates(int[] output, HQCKeccakRandomGenerator random, int w) {
        int inc;
        int randomByteSize = 3 * w;
        byte[] randomBytes = new byte[3 * this.wr];
        int j = randomByteSize;
        for (int i = 0; i < w; i += inc) {
            do {
                if (j == randomByteSize) {
                    random.expandSeed(randomBytes, randomByteSize);
                    j = 0;
                }
                output[i] = (randomBytes[j++] & 0xFF) << 16;
                int n = i;
                output[n] = output[n] | (randomBytes[j++] & 0xFF) << 8;
                int n2 = i;
                output[n2] = output[n2] | randomBytes[j++] & 0xFF;
            } while (output[i] >= this.rejectionThreshold);
            output[i] = output[i] % this.n;
            inc = 1;
            for (int k = 0; k < i; ++k) {
                if (output[k] != output[i]) continue;
                inc = 0;
            }
        }
    }

    void generatePublicKeyH(long[] out, HQCKeccakRandomGenerator random) {
        byte[] randBytes = new byte[this.N_BYTE];
        random.expandSeed(randBytes, this.N_BYTE);
        long[] tmp = new long[this.N_BYTE_64];
        Utils.fromByteArrayToLongArray(tmp, randBytes);
        int n = this.N_BYTE_64 - 1;
        tmp[n] = tmp[n] & Utils.bitMask(this.n, 64L);
        System.arraycopy(tmp, 0, out, 0, out.length);
    }

    private void extractPublicKeys(long[] h, byte[] s, byte[] pk) {
        byte[] publicKeySeed = new byte[this.SEED_SIZE];
        System.arraycopy(pk, 0, publicKeySeed, 0, publicKeySeed.length);
        HQCKeccakRandomGenerator randomPublic = new HQCKeccakRandomGenerator(256);
        randomPublic.seedExpanderInit(publicKeySeed, publicKeySeed.length);
        long[] hLongBytes = new long[this.N_BYTE_64];
        this.generatePublicKeyH(hLongBytes, randomPublic);
        System.arraycopy(hLongBytes, 0, h, 0, h.length);
        System.arraycopy(pk, 40, s, 0, s.length);
    }

    private void extractKeysFromSecretKeys(byte[] y, byte[] pk, byte[] sk) {
        byte[] secretKeySeed = new byte[this.SEED_SIZE];
        System.arraycopy(sk, 0, secretKeySeed, 0, secretKeySeed.length);
        HQCKeccakRandomGenerator secretKeySeedExpander = new HQCKeccakRandomGenerator(256);
        secretKeySeedExpander.seedExpanderInit(secretKeySeed, secretKeySeed.length);
        long[] xLongBytes = new long[this.N_BYTE_64];
        int[] yPos = new int[this.w];
        this.generateSecretKey(xLongBytes, secretKeySeedExpander, this.w);
        this.generateSecretKeyByCoordinates(yPos, secretKeySeedExpander, this.w);
        byte[] yBits = Utils.fromListOfPos1ToBitArray(yPos, this.n);
        System.arraycopy(yBits, 0, y, 0, y.length);
        System.arraycopy(sk, this.SEED_SIZE, pk, 0, pk.length);
    }

    private void extractCiphertexts(byte[] u, byte[] v, byte[] d, byte[] ct) {
        System.arraycopy(ct, 0, u, 0, u.length);
        System.arraycopy(ct, u.length, v, 0, v.length);
        System.arraycopy(ct, u.length + v.length, d, 0, d.length);
    }
}

