/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mlkem;

import org.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MLKEMPublicKeyParameters
extends MLKEMKeyParameters {
    final byte[] t;
    final byte[] rho;

    static byte[] getEncoded(byte[] t, byte[] rho) {
        return Arrays.concatenate(t, rho);
    }

    public MLKEMPublicKeyParameters(MLKEMParameters params, byte[] t, byte[] rho) {
        super(false, params);
        MLKEMEngine engine = params.getEngine();
        if (t.length != engine.getKyberPolyVecBytes()) {
            throw new IllegalArgumentException("'t' has invalid length");
        }
        if (rho.length != 32) {
            throw new IllegalArgumentException("'rho' has invalid length");
        }
        this.t = Arrays.clone(t);
        this.rho = Arrays.clone(rho);
        if (!engine.checkModulus(this.t)) {
            throw new IllegalArgumentException("Modulus check failed for ML-KEM public key");
        }
    }

    public MLKEMPublicKeyParameters(MLKEMParameters params, byte[] encoding) {
        super(false, params);
        MLKEMEngine engine = params.getEngine();
        if (encoding.length != engine.getKyberIndCpaPublicKeyBytes()) {
            throw new IllegalArgumentException("'encoding' has invalid length");
        }
        this.t = Arrays.copyOfRange(encoding, 0, encoding.length - 32);
        this.rho = Arrays.copyOfRange(encoding, encoding.length - 32, encoding.length);
        if (!engine.checkModulus(this.t)) {
            throw new IllegalArgumentException("Modulus check failed for ML-KEM public key");
        }
    }

    public byte[] getEncoded() {
        return MLKEMPublicKeyParameters.getEncoded(this.t, this.rho);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getT() {
        return Arrays.clone(this.t);
    }
}

