/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.util.Arrays;

public final class MessageSignerAdapter
implements Signer {
    private final Buffer buffer = new Buffer();
    private final MessageSigner messageSigner;

    public MessageSignerAdapter(MessageSigner messageSigner) {
        if (messageSigner == null) {
            throw new NullPointerException("'messageSigner' cannot be null");
        }
        this.messageSigner = messageSigner;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.messageSigner.init(forSigning, param);
    }

    @Override
    public void update(byte b) {
        this.buffer.write(b);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.buffer.write(in, off, len);
    }

    @Override
    public byte[] generateSignature() {
        return this.messageSigner.generateSignature(this.getMessage());
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        return this.messageSigner.verifySignature(this.getMessage(), signature);
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    private byte[] getMessage() {
        try {
            byte[] byArray = this.buffer.toByteArray();
            return byArray;
        }
        finally {
            this.reset();
        }
    }

    private static final class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

