/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.params.ECCSIKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECCSIPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECCSIPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class ECCSIKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private BigInteger q;
    private ECPoint G;
    private Digest digest;
    private ECCSIKeyGenerationParameters parameters;

    @Override
    public void init(KeyGenerationParameters parameters) {
        this.parameters = (ECCSIKeyGenerationParameters)parameters;
        this.q = this.parameters.getQ();
        this.G = this.parameters.getG();
        this.digest = this.parameters.getDigest();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ECCSI", this.parameters.getN(), null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom random = this.parameters.getRandom();
        this.digest.reset();
        byte[] id = this.parameters.getId();
        ECPoint kpak = this.parameters.getKPAK();
        BigInteger v = BigIntegers.createRandomBigInteger(256, random).mod(this.q);
        ECPoint pvt = this.G.multiply(v).normalize();
        byte[] tmp = this.G.getEncoded(false);
        this.digest.update(tmp, 0, tmp.length);
        tmp = kpak.getEncoded(false);
        this.digest.update(tmp, 0, tmp.length);
        this.digest.update(id, 0, id.length);
        tmp = pvt.getEncoded(false);
        this.digest.update(tmp, 0, tmp.length);
        tmp = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(tmp, 0);
        BigInteger HS = new BigInteger(1, tmp).mod(this.q);
        BigInteger ssk = this.parameters.computeSSK(HS.multiply(v));
        ECCSIPublicKeyParameters pub = new ECCSIPublicKeyParameters(pvt);
        return new AsymmetricCipherKeyPair(new ECCSIPublicKeyParameters(pvt), new ECCSIPrivateKeyParameters(ssk, pub));
    }
}

