/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.CSHAKEDigest;
import org.bouncycastle.crypto.digests.XofUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

public class TupleHash
implements Xof,
SavableDigest {
    private static final byte[] N_TUPLE_HASH = Strings.toByteArray("TupleHash");
    private final CSHAKEDigest cshake;
    private int bitLength;
    private int outputLength;
    private boolean firstOutput;

    public TupleHash(int bitLength, byte[] S) {
        this(bitLength, S, bitLength * 2);
    }

    public TupleHash(int bitLength, byte[] S, int outputSize) {
        this.cshake = new CSHAKEDigest(bitLength, N_TUPLE_HASH, S);
        this.bitLength = bitLength;
        this.outputLength = (outputSize + 7) / 8;
        this.reset();
    }

    public TupleHash(TupleHash original) {
        this.cshake = new CSHAKEDigest(original.cshake);
        this.bitLength = original.bitLength;
        this.outputLength = original.outputLength;
        this.firstOutput = original.firstOutput;
    }

    public TupleHash(byte[] state) {
        this.cshake = new CSHAKEDigest(Arrays.copyOfRange(state, 0, state.length - 9));
        this.bitLength = Pack.bigEndianToInt(state, state.length - 9);
        this.outputLength = Pack.bigEndianToInt(state, state.length - 5);
        this.firstOutput = state[state.length - 1] != 0;
    }

    private void copyIn(TupleHash original) {
        this.cshake.reset(original.cshake);
        this.bitLength = this.cshake.fixedOutputLength;
        this.outputLength = this.bitLength * 2 / 8;
        this.firstOutput = original.firstOutput;
    }

    @Override
    public String getAlgorithmName() {
        return "TupleHash" + this.cshake.getAlgorithmName().substring(6);
    }

    @Override
    public int getByteLength() {
        return this.cshake.getByteLength();
    }

    @Override
    public int getDigestSize() {
        return this.outputLength;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        byte[] bytes = XofUtils.encode(in);
        this.cshake.update(bytes, 0, bytes.length);
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        byte[] bytes = XofUtils.encode(in, inOff, len);
        this.cshake.update(bytes, 0, bytes.length);
    }

    private void wrapUp(int outputSize) {
        byte[] encOut = XofUtils.rightEncode((long)outputSize * 8L);
        this.cshake.update(encOut, 0, encOut.length);
        this.firstOutput = false;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.firstOutput) {
            this.wrapUp(this.getDigestSize());
        }
        int rv = this.cshake.doFinal(out, outOff, this.getDigestSize());
        this.reset();
        return rv;
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        if (this.firstOutput) {
            this.wrapUp(this.getDigestSize());
        }
        int rv = this.cshake.doFinal(out, outOff, outLen);
        this.reset();
        return rv;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.firstOutput) {
            this.wrapUp(0);
        }
        return this.cshake.doOutput(out, outOff, outLen);
    }

    @Override
    public void reset() {
        this.cshake.reset();
        this.firstOutput = true;
    }

    @Override
    public byte[] getEncodedState() {
        byte[] cshakeState = this.cshake.getEncodedState();
        byte[] extraState = new byte[9];
        Pack.intToBigEndian(this.bitLength, extraState, 0);
        Pack.intToBigEndian(this.outputLength, extraState, 4);
        extraState[8] = this.firstOutput ? (byte)1 : 0;
        return Arrays.concatenate(cshakeState, extraState);
    }

    @Override
    public Memoable copy() {
        return new TupleHash(this);
    }

    @Override
    public void reset(Memoable other) {
        this.copyIn((TupleHash)other);
    }
}

