/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.agreement.ecjpake;

import java.math.BigInteger;
import org.bouncycastle.crypto.agreement.ecjpake.ECJPAKEUtil;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class ECJPAKECurve {
    private final ECCurve.AbstractFp curve;
    private final ECPoint g;

    public ECJPAKECurve(BigInteger q, BigInteger a, BigInteger b, BigInteger n, BigInteger h, BigInteger g_x, BigInteger g_y) {
        ECJPAKEUtil.validateNotNull(a, "a");
        ECJPAKEUtil.validateNotNull(b, "b");
        ECJPAKEUtil.validateNotNull(q, "q");
        ECJPAKEUtil.validateNotNull(n, "n");
        ECJPAKEUtil.validateNotNull(h, "h");
        ECJPAKEUtil.validateNotNull(g_x, "g_x");
        ECJPAKEUtil.validateNotNull(g_y, "g_y");
        if (!q.isProbablePrime(20)) {
            throw new IllegalArgumentException("Field size q must be prime");
        }
        if (a.compareTo(BigInteger.ZERO) < 0 || a.compareTo(q) >= 0) {
            throw new IllegalArgumentException("The parameter 'a' is not in the field [0, q-1]");
        }
        if (b.compareTo(BigInteger.ZERO) < 0 || b.compareTo(q) >= 0) {
            throw new IllegalArgumentException("The parameter 'b' is not in the field [0, q-1]");
        }
        BigInteger d = ECJPAKECurve.calculateDeterminant(q, a, b);
        if (d.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("The curve is singular, i.e the discriminant is equal to 0 mod q.");
        }
        if (!n.isProbablePrime(20)) {
            throw new IllegalArgumentException("The order n must be prime");
        }
        this.curve = new ECCurve.Fp(q, a, b, n, h);
        this.g = this.curve.validatePoint(g_x, g_y);
    }

    ECJPAKECurve(ECCurve.AbstractFp curve, ECPoint g) {
        ECJPAKEUtil.validateNotNull(curve, "curve");
        ECJPAKEUtil.validateNotNull(g, "g");
        ECJPAKEUtil.validateNotNull(curve.getOrder(), "n");
        ECJPAKEUtil.validateNotNull(curve.getCofactor(), "h");
        this.curve = curve;
        this.g = g;
    }

    public ECCurve.AbstractFp getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.g;
    }

    public BigInteger getA() {
        return this.curve.getA().toBigInteger();
    }

    public BigInteger getB() {
        return this.curve.getB().toBigInteger();
    }

    public BigInteger getN() {
        return this.curve.getOrder();
    }

    public BigInteger getH() {
        return this.curve.getCofactor();
    }

    public BigInteger getQ() {
        return this.curve.getQ();
    }

    private static BigInteger calculateDeterminant(BigInteger q, BigInteger a, BigInteger b) {
        BigInteger a3x4 = a.multiply(a).mod(q).multiply(a).mod(q).shiftLeft(2);
        BigInteger b2x27 = b.multiply(b).mod(q).multiply(BigInteger.valueOf(27L));
        return a3x4.add(b2x27).mod(q);
    }
}

