/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ASN1T61String
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1T61String.class, 20){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            return ASN1T61String.createPrimitive(octetString.getOctets());
        }
    };
    final byte[] contents;

    public static ASN1T61String getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1T61String) {
            return (ASN1T61String)obj;
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1T61String) {
            return (ASN1T61String)primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1T61String)TYPE.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1T61String getInstance(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        return (ASN1T61String)TYPE.getContextTagged(taggedObject, declaredExplicit);
    }

    public static ASN1T61String getTagged(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        return (ASN1T61String)TYPE.getTagged(taggedObject, declaredExplicit);
    }

    ASN1T61String(String string) {
        this.contents = Strings.toByteArray(string);
    }

    ASN1T61String(byte[] contents, boolean clone) {
        this.contents = clone ? Arrays.clone(contents) : contents;
    }

    @Override
    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    final boolean encodeConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean withTag) {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodingDL(withTag, 20, this.contents);
    }

    public final byte[] getOctets() {
        return Arrays.clone(this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive other) {
        if (!(other instanceof ASN1T61String)) {
            return false;
        }
        ASN1T61String that = (ASN1T61String)other;
        return Arrays.areEqual(this.contents, that.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1T61String createPrimitive(byte[] contents) {
        return new DERT61String(contents, false);
    }
}

