/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class GF2PolynomialCalculator {
    private final int VEC_N_SIZE_64;
    private final int PARAM_N;
    private final long RED_MASK;

    GF2PolynomialCalculator(int vec_n_size_64, int param_n, long red_mask) {
        this.VEC_N_SIZE_64 = vec_n_size_64;
        this.PARAM_N = param_n;
        this.RED_MASK = red_mask;
    }

    public void vectMul(long[] o, long[] a1, long[] a2) {
        long[] unreduced = new long[this.VEC_N_SIZE_64 << 1];
        long[] tmpBuffer = new long[this.VEC_N_SIZE_64 << 4];
        this.karatsuba(unreduced, 0, a1, 0, a2, 0, this.VEC_N_SIZE_64, tmpBuffer, 0);
        this.reduce(o, unreduced);
    }

    private void schoolbookMul(long[] r, int rOff, long[] a, int aOff, long[] b, int bOff, int n) {
        Arrays.fill(r, rOff, rOff + (n << 1), 0L);
        int i = 0;
        while (i < n) {
            long ai = a[i + aOff];
            for (int bit = 0; bit < 64; ++bit) {
                long mask = -(ai >> bit & 1L);
                if (bit == 0) {
                    int j = 0;
                    int rOff1 = rOff;
                    int bOff1 = bOff;
                    while (j < n) {
                        int n2 = rOff1++;
                        r[n2] = r[n2] ^ b[bOff1] & mask;
                        ++j;
                        ++bOff1;
                    }
                    continue;
                }
                int inv = 64 - bit;
                int j = 0;
                int rOff1 = rOff;
                int bOff1 = bOff;
                while (j < n) {
                    int n3 = rOff1++;
                    r[n3] = r[n3] ^ b[bOff1] << bit & mask;
                    int n4 = rOff1;
                    r[n4] = r[n4] ^ b[bOff1] >>> inv & mask;
                    ++j;
                    ++bOff1;
                }
            }
            ++i;
            ++rOff;
        }
    }

    private void karatsuba(long[] r, int rOffset, long[] a, int aOffset, long[] b, int bOffset, int n, long[] tmpBuffer, int tmpOffset) {
        int i;
        if (n <= 16) {
            this.schoolbookMul(r, rOffset, a, aOffset, b, bOffset, n);
            return;
        }
        int m = n >> 1;
        int n1 = n - m;
        int nx2 = n << 1;
        int mx2 = m << 1;
        int n1x2 = n1 << 1;
        int z2Offset = tmpOffset + nx2;
        int zMidOffset = z2Offset + nx2;
        int taOffset = zMidOffset + nx2;
        int tbOffset = taOffset + n;
        int childBufferOffset = tmpOffset + (n << 3);
        this.karatsuba(tmpBuffer, tmpOffset, a, aOffset, b, bOffset, m, tmpBuffer, childBufferOffset);
        this.karatsuba(tmpBuffer, z2Offset, a, aOffset + m, b, bOffset + m, n1, tmpBuffer, childBufferOffset);
        for (i = 0; i < n1; ++i) {
            long loa = i < m ? a[aOffset + i] : 0L;
            long lob = i < m ? b[bOffset + i] : 0L;
            tmpBuffer[taOffset + i] = loa ^ a[aOffset + m + i];
            tmpBuffer[tbOffset + i] = lob ^ b[bOffset + m + i];
        }
        this.karatsuba(tmpBuffer, zMidOffset, tmpBuffer, taOffset, tmpBuffer, tbOffset, n1, tmpBuffer, childBufferOffset);
        System.arraycopy(tmpBuffer, tmpOffset, r, rOffset, mx2);
        System.arraycopy(tmpBuffer, z2Offset, r, rOffset + mx2, n1x2);
        for (i = 0; i < 2 * n1; ++i) {
            long z0i = i < mx2 ? tmpBuffer[tmpOffset + i] : 0L;
            long z2i = i < n1x2 ? tmpBuffer[z2Offset + i] : 0L;
            int n2 = rOffset + m + i;
            r[n2] = r[n2] ^ (tmpBuffer[zMidOffset + i] ^ z0i ^ z2i);
        }
    }

    private void reduce(long[] o, long[] a) {
        for (int i = 0; i < this.VEC_N_SIZE_64; ++i) {
            o[i] = a[i] ^ a[i + this.VEC_N_SIZE_64 - 1] >>> (this.PARAM_N & 0x3F) ^ a[i + this.VEC_N_SIZE_64] << (int)(64L - ((long)this.PARAM_N & 0x3FL));
        }
        int n = this.VEC_N_SIZE_64 - 1;
        o[n] = o[n] & this.RED_MASK;
    }
}

