/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import org.bouncycastle.pqc.crypto.cmce.CMCEKeyParameters;
import org.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CMCEPrivateKeyParameters
extends CMCEKeyParameters {
    private final byte[] privateKey;

    public byte[] getPrivateKey() {
        return Arrays.clone(this.privateKey);
    }

    public CMCEPrivateKeyParameters(CMCEParameters params, byte[] privateKey) {
        super(true, params);
        this.privateKey = Arrays.clone(privateKey);
    }

    public CMCEPrivateKeyParameters(CMCEParameters params, byte[] delta, byte[] C, byte[] g, byte[] alpha, byte[] s) {
        super(true, params);
        int sk_size = delta.length + C.length + g.length + alpha.length + s.length;
        this.privateKey = new byte[sk_size];
        int offset = 0;
        System.arraycopy(delta, 0, this.privateKey, offset, delta.length);
        System.arraycopy(C, 0, this.privateKey, offset += delta.length, C.length);
        System.arraycopy(g, 0, this.privateKey, offset += C.length, g.length);
        System.arraycopy(alpha, 0, this.privateKey, offset += g.length, alpha.length);
        System.arraycopy(s, 0, this.privateKey, offset += alpha.length, s.length);
    }

    public byte[] reconstructPublicKey() {
        CMCEEngine engine = this.getParameters().getEngine();
        return engine.generate_public_key_from_private_key(this.privateKey);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.privateKey);
    }

    public byte[] getDelta() {
        return Arrays.copyOfRange(this.privateKey, 0, 32);
    }

    public byte[] getC() {
        return Arrays.copyOfRange(this.privateKey, 32, 40);
    }

    public byte[] getG() {
        return Arrays.copyOfRange(this.privateKey, 40, 40 + this.getParameters().getT() * 2);
    }

    public byte[] getAlpha() {
        return Arrays.copyOfRange(this.privateKey, 40 + this.getParameters().getT() * 2, this.privateKey.length - 32);
    }

    public byte[] getS() {
        return Arrays.copyOfRange(this.privateKey, this.privateKey.length - 32, this.privateKey.length);
    }
}

