/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ASN1Null
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1Null.class, 5){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            ASN1Null.checkContentsLength(octetString.getOctetsLength());
            return ASN1Null.createPrimitive();
        }
    };

    public static ASN1Null getInstance(Object o) {
        if (o instanceof ASN1Null) {
            return (ASN1Null)o;
        }
        if (o != null) {
            try {
                return (ASN1Null)TYPE.fromByteArray((byte[])o);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct NULL from byte[]: " + e.getMessage());
            }
        }
        return null;
    }

    public static ASN1Null getInstance(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        return (ASN1Null)TYPE.getContextTagged(taggedObject, declaredExplicit);
    }

    public static ASN1Null getTagged(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        return (ASN1Null)TYPE.getTagged(taggedObject, declaredExplicit);
    }

    ASN1Null() {
    }

    @Override
    public int hashCode() {
        return -1;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        return o instanceof ASN1Null;
    }

    public String toString() {
        return "NULL";
    }

    static void checkContentsLength(int contentsLength) {
        if (0 != contentsLength) {
            throw new IllegalStateException("malformed NULL encoding encountered");
        }
    }

    static ASN1Null createPrimitive() {
        return DERNull.INSTANCE;
    }
}

