/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.kdf.hkdf;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.KDFParameters;
import javax.crypto.KDFSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.HKDFParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jcajce.spec.HKDFParameterSpec;

class HKDFSpi
extends KDFSpi {
    protected HKDFBytesGenerator hkdf;

    public HKDFSpi(KDFParameters kdfParameters, Digest digest) throws InvalidAlgorithmParameterException {
        super(HKDFSpi.requireNull(kdfParameters, "HKDF does not support parameters"));
        this.hkdf = new HKDFBytesGenerator(digest);
    }

    protected KDFParameters engineGetParameters() {
        return null;
    }

    protected SecretKey engineDeriveKey(String alg, AlgorithmParameterSpec derivationSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        byte[] derivedKey = this.engineDeriveData(derivationSpec);
        return new SecretKeySpec(derivedKey, alg);
    }

    protected byte[] engineDeriveData(AlgorithmParameterSpec derivationSpec) throws InvalidAlgorithmParameterException {
        if (derivationSpec == null || !(derivationSpec instanceof HKDFParameterSpec) && !(derivationSpec instanceof javax.crypto.spec.HKDFParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec provided");
        }
        HKDFParameters hkdfParameters = null;
        int derivedDataLength = 0;
        if (derivationSpec instanceof HKDFParameterSpec.ExtractThenExpand) {
            HKDFParameterSpec.ExtractThenExpand spec = (HKDFParameterSpec.ExtractThenExpand)derivationSpec;
            List ikms = spec.ikms();
            List salts = spec.salts();
            hkdfParameters = new HKDFParameters(((SecretKey)ikms.get(0)).getEncoded(), ((SecretKey)salts.get(0)).getEncoded(), spec.info());
            derivedDataLength = spec.length();
            this.hkdf.init(hkdfParameters);
            byte[] derivedData = new byte[derivedDataLength];
            this.hkdf.generateBytes(derivedData, 0, derivedDataLength);
            return derivedData;
        }
        if (derivationSpec instanceof HKDFParameterSpec.Extract) {
            HKDFParameterSpec.Extract spec = (HKDFParameterSpec.Extract)derivationSpec;
            List ikms = spec.ikms();
            List salts = spec.salts();
            return this.hkdf.extractPRK(((SecretKey)salts.get(0)).getEncoded(), ((SecretKey)ikms.get(0)).getEncoded());
        }
        if (derivationSpec instanceof HKDFParameterSpec) {
            HKDFParameterSpec spec = (HKDFParameterSpec)derivationSpec;
            hkdfParameters = new HKDFParameters(spec.getIKM(), spec.getSalt(), spec.getInfo());
            derivedDataLength = spec.getOutputLength();
            this.hkdf.init(hkdfParameters);
            byte[] derivedData = new byte[derivedDataLength];
            this.hkdf.generateBytes(derivedData, 0, derivedDataLength);
            return derivedData;
        }
        throw new InvalidAlgorithmParameterException("invalid HKDFParameterSpec provided");
    }

    private static KDFParameters requireNull(KDFParameters kdfParameters, String message) throws InvalidAlgorithmParameterException {
        if (kdfParameters != null) {
            throw new InvalidAlgorithmParameterException(message);
        }
        return null;
    }

    public static class HKDFwithSHA512
    extends HKDFSpi {
        public HKDFwithSHA512(KDFParameters kdfParameters) throws InvalidAlgorithmParameterException {
            super(kdfParameters, new SHA512Digest());
        }

        public HKDFwithSHA512() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class HKDFwithSHA384
    extends HKDFSpi {
        public HKDFwithSHA384(KDFParameters kdfParameters) throws InvalidAlgorithmParameterException {
            super(kdfParameters, new SHA384Digest());
        }

        public HKDFwithSHA384() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class HKDFwithSHA256
    extends HKDFSpi {
        public HKDFwithSHA256(KDFParameters kdfParameters) throws InvalidAlgorithmParameterException {
            super(kdfParameters, new SHA256Digest());
        }

        public HKDFwithSHA256() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }
}

