/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GF16 {
    private static final byte[] F_STAR = new byte[]{1, 2, 4, 8, 3, 6, 12, 11, 5, 10, 7, 14, 15, 13, 9};
    private static final byte[] MT4B = new byte[256];
    private static final byte[] INV4B = new byte[16];

    static byte mt(int p, int q) {
        return MT4B[p << 4 ^ q];
    }

    public static byte mul(byte a, byte b) {
        return MT4B[a << 4 | b];
    }

    public static int mul(int a, int b) {
        return MT4B[a << 4 | b];
    }

    public static byte inv(byte a) {
        return INV4B[a & 0xF];
    }

    public static void decode(byte[] input, byte[] output, int outputLen) {
        int i;
        int decIndex = 0;
        int blocks = outputLen >> 1;
        for (i = 0; i < blocks; ++i) {
            output[decIndex++] = (byte)(input[i] & 0xF);
            output[decIndex++] = (byte)(input[i] >>> 4 & 0xF);
        }
        if ((outputLen & 1) == 1) {
            output[decIndex] = (byte)(input[i] & 0xF);
        }
    }

    public static void decode(byte[] input, int inOff, byte[] output, int outOff, int outputLen) {
        int blocks = outputLen >> 1;
        for (int i = 0; i < blocks; ++i) {
            output[outOff++] = (byte)(input[inOff] & 0xF);
            output[outOff++] = (byte)(input[inOff++] >>> 4 & 0xF);
        }
        if ((outputLen & 1) == 1) {
            output[outOff] = (byte)(input[inOff] & 0xF);
        }
    }

    public static void encode(byte[] input, byte[] output, int inputLen) {
        int inOff = 0;
        int blocks = inputLen >> 1;
        for (int i = 0; i < blocks; ++i) {
            int lowerNibble = input[inOff++] & 0xF;
            int upperNibble = (input[inOff++] & 0xF) << 4;
            output[i] = (byte)(lowerNibble | upperNibble);
        }
        if ((inputLen & 1) == 1) {
            output[i] = (byte)(input[inOff] & 0xF);
        }
    }

    public static void encode(byte[] input, byte[] output, int outOff, int inputLen) {
        int inOff = 0;
        int blocks = inputLen >> 1;
        for (int i = 0; i < blocks; ++i) {
            int lowerNibble = input[inOff++] & 0xF;
            int upperNibble = (input[inOff++] & 0xF) << 4;
            output[outOff++] = (byte)(lowerNibble | upperNibble);
        }
        if ((inputLen & 1) == 1) {
            output[outOff] = (byte)(input[inOff] & 0xF);
        }
    }

    public static byte innerProduct(byte[] a, int aOff, byte[] b, int bOff, int rank) {
        byte result = 0;
        int k = 0;
        while (k < rank) {
            result = (byte)(result ^ GF16.mul(a[aOff++], b[bOff]));
            ++k;
            bOff += rank;
        }
        return result;
    }

    static {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 15; ++j) {
                GF16.MT4B[GF16.F_STAR[i] << 4 ^ GF16.F_STAR[j]] = F_STAR[(i + j) % 15];
            }
        }
        byte g = F_STAR[1];
        byte g_inv = F_STAR[14];
        int gn = 1;
        int gn_inv = 1;
        GF16.INV4B[1] = 1;
        for (int i = 0; i < 14; ++i) {
            gn = GF16.mt(gn, g);
            gn_inv = GF16.mt(gn_inv, g_inv);
            GF16.INV4B[gn] = (byte)gn_inv;
        }
    }
}

