/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xwing;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xwing.XWingPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xwing.XWingPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class XWingKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    private void initialize(KeyGenerationParameters param) {
        this.random = param.getRandom();
    }

    static AsymmetricCipherKeyPair genKeyPair(byte[] seed) {
        SHAKEDigest shake = new SHAKEDigest(256);
        shake.update(seed, 0, seed.length);
        byte[] expanded = new byte[96];
        shake.doOutput(expanded, 0, expanded.length);
        byte[] mlkemSeed = Arrays.copyOfRange(expanded, 0, 64);
        byte[] skX = Arrays.copyOfRange(expanded, 64, 96);
        FixedSecureRandom mlkemRandom = new FixedSecureRandom(mlkemSeed);
        MLKEMKeyPairGenerator mlkemKeyGen = new MLKEMKeyPairGenerator();
        mlkemKeyGen.init(new MLKEMKeyGenerationParameters((SecureRandom)mlkemRandom, MLKEMParameters.ml_kem_768));
        AsymmetricCipherKeyPair mlkemKp = mlkemKeyGen.generateKeyPair();
        MLKEMPublicKeyParameters mlkemPub = (MLKEMPublicKeyParameters)mlkemKp.getPublic();
        MLKEMPrivateKeyParameters mlkemPriv = (MLKEMPrivateKeyParameters)mlkemKp.getPrivate();
        FixedSecureRandom xdhRandom = new FixedSecureRandom(skX);
        X25519KeyPairGenerator xdhKeyGen = new X25519KeyPairGenerator();
        xdhKeyGen.init(new X25519KeyGenerationParameters(xdhRandom));
        AsymmetricCipherKeyPair xdhKp = xdhKeyGen.generateKeyPair();
        X25519PublicKeyParameters xdhPub = (X25519PublicKeyParameters)xdhKp.getPublic();
        X25519PrivateKeyParameters xdhPriv = (X25519PrivateKeyParameters)xdhKp.getPrivate();
        return new AsymmetricCipherKeyPair(new XWingPublicKeyParameters(mlkemPub, xdhPub), new XWingPrivateKeyParameters(seed, mlkemPriv, xdhPriv, mlkemPub, xdhPub));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] seed = new byte[32];
        this.random.nextBytes(seed);
        return XWingKeyPairGenerator.genKeyPair(seed);
    }
}

