/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecL {
    private final Poly[] vec;

    PolyVecL(MLDSAEngine engine) {
        int dilithiumL = engine.getDilithiumL();
        this.vec = new Poly[dilithiumL];
        for (int i = 0; i < dilithiumL; ++i) {
            this.vec[i] = new Poly(engine);
        }
    }

    public PolyVecL() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int i) {
        return this.vec[i];
    }

    void uniformBlocks(byte[] rho, int t) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.vec[i].uniformBlocks(rho, (short)(t + i));
        }
    }

    public void uniformEta(byte[] seed, short nonce) {
        short n = nonce;
        for (int i = 0; i < this.vec.length; ++i) {
            short s = n;
            n = (short)(n + 1);
            this.getVectorIndex(i).uniformEta(seed, s);
        }
    }

    void copyTo(PolyVecL z) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.vec[i].copyTo(z.vec[i]);
        }
    }

    public void polyVecNtt() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.vec[i].polyNtt();
        }
    }

    public void uniformGamma1(byte[] seed, short nonce) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).uniformGamma1(seed, (short)(this.vec.length * nonce + i));
        }
    }

    public void pointwisePolyMontgomery(Poly a, PolyVecL v) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).pointwiseMontgomery(a, v.getVectorIndex(i));
        }
    }

    public void invNttToMont() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).invNttToMont();
        }
    }

    public void addPolyVecL(PolyVecL v) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).addPoly(v.getVectorIndex(i));
        }
    }

    public void reduce() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).reduce();
        }
    }

    public boolean checkNorm(int bound) {
        for (int i = 0; i < this.vec.length; ++i) {
            if (!this.getVectorIndex(i).checkNorm(bound)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String out = "\n[";
        for (int i = 0; i < this.vec.length; ++i) {
            out = out + "Inner Matrix " + i + " " + this.getVectorIndex(i).toString();
            if (i == this.vec.length - 1) continue;
            out = out + ",\n";
        }
        out = out + "]";
        return out;
    }

    public String toString(String name) {
        return name + ": " + this.toString();
    }
}

