/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.pqc.crypto.hqc.GF2PolynomialCalculator;
import org.bouncycastle.pqc.crypto.hqc.ReedMuller;
import org.bouncycastle.pqc.crypto.hqc.ReedSolomon;
import org.bouncycastle.pqc.crypto.hqc.Shake256RandomGenerator;
import org.bouncycastle.pqc.crypto.hqc.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Longs;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HQCEngine {
    private final int n;
    private final int n1;
    private final int k;
    private final int delta;
    private final int w;
    private final int wr;
    private final int g;
    private final int fft;
    private final int mulParam;
    private static final int SEED_BYTES = 32;
    private final int N_BYTE;
    private final int N_BYTE_64;
    private final int K_BYTE;
    private final int N1N2_BYTE_64;
    private final int N1N2_BYTE;
    private static final int SALT_SIZE_BYTES = 16;
    private final int[] generatorPoly;
    private final int N_MU;
    private final int pkSize;
    private final GF2PolynomialCalculator gf;
    private final long rejectionThreshold;

    public HQCEngine(int n, int n1, int n2, int k, int g, int delta, int w, int wr, int fft, int nmu, int pkSize, int[] generatorPoly) {
        this.n = n;
        this.k = k;
        this.delta = delta;
        this.w = w;
        this.wr = wr;
        this.n1 = n1;
        this.generatorPoly = generatorPoly;
        this.g = g;
        this.fft = fft;
        this.N_MU = nmu;
        this.pkSize = pkSize;
        this.mulParam = n2 >> 7;
        this.N_BYTE = Utils.getByteSizeFromBitSize(n);
        this.K_BYTE = k;
        this.N_BYTE_64 = Utils.getByte64SizeFromBitSize(n);
        this.N1N2_BYTE_64 = Utils.getByte64SizeFromBitSize(n1 * n2);
        this.N1N2_BYTE = Utils.getByteSizeFromBitSize(n1 * n2);
        long RED_MASK = (1L << (n & 0x3F)) - 1L;
        this.gf = new GF2PolynomialCalculator(this.N_BYTE_64, n, RED_MASK);
        this.rejectionThreshold = 0x1000000L / (long)n * (long)n;
    }

    public void genKeyPair(byte[] pk, byte[] sk, SecureRandom secureRandom) {
        byte[] seedKem = new byte[32];
        byte[] keypairSeed = new byte[64];
        long[] xLongBytes = new long[this.N_BYTE_64];
        long[] yLongBytes = new long[this.N_BYTE_64];
        long[] h = new long[this.N_BYTE_64];
        secureRandom.nextBytes(seedKem);
        Shake256RandomGenerator ctxKem = new Shake256RandomGenerator(seedKem, 1);
        System.arraycopy(seedKem, 0, sk, this.pkSize + 32 + this.K_BYTE, 32);
        ctxKem.nextBytes(seedKem);
        ctxKem.nextBytes(sk, this.pkSize + 32, this.K_BYTE);
        HQCEngine.hashHI(keypairSeed, 512, seedKem, seedKem.length, (byte)2);
        ctxKem.init(keypairSeed, 0, 32, (byte)1);
        this.vectSampleFixedWeight1(yLongBytes, ctxKem, this.w);
        this.vectSampleFixedWeight1(xLongBytes, ctxKem, this.w);
        System.arraycopy(keypairSeed, 32, pk, 0, 32);
        ctxKem.init(keypairSeed, 32, 32, (byte)1);
        this.vectSetRandom(ctxKem, h);
        this.gf.vectMul(h, yLongBytes, h);
        Longs.xorTo(this.N_BYTE_64, xLongBytes, 0, h, 0);
        Utils.fromLongArrayToByteArray(pk, 32, pk.length - 32, h);
        System.arraycopy(keypairSeed, 0, sk, this.pkSize, 32);
        System.arraycopy(pk, 0, sk, 0, this.pkSize);
        Arrays.clear(keypairSeed);
        Arrays.clear(xLongBytes);
        Arrays.clear(yLongBytes);
        Arrays.clear(h);
    }

    public void encaps(byte[] u, byte[] v, byte[] kTheta, byte[] pk, byte[] salt, SecureRandom secureRandom) {
        byte[] m = new byte[this.K_BYTE];
        byte[] hashEkKem = new byte[32];
        long[] u64 = new long[this.N_BYTE_64];
        long[] v64 = new long[this.N1N2_BYTE_64];
        secureRandom.nextBytes(m);
        secureRandom.nextBytes(salt);
        HQCEngine.hashHI(hashEkKem, 256, pk, pk.length, (byte)1);
        this.hashGJ(kTheta, 512, hashEkKem, m, 0, m.length, salt, 0, 16, (byte)0);
        this.pkeEncrypt(u64, v64, pk, m, kTheta, 32);
        Utils.fromLongArrayToByteArray(u, u64);
        Utils.fromLongArrayToByteArray(v, v64);
        Arrays.clear(u64);
        Arrays.clear(v64);
        Arrays.clear(m);
        Arrays.clear(hashEkKem);
    }

    public int decaps(byte[] ss, byte[] ct, byte[] sk) {
        long[] u64 = new long[this.N_BYTE_64];
        long[] v64 = new long[this.N_BYTE_64];
        long[] cKemPrimeU64 = new long[this.N_BYTE_64];
        long[] cKemPrimeV64 = new long[this.N_BYTE_64];
        byte[] hashEkKem = new byte[32];
        byte[] kThetaPrime = new byte[64];
        byte[] mPrime = new byte[this.k];
        byte[] kBar = new byte[32];
        byte[] tmp = new byte[this.n1];
        Shake256RandomGenerator generator = new Shake256RandomGenerator(sk, this.pkSize, 32, 1);
        this.vectSampleFixedWeight1(cKemPrimeV64, generator, this.w);
        Utils.fromByteArrayToLongArray(u64, ct, 0, this.N_BYTE);
        Utils.fromByteArrayToLongArray(v64, ct, this.N_BYTE, this.N1N2_BYTE);
        this.gf.vectMul(cKemPrimeU64, cKemPrimeV64, u64);
        this.vectTruncate(cKemPrimeU64);
        Longs.xorTo(this.N_BYTE_64, v64, 0, cKemPrimeU64, 0);
        ReedMuller.decode(tmp, cKemPrimeU64, this.n1, this.mulParam);
        ReedSolomon.decode(mPrime, tmp, this.n1, this.fft, this.delta, this.k, this.g);
        int result = 0;
        HQCEngine.hashHI(hashEkKem, 256, sk, this.pkSize, (byte)1);
        this.hashGJ(kThetaPrime, 512, hashEkKem, mPrime, 0, mPrime.length, ct, this.N_BYTE + this.N1N2_BYTE, 16, (byte)0);
        System.arraycopy(kThetaPrime, 0, ss, 0, 32);
        Arrays.fill(cKemPrimeV64, 0L);
        this.pkeEncrypt(cKemPrimeU64, cKemPrimeV64, sk, mPrime, kThetaPrime, 32);
        this.hashGJ(kBar, 256, hashEkKem, sk, this.pkSize + 32, this.K_BYTE, ct, 0, ct.length, (byte)3);
        if (!Arrays.constantTimeAreEqual(u64, cKemPrimeU64)) {
            result = 1;
        }
        if (!Arrays.constantTimeAreEqual(v64, cKemPrimeV64)) {
            result = 1;
        }
        --result;
        for (int i = 0; i < this.K_BYTE; ++i) {
            ss[i] = (byte)((ss[i] & result ^ kBar[i] & ~result) & 0xFF);
        }
        Arrays.clear(u64);
        Arrays.clear(v64);
        Arrays.clear(cKemPrimeU64);
        Arrays.clear(cKemPrimeV64);
        Arrays.clear(hashEkKem);
        Arrays.clear(kThetaPrime);
        Arrays.clear(mPrime);
        Arrays.clear(kBar);
        Arrays.clear(tmp);
        return -result;
    }

    private void pkeEncrypt(long[] u, long[] v, byte[] ekPke, byte[] m, byte[] theta, int thetaOff) {
        long[] e = new long[this.N_BYTE_64];
        long[] tmp = new long[this.N_BYTE_64];
        byte[] res = new byte[this.n1];
        ReedSolomon.encode(res, m, this.n1, this.k, this.g, this.generatorPoly);
        ReedMuller.encode(v, res, this.n1, this.mulParam);
        Shake256RandomGenerator randomGenerator = new Shake256RandomGenerator(ekPke, 0, 32, 1);
        this.vectSetRandom(randomGenerator, tmp);
        randomGenerator.init(theta, thetaOff, 32, (byte)1);
        this.vectSampleFixedWeights2(randomGenerator, e, this.wr);
        this.gf.vectMul(u, e, tmp);
        Utils.fromByteArrayToLongArray(tmp, ekPke, 32, this.pkSize - 32);
        this.gf.vectMul(tmp, e, tmp);
        this.vectSampleFixedWeights2(randomGenerator, e, this.wr);
        Longs.xorTo(this.N_BYTE_64, e, 0, tmp, 0);
        this.vectTruncate(tmp);
        Longs.xorTo(this.N1N2_BYTE_64, tmp, 0, v, 0);
        this.vectSampleFixedWeights2(randomGenerator, tmp, this.wr);
        Longs.xorTo(this.N_BYTE_64, tmp, 0, u, 0);
        Arrays.clear(e);
        Arrays.clear(tmp);
        Arrays.clear(res);
    }

    private int barrettReduce(int x) {
        long q = (long)x * (long)this.N_MU >>> 32;
        int r = x - (int)(q * (long)this.n);
        r -= -(r - this.n >>> 31 ^ 1) & this.n;
        return r;
    }

    private void generateRandomSupport(int[] support, int weight, Shake256RandomGenerator random) {
        int randomBytesSize = 3 * weight;
        byte[] randBytes = new byte[randomBytesSize];
        int j = randomBytesSize;
        int count = 0;
        while (count < weight) {
            int candidate;
            if (j == randomBytesSize) {
                random.xofGetBytes(randBytes, randomBytesSize);
                j = 0;
            }
            if ((long)(candidate = (randBytes[j++] & 0xFF) << 16 | (randBytes[j++] & 0xFF) << 8 | randBytes[j++] & 0xFF) >= this.rejectionThreshold) continue;
            candidate = this.barrettReduce(candidate);
            boolean duplicate = false;
            for (int k = 0; k < count; ++k) {
                if (support[k] != candidate) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            support[count++] = candidate;
        }
    }

    private void writeSupportToVector(long[] v, int[] support, int weight) {
        int i;
        int[] indexTab = new int[this.wr];
        long[] bitTab = new long[this.wr];
        for (i = 0; i < weight; ++i) {
            indexTab[i] = support[i] >>> 6;
            bitTab[i] = 1L << (support[i] & 0x3F);
        }
        for (i = 0; i < v.length; ++i) {
            long val = 0L;
            for (int j = 0; j < weight; ++j) {
                int tmp = i - indexTab[j];
                val |= bitTab[j] & (long)(-(1 ^ (tmp | -tmp) >>> 31));
            }
            v[i] = val;
        }
    }

    public void vectSampleFixedWeight1(long[] output, Shake256RandomGenerator random, int weight) {
        int[] support = new int[this.wr];
        this.generateRandomSupport(support, weight, random);
        this.writeSupportToVector(output, support, weight);
    }

    private static void hashHI(byte[] output, int bitLength, byte[] in, int inLen, byte domain) {
        SHA3Digest digest = new SHA3Digest(bitLength);
        digest.update(in, 0, inLen);
        digest.update(domain);
        digest.doFinal(output, 0);
    }

    private void hashGJ(byte[] output, int bitLength, byte[] hashEkKem, byte[] mOrSigma, int mOrSigmaOff, int mOrSigmaLen, byte[] saltOrCt, int saltOrCtOff, int saltOrCtOffLen, byte domain) {
        SHA3Digest digest = new SHA3Digest(bitLength);
        digest.update(hashEkKem, 0, hashEkKem.length);
        digest.update(mOrSigma, mOrSigmaOff, mOrSigmaLen);
        digest.update(saltOrCt, saltOrCtOff, saltOrCtOffLen);
        digest.update(domain);
        digest.doFinal(output, 0);
    }

    private void vectSetRandom(Shake256RandomGenerator generator, long[] v) {
        byte[] tmp = new byte[v.length << 3];
        generator.xofGetBytes(tmp, this.N_BYTE);
        Pack.littleEndianToLong(tmp, 0, v);
        int n = this.N_BYTE_64 - 1;
        v[n] = v[n] & Utils.bitMask(this.n, 64L);
    }

    private void vectSampleFixedWeights2(Shake256RandomGenerator generator, long[] v, int weight) {
        int i;
        int[] support = new int[this.wr];
        byte[] rand = new byte[this.wr << 2];
        generator.xofGetBytes(rand, rand.length);
        Pack.littleEndianToInt(rand, 0, support);
        for (i = 0; i < weight; ++i) {
            support[i] = i + (int)(((long)support[i] & 0xFFFFFFFFL) * (long)(this.n - i) >> 32);
        }
        i = weight - 1;
        while (i-- > 0) {
            int found = 0;
            for (int j = i + 1; j < weight; ++j) {
                found |= HQCEngine.compareU32(support[j], support[i]);
            }
            found = -found;
            support[i] = found & i ^ ~found & support[i];
        }
        this.writeSupportToVector(v, support, weight);
    }

    private static int compareU32(int v1, int v2) {
        return 1 ^ (v1 - v2 | v2 - v1) >>> 31;
    }

    private void vectTruncate(long[] v) {
        Arrays.fill(v, this.N1N2_BYTE_64, this.n + 63 >> 6, 0L);
    }
}

