/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.util.Arrays;
import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Bytes;

public class ElephantEngine
extends AEADBaseEngine {
    private byte[] npub;
    private byte[] expanded_key;
    private int nb_its;
    private byte[] ad;
    private int adOff;
    private int adlen;
    private final byte[] tag_buffer;
    private byte[] previous_mask;
    private byte[] current_mask;
    private byte[] next_mask;
    private final byte[] buffer;
    private final byte[] previous_outputMessage;
    private final Permutation instance;

    public ElephantEngine(ElephantParameters parameters) {
        this.KEY_SIZE = 16;
        this.IV_SIZE = 12;
        switch (parameters.ordinal()) {
            case 0: {
                this.BlockSize = 20;
                this.instance = new Dumbo();
                this.MAC_SIZE = 8;
                this.algorithmName = "Elephant 160 AEAD";
                break;
            }
            case 1: {
                this.BlockSize = 22;
                this.instance = new Jumbo();
                this.algorithmName = "Elephant 176 AEAD";
                this.MAC_SIZE = 8;
                break;
            }
            case 2: {
                this.BlockSize = 25;
                this.instance = new Delirium();
                this.algorithmName = "Elephant 200 AEAD";
                this.MAC_SIZE = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Elephant");
            }
        }
        this.tag_buffer = new byte[this.BlockSize];
        this.previous_mask = new byte[this.BlockSize];
        this.current_mask = new byte[this.BlockSize];
        this.next_mask = new byte[this.BlockSize];
        this.buffer = new byte[this.BlockSize];
        this.previous_outputMessage = new byte[this.BlockSize];
        this.setInnerMembers(AEADBaseEngine.ProcessingBufferType.Immediate, AEADBaseEngine.AADOperatorType.Stream, AEADBaseEngine.DataOperatorType.Counter);
    }

    private byte rotl(byte b) {
        return (byte)(b << 1 | (b & 0xFF) >>> 7);
    }

    private void lfsr_step() {
        this.instance.lfsr_step();
        System.arraycopy(this.current_mask, 1, this.next_mask, 0, this.BlockSize - 1);
    }

    @Override
    protected void init(byte[] k, byte[] iv) throws IllegalArgumentException {
        this.npub = iv;
        this.expanded_key = new byte[this.BlockSize];
        System.arraycopy(k, 0, this.expanded_key, 0, this.KEY_SIZE);
        this.instance.permutation(this.expanded_key);
    }

    @Override
    protected void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.processBuffer(input, inOff, output, outOff, AEADBaseEngine.State.EncData);
        System.arraycopy(output, outOff, this.previous_outputMessage, 0, this.BlockSize);
    }

    private void processBuffer(byte[] input, int inOff, byte[] output, int outOff, AEADBaseEngine.State encData) {
        if (this.m_state == AEADBaseEngine.State.DecInit || this.m_state == AEADBaseEngine.State.EncInit) {
            this.processFinalAAD();
        }
        this.lfsr_step();
        this.computeCipherBlock(input, inOff, this.BlockSize, output, outOff);
        if (this.nb_its > 0) {
            System.arraycopy(this.previous_outputMessage, 0, this.buffer, 0, this.BlockSize);
            this.absorbCiphertext();
        }
        if (this.m_state != encData) {
            this.absorbAAD();
        }
        this.swapMasks();
        ++this.nb_its;
    }

    @Override
    protected void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.processBuffer(input, inOff, output, outOff, AEADBaseEngine.State.DecData);
        System.arraycopy(input, inOff, this.previous_outputMessage, 0, this.BlockSize);
    }

    private void computeCipherBlock(byte[] input, int inOff, int blockSize, byte[] output, int outOff) {
        System.arraycopy(this.npub, 0, this.buffer, 0, this.IV_SIZE);
        Arrays.fill(this.buffer, this.IV_SIZE, this.BlockSize, (byte)0);
        ElephantEngine.xorTo(this.BlockSize, this.current_mask, this.next_mask, this.buffer);
        this.instance.permutation(this.buffer);
        ElephantEngine.xorTo(this.BlockSize, this.current_mask, this.next_mask, this.buffer);
        Bytes.xorTo(blockSize, input, inOff, this.buffer);
        System.arraycopy(this.buffer, 0, output, outOff, blockSize);
    }

    private void swapMasks() {
        byte[] temp = this.previous_mask;
        this.previous_mask = this.current_mask;
        this.current_mask = this.next_mask;
        this.next_mask = temp;
    }

    private void absorbAAD() {
        this.processAADBytes(this.buffer);
        Bytes.xorTo(this.BlockSize, this.next_mask, this.buffer);
        this.instance.permutation(this.buffer);
        Bytes.xorTo(this.BlockSize, this.next_mask, this.buffer);
        Bytes.xorTo(this.BlockSize, this.buffer, this.tag_buffer);
    }

    private void absorbCiphertext() {
        ElephantEngine.xorTo(this.BlockSize, this.previous_mask, this.next_mask, this.buffer);
        this.instance.permutation(this.buffer);
        ElephantEngine.xorTo(this.BlockSize, this.previous_mask, this.next_mask, this.buffer);
        Bytes.xorTo(this.BlockSize, this.buffer, this.tag_buffer);
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        int mlen = this.dataOperator.getLen() - (this.forEncryption ? 0 : this.MAC_SIZE);
        this.processFinalAAD();
        int nblocks_c = 1 + mlen / this.BlockSize;
        int nblocks_m = mlen % this.BlockSize != 0 ? nblocks_c : nblocks_c - 1;
        int nblocks_ad = 1 + (this.IV_SIZE + this.adlen) / this.BlockSize;
        int nb_it = Math.max(nblocks_c + 1, nblocks_ad - 1);
        this.processBytes(this.m_buf, output, outOff, nb_it, nblocks_m, nblocks_c, mlen, nblocks_ad);
        Bytes.xorTo(this.BlockSize, this.expanded_key, this.tag_buffer);
        this.instance.permutation(this.tag_buffer);
        Bytes.xorTo(this.BlockSize, this.expanded_key, this.tag_buffer);
        System.arraycopy(this.tag_buffer, 0, this.mac, 0, this.MAC_SIZE);
    }

    @Override
    protected void processBufferAAD(byte[] input, int inOff) {
    }

    @Override
    public int getUpdateOutputSize(int len) {
        switch (this.m_state.ord) {
            case 0: {
                throw new IllegalArgumentException(this.algorithmName + " needs call init function before getUpdateOutputSize");
            }
            case 4: 
            case 8: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: {
                int total = this.m_bufPos + len;
                return total - total % this.BlockSize;
            }
            case 5: 
            case 6: 
            case 7: {
                int total = Math.max(0, this.m_bufPos + len - this.MAC_SIZE);
                return total - total % this.BlockSize;
            }
        }
        return Math.max(0, len + this.m_bufPos - this.MAC_SIZE);
    }

    @Override
    public int getOutputSize(int len) {
        switch (this.m_state.ord) {
            case 0: {
                throw new IllegalArgumentException(this.algorithmName + " needs call init function before getUpdateOutputSize");
            }
            case 4: 
            case 8: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: {
                return len + this.m_bufPos + this.MAC_SIZE;
            }
        }
        return Math.max(0, len + this.m_bufPos - this.MAC_SIZE);
    }

    @Override
    protected void finishAAD(AEADBaseEngine.State nextState, boolean isDoFinal) {
        this.finishAAD2(nextState);
    }

    @Override
    protected void processFinalAAD() {
        if (this.adOff == -1) {
            this.ad = ((AEADBaseEngine.StreamAADOperator)this.aadOperator).getBytes();
            this.adOff = 0;
            this.adlen = this.aadOperator.getLen();
            this.aadOperator.reset();
        }
        switch (this.m_state.ord) {
            case 1: 
            case 5: {
                this.processAADBytes(this.tag_buffer);
            }
        }
    }

    @Override
    protected void reset(boolean clearMac) {
        super.reset(clearMac);
        Arrays.fill(this.tag_buffer, (byte)0);
        Arrays.fill(this.previous_outputMessage, (byte)0);
        this.nb_its = 0;
        this.adOff = -1;
    }

    @Override
    protected void checkAAD() {
        switch (this.m_state.ord) {
            case 7: {
                throw new IllegalArgumentException(this.algorithmName + " cannot process AAD when the length of the plaintext to be processed exceeds the a block size");
            }
            case 3: {
                throw new IllegalArgumentException(this.algorithmName + " cannot process AAD when the length of the ciphertext to be processed exceeds the a block size");
            }
            case 4: {
                throw new IllegalArgumentException(this.algorithmName + " cannot be reused for encryption");
            }
        }
    }

    @Override
    protected boolean checkData(boolean isDofinal) {
        switch (this.m_state.ord) {
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void processAADBytes(byte[] output) {
        int len = 0;
        switch (this.m_state.ord) {
            case 5: {
                System.arraycopy(this.expanded_key, 0, this.current_mask, 0, this.BlockSize);
                System.arraycopy(this.npub, 0, output, 0, this.IV_SIZE);
                len += this.IV_SIZE;
                this.m_state = AEADBaseEngine.State.DecAad;
                break;
            }
            case 1: {
                System.arraycopy(this.expanded_key, 0, this.current_mask, 0, this.BlockSize);
                System.arraycopy(this.npub, 0, output, 0, this.IV_SIZE);
                len += this.IV_SIZE;
                this.m_state = AEADBaseEngine.State.EncAad;
                break;
            }
            case 2: 
            case 6: {
                if (this.adOff != this.adlen) break;
                Arrays.fill(output, 0, this.BlockSize, (byte)0);
                output[0] = 1;
                return;
            }
        }
        int r_outlen = this.BlockSize - len;
        int r_adlen = this.adlen - this.adOff;
        if (r_outlen <= r_adlen) {
            System.arraycopy(this.ad, this.adOff, output, len, r_outlen);
            this.adOff += r_outlen;
        } else {
            if (r_adlen > 0) {
                System.arraycopy(this.ad, this.adOff, output, len, r_adlen);
                this.adOff += r_adlen;
            }
            Arrays.fill(output, len + r_adlen, len + r_outlen, (byte)0);
            output[len + r_adlen] = 1;
            switch (this.m_state.ord) {
                case 6: {
                    this.m_state = AEADBaseEngine.State.DecData;
                    break;
                }
                case 2: {
                    this.m_state = AEADBaseEngine.State.EncData;
                }
            }
        }
    }

    private void processBytes(byte[] m, byte[] output, int outOff, int nb_it, int nblocks_m, int nblocks_c, int mlen, int nblocks_ad) {
        int i;
        int rv = 0;
        byte[] outputMessage = new byte[this.BlockSize];
        for (i = this.nb_its; i < nb_it; ++i) {
            int r_size = i == nblocks_m - 1 ? mlen - i * this.BlockSize : this.BlockSize;
            this.lfsr_step();
            if (i < nblocks_m) {
                this.computeCipherBlock(m, rv, r_size, output, outOff);
                if (this.forEncryption) {
                    System.arraycopy(this.buffer, 0, outputMessage, 0, r_size);
                } else {
                    System.arraycopy(m, rv, outputMessage, 0, r_size);
                }
                outOff += r_size;
                rv += r_size;
            }
            if (i > 0 && i <= nblocks_c) {
                int block_offset = (i - 1) * this.BlockSize;
                if (block_offset == mlen) {
                    Arrays.fill(this.buffer, 1, this.BlockSize, (byte)0);
                    this.buffer[0] = 1;
                } else {
                    int r_clen = mlen - block_offset;
                    if (this.BlockSize <= r_clen) {
                        System.arraycopy(this.previous_outputMessage, 0, this.buffer, 0, this.BlockSize);
                    } else if (r_clen > 0) {
                        System.arraycopy(this.previous_outputMessage, 0, this.buffer, 0, r_clen);
                        Arrays.fill(this.buffer, r_clen, this.BlockSize, (byte)0);
                        this.buffer[r_clen] = 1;
                    }
                }
                this.absorbCiphertext();
            }
            if (i + 1 < nblocks_ad) {
                this.absorbAAD();
            }
            this.swapMasks();
            System.arraycopy(outputMessage, 0, this.previous_outputMessage, 0, this.BlockSize);
        }
        this.nb_its = i;
    }

    public static void xorTo(int len, byte[] x, byte[] y, byte[] z) {
        for (int i = 0; i < len; ++i) {
            int n = i;
            z[n] = (byte)(z[n] ^ (x[i] ^ y[i]));
        }
    }

    private class Delirium
    implements Permutation {
        private static final int nRounds = 18;
        private final byte[] KeccakRoundConstants = new byte[]{1, -126, -118, 0, -117, 1, -127, 9, -118, -120, 9, 10, -117, -117, -119, 3, 2, -128};
        private final int[] KeccakRhoOffsets = new int[]{0, 1, 6, 4, 3, 4, 4, 6, 7, 4, 3, 2, 3, 1, 7, 1, 5, 7, 5, 0, 2, 2, 5, 0, 6};

        private Delirium() {
        }

        @Override
        public void permutation(byte[] state) {
            for (int i = 0; i < 18; ++i) {
                this.KeccakP200Round(state, i);
            }
        }

        @Override
        public void lfsr_step() {
            ((ElephantEngine)ElephantEngine.this).next_mask[ElephantEngine.this.BlockSize - 1] = (byte)(ElephantEngine.this.rotl(ElephantEngine.this.current_mask[0]) ^ ElephantEngine.this.rotl(ElephantEngine.this.current_mask[2]) ^ ElephantEngine.this.current_mask[13] << 1);
        }

        private void KeccakP200Round(byte[] state, int indexRound) {
            int y;
            int x;
            byte[] tempA = new byte[25];
            for (x = 0; x < 5; ++x) {
                for (y = 0; y < 5; ++y) {
                    int n = x;
                    tempA[n] = (byte)(tempA[n] ^ state[this.index(x, y)]);
                }
            }
            for (x = 0; x < 5; ++x) {
                tempA[x + 5] = (byte)(this.ROL8(tempA[(x + 1) % 5], 1) ^ tempA[(x + 4) % 5]);
            }
            for (x = 0; x < 5; ++x) {
                for (y = 0; y < 5; ++y) {
                    int n = this.index(x, y);
                    state[n] = (byte)(state[n] ^ tempA[x + 5]);
                }
            }
            for (x = 0; x < 5; ++x) {
                for (y = 0; y < 5; ++y) {
                    tempA[this.index((int)x, (int)y)] = this.ROL8(state[this.index(x, y)], this.KeccakRhoOffsets[this.index(x, y)]);
                }
            }
            for (x = 0; x < 5; ++x) {
                for (y = 0; y < 5; ++y) {
                    state[this.index((int)y, (int)((2 * x + 3 * y) % 5))] = tempA[this.index(x, y)];
                }
            }
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 5; ++x) {
                    tempA[x] = (byte)(state[this.index(x, y)] ^ ~state[this.index((x + 1) % 5, y)] & state[this.index((x + 2) % 5, y)]);
                }
                for (x = 0; x < 5; ++x) {
                    state[this.index((int)x, (int)y)] = tempA[x];
                }
            }
            state[0] = (byte)(state[0] ^ this.KeccakRoundConstants[indexRound]);
        }

        private byte ROL8(byte a, int offset) {
            return (byte)(a << offset | (a & 0xFF) >>> 8 - offset);
        }

        private int index(int x, int y) {
            return x + y * 5;
        }
    }

    private class Dumbo
    extends Spongent {
        public Dumbo() {
            super(160, 20, 80, (byte)117);
        }

        @Override
        public void lfsr_step() {
            ((ElephantEngine)ElephantEngine.this).next_mask[ElephantEngine.this.BlockSize - 1] = (byte)(((ElephantEngine.this.current_mask[0] & 0xFF) << 3 | (ElephantEngine.this.current_mask[0] & 0xFF) >>> 5) ^ (ElephantEngine.this.current_mask[3] & 0xFF) << 7 ^ (ElephantEngine.this.current_mask[13] & 0xFF) >>> 7);
        }
    }

    public static enum ElephantParameters {
        elephant160,
        elephant176,
        elephant200;

    }

    private class Jumbo
    extends Spongent {
        public Jumbo() {
            super(176, 22, 90, (byte)69);
        }

        @Override
        public void lfsr_step() {
            ((ElephantEngine)ElephantEngine.this).next_mask[ElephantEngine.this.BlockSize - 1] = (byte)(ElephantEngine.this.rotl(ElephantEngine.this.current_mask[0]) ^ (ElephantEngine.this.current_mask[3] & 0xFF) << 7 ^ (ElephantEngine.this.current_mask[19] & 0xFF) >>> 7);
        }
    }

    private static interface Permutation {
        public void permutation(byte[] var1);

        public void lfsr_step();
    }

    private static abstract class Spongent
    implements Permutation {
        private final byte lfsrIV;
        private final int nRounds;
        private final int nBits;
        private final int nSBox;
        private final byte[] sBoxLayer = new byte[]{-18, -19, -21, -32, -30, -31, -28, -17, -25, -22, -24, -27, -23, -20, -29, -26, -34, -35, -37, -48, -46, -47, -44, -33, -41, -38, -40, -43, -39, -36, -45, -42, -66, -67, -69, -80, -78, -79, -76, -65, -73, -70, -72, -75, -71, -68, -77, -74, 14, 13, 11, 0, 2, 1, 4, 15, 7, 10, 8, 5, 9, 12, 3, 6, 46, 45, 43, 32, 34, 33, 36, 47, 39, 42, 40, 37, 41, 44, 35, 38, 30, 29, 27, 16, 18, 17, 20, 31, 23, 26, 24, 21, 25, 28, 19, 22, 78, 77, 75, 64, 66, 65, 68, 79, 71, 74, 72, 69, 73, 76, 67, 70, -2, -3, -5, -16, -14, -15, -12, -1, -9, -6, -8, -11, -7, -4, -13, -10, 126, 125, 123, 112, 114, 113, 116, 127, 119, 122, 120, 117, 121, 124, 115, 118, -82, -83, -85, -96, -94, -95, -92, -81, -89, -86, -88, -91, -87, -84, -93, -90, -114, -115, -117, -128, -126, -127, -124, -113, -121, -118, -120, -123, -119, -116, -125, -122, 94, 93, 91, 80, 82, 81, 84, 95, 87, 90, 88, 85, 89, 92, 83, 86, -98, -99, -101, -112, -110, -111, -108, -97, -105, -102, -104, -107, -103, -100, -109, -106, -50, -51, -53, -64, -62, -63, -60, -49, -57, -54, -56, -59, -55, -52, -61, -58, 62, 61, 59, 48, 50, 49, 52, 63, 55, 58, 56, 53, 57, 60, 51, 54, 110, 109, 107, 96, 98, 97, 100, 111, 103, 106, 104, 101, 105, 108, 99, 102};

        public Spongent(int nBits, int nSBox, int nRounds, byte lfsrIV) {
            this.nRounds = nRounds;
            this.nSBox = nSBox;
            this.lfsrIV = lfsrIV;
            this.nBits = nBits;
        }

        @Override
        public void permutation(byte[] state) {
            byte IV = this.lfsrIV;
            byte[] tmp = new byte[this.nSBox];
            for (int i = 0; i < this.nRounds; ++i) {
                state[0] = (byte)(state[0] ^ IV);
                int n = this.nSBox - 1;
                state[n] = (byte)(state[n] ^ (byte)((IV & 1) << 7 | (IV & 2) << 5 | (IV & 4) << 3 | (IV & 8) << 1 | (IV & 0x10) >>> 1 | (IV & 0x20) >>> 3 | (IV & 0x40) >>> 5 | (IV & 0x80) >>> 7));
                IV = (byte)((IV << 1 | (0x40 & IV) >>> 6 ^ (0x20 & IV) >>> 5) & 0x7F);
                for (int j = 0; j < this.nSBox; ++j) {
                    state[j] = this.sBoxLayer[state[j] & 0xFF];
                }
                Arrays.fill(tmp, (byte)0);
                for (int j = 0; j < this.nSBox; ++j) {
                    for (int k = 0; k < 8; ++k) {
                        int PermutedBitNo = (j << 3) + k;
                        if (PermutedBitNo != this.nBits - 1) {
                            PermutedBitNo = (PermutedBitNo * this.nBits >> 2) % (this.nBits - 1);
                        }
                        int n2 = PermutedBitNo >>> 3;
                        tmp[n2] = (byte)(tmp[n2] ^ ((state[j] & 0xFF) >>> k & 1) << (PermutedBitNo & 7));
                    }
                }
                System.arraycopy(tmp, 0, state, 0, this.nSBox);
            }
        }
    }
}

