/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.agreement.ecjpake;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.ecjpake.ECJPAKECurve;
import org.bouncycastle.crypto.agreement.ecjpake.ECJPAKECurves;
import org.bouncycastle.crypto.agreement.ecjpake.ECJPAKERound1Payload;
import org.bouncycastle.crypto.agreement.ecjpake.ECJPAKERound2Payload;
import org.bouncycastle.crypto.agreement.ecjpake.ECJPAKERound3Payload;
import org.bouncycastle.crypto.agreement.ecjpake.ECJPAKEUtil;
import org.bouncycastle.crypto.agreement.ecjpake.ECSchnorrZKP;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;

public class ECJPAKEParticipant {
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_ROUND_1_CREATED = 10;
    public static final int STATE_ROUND_1_VALIDATED = 20;
    public static final int STATE_ROUND_2_CREATED = 30;
    public static final int STATE_ROUND_2_VALIDATED = 40;
    public static final int STATE_KEY_CALCULATED = 50;
    public static final int STATE_ROUND_3_CREATED = 60;
    public static final int STATE_ROUND_3_VALIDATED = 70;
    private final String participantId;
    private char[] password;
    private final Digest digest;
    private final SecureRandom random;
    private String partnerParticipantId;
    private ECCurve.AbstractFp ecCurve;
    private BigInteger q;
    private BigInteger h;
    private BigInteger n;
    private ECPoint g;
    private BigInteger x1;
    private BigInteger x2;
    private ECPoint gx1;
    private ECPoint gx2;
    private ECPoint gx3;
    private ECPoint gx4;
    private ECPoint b;
    private int state;

    public ECJPAKEParticipant(String participantId, char[] password) {
        this(participantId, password, ECJPAKECurves.NIST_P256);
    }

    public ECJPAKEParticipant(String participantId, char[] password, ECJPAKECurve curve) {
        this(participantId, password, curve, SHA256Digest.newInstance(), CryptoServicesRegistrar.getSecureRandom());
    }

    public ECJPAKEParticipant(String participantId, char[] password, ECJPAKECurve curve, Digest digest, SecureRandom random) {
        ECJPAKEUtil.validateNotNull(participantId, "participantId");
        ECJPAKEUtil.validateNotNull(password, "password");
        ECJPAKEUtil.validateNotNull(curve, "curve params");
        ECJPAKEUtil.validateNotNull(digest, "digest");
        ECJPAKEUtil.validateNotNull(random, "random");
        if (password.length == 0) {
            throw new IllegalArgumentException("Password must not be empty.");
        }
        this.participantId = participantId;
        this.password = Arrays.copyOf(password, password.length);
        this.ecCurve = curve.getCurve();
        this.g = curve.getG();
        this.h = curve.getH();
        this.n = curve.getN();
        this.q = curve.getQ();
        this.digest = digest;
        this.random = random;
        this.state = 0;
    }

    public int getState() {
        return this.state;
    }

    public ECJPAKERound1Payload createRound1PayloadToSend() {
        if (this.state >= 10) {
            throw new IllegalStateException("Round1 payload already created for " + this.participantId);
        }
        this.x1 = ECJPAKEUtil.generateX1(this.n, this.random);
        this.x2 = ECJPAKEUtil.generateX1(this.n, this.random);
        this.gx1 = ECJPAKEUtil.calculateGx(this.g, this.x1);
        this.gx2 = ECJPAKEUtil.calculateGx(this.g, this.x2);
        ECSchnorrZKP knowledgeProofForX1 = ECJPAKEUtil.calculateZeroKnowledgeProof(this.g, this.n, this.x1, this.gx1, this.digest, this.participantId, this.random);
        ECSchnorrZKP knowledgeProofForX2 = ECJPAKEUtil.calculateZeroKnowledgeProof(this.g, this.n, this.x2, this.gx2, this.digest, this.participantId, this.random);
        this.state = 10;
        return new ECJPAKERound1Payload(this.participantId, this.gx1, this.gx2, knowledgeProofForX1, knowledgeProofForX2);
    }

    public void validateRound1PayloadReceived(ECJPAKERound1Payload round1PayloadReceived) throws CryptoException {
        if (this.state >= 20) {
            throw new IllegalStateException("Validation already attempted for round1 payload for" + this.participantId);
        }
        this.partnerParticipantId = round1PayloadReceived.getParticipantId();
        this.gx3 = round1PayloadReceived.getGx1();
        this.gx4 = round1PayloadReceived.getGx2();
        ECSchnorrZKP knowledgeProofForX3 = round1PayloadReceived.getKnowledgeProofForX1();
        ECSchnorrZKP knowledgeProofForX4 = round1PayloadReceived.getKnowledgeProofForX2();
        ECJPAKEUtil.validateParticipantIdsDiffer(this.participantId, round1PayloadReceived.getParticipantId());
        ECJPAKEUtil.validateZeroKnowledgeProof(this.g, this.gx3, knowledgeProofForX3, this.q, this.n, this.ecCurve, this.h, round1PayloadReceived.getParticipantId(), this.digest);
        ECJPAKEUtil.validateZeroKnowledgeProof(this.g, this.gx4, knowledgeProofForX4, this.q, this.n, this.ecCurve, this.h, round1PayloadReceived.getParticipantId(), this.digest);
        this.state = 20;
    }

    public ECJPAKERound2Payload createRound2PayloadToSend() {
        if (this.state >= 30) {
            throw new IllegalStateException("Round2 payload already created for " + this.participantId);
        }
        if (this.state < 20) {
            throw new IllegalStateException("Round1 payload must be validated prior to creating Round2 payload for " + this.participantId);
        }
        ECPoint gA = ECJPAKEUtil.calculateGA(this.gx1, this.gx3, this.gx4);
        BigInteger s = this.calculateS();
        BigInteger x2s = ECJPAKEUtil.calculateX2s(this.n, this.x2, s);
        ECPoint A = ECJPAKEUtil.calculateA(gA, x2s);
        ECSchnorrZKP knowledgeProofForX2s = ECJPAKEUtil.calculateZeroKnowledgeProof(gA, this.n, x2s, A, this.digest, this.participantId, this.random);
        this.state = 30;
        return new ECJPAKERound2Payload(this.participantId, A, knowledgeProofForX2s);
    }

    public void validateRound2PayloadReceived(ECJPAKERound2Payload round2PayloadReceived) throws CryptoException {
        if (this.state >= 40) {
            throw new IllegalStateException("Validation already attempted for round2 payload for" + this.participantId);
        }
        if (this.state < 20) {
            throw new IllegalStateException("Round1 payload must be validated prior to validating Round2 payload for " + this.participantId);
        }
        ECPoint gB = ECJPAKEUtil.calculateGA(this.gx3, this.gx1, this.gx2);
        this.b = round2PayloadReceived.getA();
        ECSchnorrZKP knowledgeProofForX4s = round2PayloadReceived.getKnowledgeProofForX2s();
        ECJPAKEUtil.validateParticipantIdsDiffer(this.participantId, round2PayloadReceived.getParticipantId());
        ECJPAKEUtil.validateParticipantIdsEqual(this.partnerParticipantId, round2PayloadReceived.getParticipantId());
        ECJPAKEUtil.validateZeroKnowledgeProof(gB, this.b, knowledgeProofForX4s, this.q, this.n, this.ecCurve, this.h, round2PayloadReceived.getParticipantId(), this.digest);
        this.state = 40;
    }

    public BigInteger calculateKeyingMaterial() {
        if (this.state >= 50) {
            throw new IllegalStateException("Key already calculated for " + this.participantId);
        }
        if (this.state < 40) {
            throw new IllegalStateException("Round2 payload must be validated prior to creating key for " + this.participantId);
        }
        BigInteger s = this.calculateS();
        Arrays.fill(this.password, '\u0000');
        this.password = null;
        BigInteger keyingMaterial = ECJPAKEUtil.calculateKeyingMaterial(this.n, this.gx4, this.x2, s, this.b);
        this.x1 = null;
        this.x2 = null;
        this.b = null;
        this.state = 50;
        return keyingMaterial;
    }

    public ECJPAKERound3Payload createRound3PayloadToSend(BigInteger keyingMaterial) {
        if (this.state >= 60) {
            throw new IllegalStateException("Round3 payload already created for " + this.participantId);
        }
        if (this.state < 50) {
            throw new IllegalStateException("Keying material must be calculated prior to creating Round3 payload for " + this.participantId);
        }
        BigInteger macTag = ECJPAKEUtil.calculateMacTag(this.participantId, this.partnerParticipantId, this.gx1, this.gx2, this.gx3, this.gx4, keyingMaterial, this.digest);
        this.state = 60;
        return new ECJPAKERound3Payload(this.participantId, macTag);
    }

    public void validateRound3PayloadReceived(ECJPAKERound3Payload round3PayloadReceived, BigInteger keyingMaterial) throws CryptoException {
        if (this.state >= 70) {
            throw new IllegalStateException("Validation already attempted for round3 payload for" + this.participantId);
        }
        if (this.state < 50) {
            throw new IllegalStateException("Keying material must be calculated validated prior to validating Round3 payload for " + this.participantId);
        }
        ECJPAKEUtil.validateParticipantIdsDiffer(this.participantId, round3PayloadReceived.getParticipantId());
        ECJPAKEUtil.validateParticipantIdsEqual(this.partnerParticipantId, round3PayloadReceived.getParticipantId());
        ECJPAKEUtil.validateMacTag(this.participantId, this.partnerParticipantId, this.gx1, this.gx2, this.gx3, this.gx4, keyingMaterial, this.digest, round3PayloadReceived.getMacTag());
        this.gx1 = null;
        this.gx2 = null;
        this.gx3 = null;
        this.gx4 = null;
        this.state = 70;
    }

    private BigInteger calculateS() {
        try {
            return ECJPAKEUtil.calculateS(this.n, this.password);
        }
        catch (CryptoException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
    }
}

