/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.snova;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CTRModeCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.pqc.crypto.snova.GF16Utils;
import org.bouncycastle.pqc.crypto.snova.MapGroup1;
import org.bouncycastle.pqc.crypto.snova.MapGroup2;
import org.bouncycastle.pqc.crypto.snova.SnovaKeyElements;
import org.bouncycastle.pqc.crypto.snova.SnovaParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.GF16;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SnovaEngine {
    private static final Map<Integer, byte[]> fixedAbqSet = new HashMap<Integer, byte[]>();
    private static final Map<Integer, byte[][]> sSet = new HashMap<Integer, byte[][]>();
    private static final Map<Integer, int[][]> xSSet = new HashMap<Integer, int[][]>();
    private final SnovaParameters params;
    private final int l;
    private final int lsq;
    private final int m;
    private final int v;
    private final int o;
    private final int alpha;
    private final int n;
    final byte[][] S;
    final int[][] xS;

    public SnovaEngine(SnovaParameters params) {
        this.params = params;
        this.l = params.getL();
        this.lsq = params.getLsq();
        this.m = params.getM();
        this.v = params.getV();
        this.o = params.getO();
        this.alpha = params.getAlpha();
        this.n = params.getN();
        if (!xSSet.containsKey(Integers.valueOf(this.l))) {
            int index;
            byte[][] S = new byte[this.l][this.lsq];
            int[][] xS = new int[this.l][this.lsq];
            this.be_aI(S[0], 0, (byte)1);
            this.beTheS(S[1]);
            for (index = 2; index < this.l; ++index) {
                GF16Utils.gf16mMul(S[index - 1], S[1], S[index], this.l);
            }
            for (index = 0; index < this.l; ++index) {
                for (int ij = 0; ij < this.lsq; ++ij) {
                    xS[index][ij] = GF16Utils.gf16FromNibble(S[index][ij]);
                }
            }
            sSet.put(Integers.valueOf(this.l), S);
            xSSet.put(Integers.valueOf(this.l), xS);
        }
        this.S = sSet.get(Integers.valueOf(this.l));
        this.xS = xSSet.get(Integers.valueOf(this.l));
        if (this.l < 4 && !fixedAbqSet.containsKey(Integers.valueOf(this.o))) {
            int alphaxl = this.alpha * this.l;
            int alphaxlsq = alphaxl * this.l;
            int oxalphaxl = this.o * alphaxl;
            int oxalphaxlsq = this.o * alphaxlsq;
            byte[] fixedAbq = new byte[oxalphaxlsq << 2];
            byte[] rngOut = new byte[oxalphaxlsq + oxalphaxl];
            byte[] q12 = new byte[oxalphaxl << 2];
            byte[] seed = "SNOVA_ABQ".getBytes();
            SHAKEDigest shake = new SHAKEDigest(256);
            shake.update(seed, 0, seed.length);
            shake.doFinal(rngOut, 0, rngOut.length);
            GF16.decode(rngOut, fixedAbq, oxalphaxlsq << 1);
            GF16.decode(rngOut, alphaxlsq, q12, 0, oxalphaxl << 1);
            int pi = 0;
            int pixAlphaxlsq = 0;
            int pixalphaxl = 0;
            while (pi < this.o) {
                int a = 0;
                int axl = pixalphaxl;
                int axlsq = pixAlphaxlsq;
                while (a < this.alpha) {
                    this.makeInvertibleByAddingAS(fixedAbq, axlsq);
                    this.makeInvertibleByAddingAS(fixedAbq, oxalphaxlsq + axlsq);
                    this.genAFqS(q12, axl, fixedAbq, (oxalphaxlsq << 1) + axlsq);
                    this.genAFqS(q12, oxalphaxl + axl, fixedAbq, (oxalphaxlsq << 1) + oxalphaxlsq + axlsq);
                    ++a;
                    axl += this.l;
                    axlsq += this.lsq;
                }
                ++pi;
                pixAlphaxlsq += alphaxlsq;
                pixalphaxl += alphaxl;
            }
            fixedAbqSet.put(Integers.valueOf(this.o), fixedAbq);
        }
    }

    private void beTheS(byte[] target) {
        int i = 0;
        int il = 0;
        while (i < this.l) {
            for (int j = 0; j < this.l; ++j) {
                int value = 8 - (i + j);
                target[il + j] = (byte)(value & 0xF);
            }
            ++i;
            il += this.l;
        }
        if (this.l == 5) {
            target[24] = 9;
        }
    }

    private void be_aI(byte[] target, int off, byte a) {
        int l1 = this.l + 1;
        int i = 0;
        while (i < this.l) {
            target[off] = a;
            ++i;
            off += l1;
        }
    }

    private void genAFqSCT(byte[] c, int cOff, byte[] ptMatrix) {
        int[] xTemp = new int[this.lsq];
        int l1 = this.l + 1;
        int cX = GF16Utils.gf16FromNibble(c[cOff]);
        int ij = 0;
        int ijl1 = 0;
        while (ij < this.l) {
            xTemp[ijl1] = cX;
            ++ij;
            ijl1 += l1;
        }
        for (int i1 = 1; i1 < this.l - 1; ++i1) {
            cX = GF16Utils.gf16FromNibble(c[cOff + i1]);
            for (int ij2 = 0; ij2 < this.lsq; ++ij2) {
                int n = ij2;
                xTemp[n] = xTemp[n] ^ cX * this.xS[i1][ij2];
            }
        }
        int zero = GF16Utils.ctGF16IsNotZero(c[cOff + this.l - 1]);
        int val = zero * c[cOff + this.l - 1] + (1 - zero) * (15 + GF16Utils.ctGF16IsNotZero(c[cOff]) - c[cOff]);
        cX = GF16Utils.gf16FromNibble((byte)val);
        for (int ij3 = 0; ij3 < this.lsq; ++ij3) {
            int n = ij3;
            xTemp[n] = xTemp[n] ^ cX * this.xS[this.l - 1][ij3];
            ptMatrix[ij3] = GF16Utils.gf16ToNibble(xTemp[ij3]);
        }
        Arrays.fill(xTemp, 0);
    }

    private void makeInvertibleByAddingAS(byte[] source, int off) {
        if (this.gf16Determinant(source, off) != 0) {
            return;
        }
        for (int a = 1; a < 16; ++a) {
            this.generateASMatrixTo(source, off, (byte)a);
            if (this.gf16Determinant(source, off) == 0) continue;
            return;
        }
    }

    private byte gf16Determinant(byte[] matrix, int off) {
        switch (this.l) {
            case 2: {
                return this.determinant2x2(matrix, off);
            }
            case 3: {
                return this.determinant3x3(matrix, off);
            }
            case 4: {
                return this.determinant4x4(matrix, off);
            }
            case 5: {
                return this.determinant5x5(matrix, off);
            }
        }
        throw new IllegalStateException();
    }

    private byte determinant2x2(byte[] m, int off) {
        return (byte)(GF16.mul(m[off], m[off + 3]) ^ GF16.mul(m[off + 1], m[off + 2]));
    }

    private byte determinant3x3(byte[] m, int off) {
        byte m00 = m[off++];
        byte m01 = m[off++];
        byte m02 = m[off++];
        byte m10 = m[off++];
        byte m11 = m[off++];
        byte m12 = m[off++];
        byte m20 = m[off++];
        byte m21 = m[off++];
        byte m22 = m[off];
        return (byte)(GF16.mul((int)m00, GF16.mul(m11, m22) ^ GF16.mul(m12, m21)) ^ GF16.mul((int)m01, GF16.mul(m10, m22) ^ GF16.mul(m12, m20)) ^ GF16.mul((int)m02, GF16.mul(m10, m21) ^ GF16.mul(m11, m20)));
    }

    private byte determinant4x4(byte[] m, int off) {
        byte m00 = m[off++];
        byte m01 = m[off++];
        byte m02 = m[off++];
        byte m03 = m[off++];
        byte m10 = m[off++];
        byte m11 = m[off++];
        byte m12 = m[off++];
        byte m13 = m[off++];
        byte m20 = m[off++];
        byte m21 = m[off++];
        byte m22 = m[off++];
        byte m23 = m[off++];
        byte m30 = m[off++];
        byte m31 = m[off++];
        byte m32 = m[off++];
        byte m33 = m[off];
        byte m22xm33_m23xm32 = (byte)(GF16.mul(m22, m33) ^ GF16.mul(m23, m32));
        byte m21xm33_m23xm31 = (byte)(GF16.mul(m21, m33) ^ GF16.mul(m23, m31));
        byte m21xm32_m22xm31 = (byte)(GF16.mul(m21, m32) ^ GF16.mul(m22, m31));
        byte m20xm33_m23xm30 = (byte)(GF16.mul(m20, m33) ^ GF16.mul(m23, m30));
        byte m20xm32_m32xm30 = (byte)(GF16.mul(m20, m32) ^ GF16.mul(m22, m30));
        byte m20xm31_m21xm30 = (byte)(GF16.mul(m20, m31) ^ GF16.mul(m21, m30));
        return (byte)(GF16.mul((int)m00, GF16.mul(m11, m22xm33_m23xm32) ^ GF16.mul(m12, m21xm33_m23xm31) ^ GF16.mul(m13, m21xm32_m22xm31)) ^ GF16.mul((int)m01, GF16.mul(m10, m22xm33_m23xm32) ^ GF16.mul(m12, m20xm33_m23xm30) ^ GF16.mul(m13, m20xm32_m32xm30)) ^ GF16.mul((int)m02, GF16.mul(m10, m21xm33_m23xm31) ^ GF16.mul(m11, m20xm33_m23xm30) ^ GF16.mul(m13, m20xm31_m21xm30)) ^ GF16.mul((int)m03, GF16.mul(m10, m21xm32_m22xm31) ^ GF16.mul(m11, m20xm32_m32xm30) ^ GF16.mul(m12, m20xm31_m21xm30)));
    }

    private byte determinant5x5(byte[] m, int off) {
        byte m00 = m[off++];
        byte m01 = m[off++];
        byte m02 = m[off++];
        byte m03 = m[off++];
        byte m04 = m[off++];
        byte m10 = m[off++];
        byte m11 = m[off++];
        byte m12 = m[off++];
        byte m13 = m[off++];
        byte m14 = m[off++];
        byte m20 = m[off++];
        byte m21 = m[off++];
        byte m22 = m[off++];
        byte m23 = m[off++];
        byte m24 = m[off++];
        byte m30 = m[off++];
        byte m31 = m[off++];
        byte m32 = m[off++];
        byte m33 = m[off++];
        byte m34 = m[off++];
        byte m40 = m[off++];
        byte m41 = m[off++];
        byte m42 = m[off++];
        byte m43 = m[off++];
        byte m44 = m[off];
        byte m10xm21_m11xm20 = (byte)(GF16.mul(m10, m21) ^ GF16.mul(m11, m20));
        byte m10xm22_m12xm20 = (byte)(GF16.mul(m10, m22) ^ GF16.mul(m12, m20));
        byte m10xm23_m13xm20 = (byte)(GF16.mul(m10, m23) ^ GF16.mul(m13, m20));
        byte m10xm24_m14xm20 = (byte)(GF16.mul(m10, m24) ^ GF16.mul(m14, m20));
        byte m11xm22_m12xm21 = (byte)(GF16.mul(m11, m22) ^ GF16.mul(m12, m21));
        byte m11xm23_m13xm21 = (byte)(GF16.mul(m11, m23) ^ GF16.mul(m13, m21));
        byte m11xm24_m14xm21 = (byte)(GF16.mul(m11, m24) ^ GF16.mul(m14, m21));
        byte m12xm23_m13xm22 = (byte)(GF16.mul(m12, m23) ^ GF16.mul(m13, m22));
        byte m12xm24_m14xm22 = (byte)(GF16.mul(m12, m24) ^ GF16.mul(m14, m22));
        byte m13xm24_m14xm23 = (byte)(GF16.mul(m13, m24) ^ GF16.mul(m14, m23));
        byte result = (byte)GF16.mul(GF16.mul(m00, m11xm22_m12xm21) ^ GF16.mul(m01, m10xm22_m12xm20) ^ GF16.mul(m02, m10xm21_m11xm20), GF16.mul(m33, m44) ^ GF16.mul(m34, m43));
        result = (byte)(result ^ GF16.mul(GF16.mul(m00, m11xm23_m13xm21) ^ GF16.mul(m01, m10xm23_m13xm20) ^ GF16.mul(m03, m10xm21_m11xm20), GF16.mul(m32, m44) ^ GF16.mul(m34, m42)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m00, m11xm24_m14xm21) ^ GF16.mul(m01, m10xm24_m14xm20) ^ GF16.mul(m04, m10xm21_m11xm20), GF16.mul(m32, m43) ^ GF16.mul(m33, m42)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m00, m12xm23_m13xm22) ^ GF16.mul(m02, m10xm23_m13xm20) ^ GF16.mul(m03, m10xm22_m12xm20), GF16.mul(m31, m44) ^ GF16.mul(m34, m41)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m00, m12xm24_m14xm22) ^ GF16.mul(m02, m10xm24_m14xm20) ^ GF16.mul(m04, m10xm22_m12xm20), GF16.mul(m31, m43) ^ GF16.mul(m33, m41)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m00, m13xm24_m14xm23) ^ GF16.mul(m03, m10xm24_m14xm20) ^ GF16.mul(m04, m10xm23_m13xm20), GF16.mul(m31, m42) ^ GF16.mul(m32, m41)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m01, m12xm23_m13xm22) ^ GF16.mul(m02, m11xm23_m13xm21) ^ GF16.mul(m03, m11xm22_m12xm21), GF16.mul(m30, m44) ^ GF16.mul(m34, m40)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m01, m12xm24_m14xm22) ^ GF16.mul(m02, m11xm24_m14xm21) ^ GF16.mul(m04, m11xm22_m12xm21), GF16.mul(m30, m43) ^ GF16.mul(m33, m40)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m01, m13xm24_m14xm23) ^ GF16.mul(m03, m11xm24_m14xm21) ^ GF16.mul(m04, m11xm23_m13xm21), GF16.mul(m30, m42) ^ GF16.mul(m32, m40)));
        result = (byte)(result ^ GF16.mul(GF16.mul(m02, m13xm24_m14xm23) ^ GF16.mul(m03, m12xm24_m14xm22) ^ GF16.mul(m04, m12xm23_m13xm22), GF16.mul(m30, m41) ^ GF16.mul(m31, m40)));
        return result;
    }

    private void generateASMatrixTo(byte[] target, int off, byte a) {
        int i = 0;
        int ixl = off;
        while (i < this.l) {
            for (int j = 0; j < this.l; ++j) {
                int coefficient = 8 - (i + j);
                if (this.l == 5 && i == 4 && j == 4) {
                    coefficient = 9;
                }
                int n = ixl + j;
                target[n] = (byte)(target[n] ^ GF16.mul((byte)coefficient, a));
            }
            ++i;
            ixl += this.l;
        }
    }

    private void genAFqS(byte[] c, int cOff, byte[] ptMatrix, int off) {
        this.be_aI(ptMatrix, off, c[cOff]);
        for (int i = 1; i < this.l - 1; ++i) {
            this.gf16mScaleTo(this.S[i], c[cOff + i], ptMatrix, off);
        }
        byte lastScalar = (byte)(c[cOff + this.l - 1] != 0 ? c[cOff + this.l - 1] : 16 - (c[cOff] + (c[cOff] == 0 ? (byte)1 : 0)));
        this.gf16mScaleTo(this.S[this.l - 1], lastScalar, ptMatrix, off);
    }

    private void gf16mScaleTo(byte[] a, byte k, byte[] c, int cOff) {
        int i = 0;
        int il = 0;
        while (i < this.l) {
            for (int j = 0; j < this.l; ++j) {
                int n = il + j + cOff;
                c[n] = (byte)(c[n] ^ GF16.mul(a[il + j], k));
            }
            ++i;
            il += this.l;
        }
    }

    private void genF(MapGroup2 map2, MapGroup1 map1, byte[][][] T12) {
        SnovaEngine.copy4DMatrix(map1.p11, map2.f11, this.m, this.v, this.v, this.lsq);
        SnovaEngine.copy4DMatrix(map1.p12, map2.f12, this.m, this.v, this.o, this.lsq);
        SnovaEngine.copy4DMatrix(map1.p21, map2.f21, this.m, this.o, this.v, this.lsq);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.v; ++j) {
                for (int k = 0; k < this.o; ++k) {
                    for (int index = 0; index < this.v; ++index) {
                        GF16Utils.gf16mMulToTo(map1.p11[i][j][index], T12[index][k], map1.p11[i][index][j], map2.f12[i][j][k], map2.f21[i][k][j], this.l);
                    }
                }
            }
        }
    }

    private static void copy4DMatrix(byte[][][][] src, byte[][][][] dest, int dim1, int dim2, int dim3, int lsq) {
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                for (int k = 0; k < dim3; ++k) {
                    System.arraycopy(src[i][j][k], 0, dest[i][j][k], 0, lsq);
                }
            }
        }
    }

    public void genP22(byte[] outP22, int outOff, byte[][][] T12, byte[][][][] P21, byte[][][][] F12) {
        int oxlsq = this.o * this.lsq;
        int oxoxlsq = oxlsq * this.o;
        byte[] P22 = new byte[this.m * oxoxlsq];
        int i = 0;
        int ixoxolsq = 0;
        while (i < this.m) {
            int j = 0;
            int jxoxlsq = ixoxolsq;
            while (j < this.o) {
                int k = 0;
                int kxlsq = jxoxlsq;
                while (k < this.o) {
                    for (int index = 0; index < this.v; ++index) {
                        GF16Utils.gf16mMulTo(T12[index][j], F12[i][index][k], P21[i][j][index], T12[index][k], P22, kxlsq, this.l);
                    }
                    ++k;
                    kxlsq += this.lsq;
                }
                ++j;
                jxoxlsq += oxlsq;
            }
            ++i;
            ixoxolsq += oxoxlsq;
        }
        GF16.encode(P22, outP22, outOff, P22.length);
    }

    private void genSeedsAndT12(byte[][][] T12, byte[] skSeed) {
        int gf16sPrngPrivate = this.v * this.o * this.l;
        int bytesPrngPrivate = gf16sPrngPrivate + 1 >>> 1;
        byte[] prngOutput = new byte[bytesPrngPrivate];
        SHAKEDigest shake = new SHAKEDigest(256);
        shake.update(skSeed, 0, skSeed.length);
        shake.doFinal(prngOutput, 0, prngOutput.length);
        byte[] gf16PrngOutput = new byte[gf16sPrngPrivate];
        GF16.decode(prngOutput, gf16PrngOutput, gf16sPrngPrivate);
        int ptArray = 0;
        for (int j = 0; j < this.v; ++j) {
            for (int k = 0; k < this.o; ++k) {
                this.genAFqSCT(gf16PrngOutput, ptArray, T12[j][k]);
                ptArray += this.l;
            }
        }
    }

    public void genABQP(MapGroup1 map1, byte[] pkSeed) {
        int gf16sPrngPublic = this.lsq * (2 * this.m * this.alpha + this.m * (this.n * this.n - this.m * this.m)) + this.l * 2 * this.m * this.alpha;
        byte[] qTemp = new byte[this.m * this.alpha * this.l << 1];
        byte[] prngOutput = new byte[gf16sPrngPublic + 1 >> 1];
        if (this.params.isPkExpandShake()) {
            int SHAKE128_RATE = 168;
            long blockCounter = 0L;
            int offset = 0;
            int remaining = prngOutput.length;
            byte[] counterBytes = new byte[8];
            SHAKEDigest shake = new SHAKEDigest(128);
            while (remaining > 0) {
                shake.update(pkSeed, 0, pkSeed.length);
                Pack.longToLittleEndian(blockCounter, counterBytes, 0);
                shake.update(counterBytes, 0, 8);
                int bytesToGenerate = Math.min(remaining, 168);
                shake.doFinal(prngOutput, offset, bytesToGenerate);
                offset += bytesToGenerate;
                remaining -= bytesToGenerate;
                ++blockCounter;
            }
        } else {
            byte[] iv = new byte[16];
            CTRModeCipher ctrCipher = SICBlockCipher.newInstance(AESEngine.newInstance());
            ctrCipher.init(true, new ParametersWithIV(new KeyParameter(pkSeed), iv));
            int blockSize = ctrCipher.getBlockSize();
            byte[] zeroBlock = new byte[blockSize];
            int offset = 0;
            while (offset + blockSize <= prngOutput.length) {
                ctrCipher.processBlock(zeroBlock, 0, prngOutput, offset);
                offset += blockSize;
            }
            if (offset < prngOutput.length) {
                ctrCipher.processBlock(zeroBlock, 0, zeroBlock, 0);
                int remaining = prngOutput.length - offset;
                System.arraycopy(zeroBlock, 0, prngOutput, offset, remaining);
            }
        }
        if ((this.lsq & 1) == 0) {
            map1.decode(prngOutput, gf16sPrngPublic - qTemp.length >> 1, this.l >= 4);
        } else {
            byte[] temp = new byte[gf16sPrngPublic - qTemp.length];
            GF16.decode(prngOutput, temp, temp.length);
            map1.fill(temp, this.l >= 4);
        }
        if (this.l >= 4) {
            GF16.decode(prngOutput, gf16sPrngPublic - qTemp.length >> 1, qTemp, 0, qTemp.length);
            int ptArray = 0;
            int offset = this.m * this.alpha * this.l;
            for (int pi = 0; pi < this.m; ++pi) {
                for (int a = 0; a < this.alpha; ++a) {
                    this.makeInvertibleByAddingAS(map1.aAlpha[pi][a], 0);
                    this.makeInvertibleByAddingAS(map1.bAlpha[pi][a], 0);
                    this.genAFqS(qTemp, ptArray, map1.qAlpha1[pi][a], 0);
                    this.genAFqS(qTemp, offset, map1.qAlpha2[pi][a], 0);
                    ptArray += this.l;
                    offset += this.l;
                }
            }
        } else {
            int oxalphaxlsq = this.o * this.alpha * this.lsq;
            byte[] fixedAbq = fixedAbqSet.get(Integers.valueOf(this.o));
            MapGroup1.fillAlpha(fixedAbq, 0, map1.aAlpha, this.m * oxalphaxlsq);
            MapGroup1.fillAlpha(fixedAbq, oxalphaxlsq, map1.bAlpha, (this.m - 1) * oxalphaxlsq);
            MapGroup1.fillAlpha(fixedAbq, oxalphaxlsq * 2, map1.qAlpha1, (this.m - 2) * oxalphaxlsq);
            MapGroup1.fillAlpha(fixedAbq, oxalphaxlsq * 3, map1.qAlpha2, (this.m - 3) * oxalphaxlsq);
        }
    }

    public void genMap1T12Map2(SnovaKeyElements keyElements, byte[] pkSeed, byte[] skSeed) {
        this.genSeedsAndT12(keyElements.T12, skSeed);
        this.genABQP(keyElements.map1, pkSeed);
        this.genF(keyElements.map2, keyElements.map1, keyElements.T12);
    }
}

