/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.MultiBlockCipher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class DefaultMultiBlockCipher
implements MultiBlockCipher {
    protected DefaultMultiBlockCipher() {
    }

    @Override
    public int getMultiBlockSize() {
        return this.getBlockSize();
    }

    @Override
    public int processBlocks(byte[] in, int inOff, int blockCount, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int resultLen = 0;
        int blockSize = this.getBlockSize();
        int len = blockCount * blockSize;
        if (in == out) {
            in = new byte[len];
            System.arraycopy(out, inOff, in, 0, len);
            inOff = 0;
        }
        for (int i = 0; i != blockCount; ++i) {
            resultLen += this.processBlock(in, inOff, out, outOff + resultLen);
            inOff += blockSize;
        }
        return resultLen;
    }
}

