/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPrivateKeySpec;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC15EdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC15EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.SignatureSpi;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jcajce.spec.RawEncodedKeySpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    static final byte[] x448Prefix = Hex.decode("3042300506032b656f033900");
    static final byte[] x25519Prefix = Hex.decode("302a300506032b656e032100");
    static final byte[] Ed448Prefix = Hex.decode("3043300506032b6571033a00");
    static final byte[] Ed25519Prefix = Hex.decode("302a300506032b6570032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    String algorithm;
    private final boolean isXdh;
    private final int specificBase;

    public KeyFactorySpi(String algorithm, boolean isXdh, int specificBase) {
        this.algorithm = algorithm;
        this.isXdh = isXdh;
        this.specificBase = specificBase;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof BC15EdDSAPrivateKey) {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(key.getEncoded());
                ASN1OctetString val = ASN1OctetString.getInstance(seq.getObjectAt(2));
                byte[] encoding = ASN1OctetString.getInstance(ASN1Primitive.fromByteArray(val.getOctets())).getOctets();
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new Ed25519PrivateKeyParameters(encoding)));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException(ex.getMessage(), ex.getCause());
            }
        }
        if (spec.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof BC15EdDSAPublicKey) {
            try {
                byte[] encoding = key.getEncoded();
                if (!Arrays.areEqual(Ed25519Prefix, 0, Ed25519Prefix.length, encoding, 0, encoding.length - 32)) {
                    throw new InvalidKeySpecException("Invalid Ed25519 public key encoding");
                }
                Ed25519PublicKeyParameters publicKey = new Ed25519PublicKeyParameters(encoding, Ed25519Prefix.length);
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(publicKey));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException(ex.getMessage(), ex.getCause());
            }
        }
        if (spec.isAssignableFrom(RawEncodedKeySpec.class)) {
            if (key instanceof XDHPublicKey) {
                return new RawEncodedKeySpec(((XDHPublicKey)key).getUEncoding());
            }
            if (key instanceof EdDSAPublicKey) {
                return new RawEncodedKeySpec(((EdDSAPublicKey)key).getPointEncoding());
            }
        } else if (spec.isAssignableFrom(EdECPrivateKeySpec.class)) {
            if (key instanceof EdECPrivateKey) {
                Optional<byte[]> bytes = ((EdECPrivateKey)key).getBytes();
                if (bytes.isPresent()) {
                    return new EdECPrivateKeySpec(((EdECPrivateKey)key).getParams(), bytes.get());
                }
                throw new IllegalArgumentException("no byte[] data associated with key");
            }
        } else if (spec.isAssignableFrom(EdECPublicKeySpec.class) && key instanceof EdECPublicKey) {
            return new EdECPublicKeySpec(((EdECPublicKey)key).getParams(), ((EdECPublicKey)key).getPoint());
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter parameters = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (parameters instanceof Ed25519PrivateKeyParameters) {
                return new BC15EdDSAPrivateKey((Ed25519PrivateKeyParameters)parameters);
            }
            throw new InvalidKeySpecException("openssh private key not Ed25519 private key");
        }
        if (keySpec instanceof EdECPrivateKeySpec) {
            EdECPrivateKeySpec edSpec = (EdECPrivateKeySpec)keySpec;
            try {
                AsymmetricKeyParameter parameters;
                if (NamedParameterSpec.ED448.getName().equalsIgnoreCase(edSpec.getParams().getName())) {
                    parameters = SignatureSpi.getEd448PrivateKey(edSpec.getBytes());
                } else if (NamedParameterSpec.ED25519.getName().equalsIgnoreCase(edSpec.getParams().getName())) {
                    parameters = SignatureSpi.getEd25519PrivateKey(edSpec.getBytes());
                } else {
                    throw new InvalidKeySpecException("unrecognized named parameters: " + edSpec.getParams().getName());
                }
                return new BC15EdDSAPrivateKey(parameters);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e.getMessage(), e);
            }
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
            if (this.specificBase == 0 || this.specificBase == enc[8]) {
                if (enc[9] == 5 && enc[10] == 0) {
                    SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(enc);
                    keyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(keyInfo.getAlgorithm().getAlgorithm()), keyInfo.getPublicKeyData().getBytes());
                    try {
                        enc = keyInfo.getEncoded("DER");
                    }
                    catch (IOException e) {
                        throw new InvalidKeySpecException("attempt to reconstruct key failed: " + e.getMessage());
                    }
                }
                switch (enc[8]) {
                    case 111: {
                        return new BC11XDHPublicKey(x448Prefix, enc);
                    }
                    case 110: {
                        return new BC11XDHPublicKey(x25519Prefix, enc);
                    }
                    case 113: {
                        return new BC15EdDSAPublicKey(Ed448Prefix, enc);
                    }
                    case 112: {
                        return new BC15EdDSAPublicKey(Ed25519Prefix, enc);
                    }
                }
                return super.engineGeneratePublic(keySpec);
            }
        } else {
            if (keySpec instanceof RawEncodedKeySpec) {
                byte[] enc = ((RawEncodedKeySpec)keySpec).getEncoded();
                switch (this.specificBase) {
                    case 111: {
                        return new BC11XDHPublicKey(new X448PublicKeyParameters(enc));
                    }
                    case 110: {
                        return new BC11XDHPublicKey(new X25519PublicKeyParameters(enc));
                    }
                    case 113: {
                        return new BC15EdDSAPublicKey(new Ed448PublicKeyParameters(enc));
                    }
                    case 112: {
                        return new BC15EdDSAPublicKey(new Ed25519PublicKeyParameters(enc));
                    }
                }
                throw new InvalidKeySpecException("factory not a specific type, cannot recognise raw encoding");
            }
            if (keySpec instanceof EdECPublicKeySpec) {
                EdECPublicKeySpec edSpec = (EdECPublicKeySpec)keySpec;
                try {
                    AsymmetricKeyParameter parameters;
                    if (NamedParameterSpec.ED448.getName().equalsIgnoreCase(edSpec.getParams().getName())) {
                        parameters = SignatureSpi.getEd448PublicKey(edSpec.getPoint());
                    } else if (NamedParameterSpec.ED25519.getName().equalsIgnoreCase(edSpec.getParams().getName())) {
                        parameters = SignatureSpi.getEd25519PublicKey(edSpec.getPoint());
                    } else {
                        throw new InvalidKeySpecException("unrecognized named parameters: " + edSpec.getParams().getName());
                    }
                    return new BC15EdDSAPublicKey(parameters);
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.getMessage(), e);
                }
            }
            if (keySpec instanceof OpenSSHPublicKeySpec) {
                AsymmetricKeyParameter parameters = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
                if (parameters instanceof Ed25519PublicKeyParameters) {
                    return new BC15EdDSAPublicKey(new byte[0], ((Ed25519PublicKeyParameters)parameters).getEncoded());
                }
                throw new InvalidKeySpecException("openssh public key not Ed25519 public key");
            }
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                return new BC11XDHPrivateKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BC11XDHPrivateKey(keyInfo);
            }
        } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new BC15EdDSAPrivateKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new BC15EdDSAPrivateKey(keyInfo);
            }
        }
        throw new IOException("algorithm identifier " + String.valueOf(algOid) + " in key not recognized");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                return new BC11XDHPublicKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BC11XDHPublicKey(keyInfo);
            }
        } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new BC15EdDSAPublicKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new BC15EdDSAPublicKey(keyInfo);
            }
        }
        throw new IOException("algorithm identifier " + String.valueOf(algOid) + " in key not recognized");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Ed25519
    extends KeyFactorySpi {
        public Ed25519() {
            super("Ed25519", false, 112);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Ed448
    extends KeyFactorySpi {
        public Ed448() {
            super("Ed448", false, 113);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class EdDSA
    extends KeyFactorySpi {
        public EdDSA() {
            super("EdDSA", false, 0);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class X25519
    extends KeyFactorySpi {
        public X25519() {
            super("X25519", true, 110);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class X448
    extends KeyFactorySpi {
        public X448() {
            super("X448", true, 111);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class XDH
    extends KeyFactorySpi {
        public XDH() {
            super("XDH", true, 0);
        }
    }
}

