/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Signature {
    final byte[] challengeBits;
    final byte[] salt = new byte[32];
    final Proof[] proofs;

    Signature(PicnicEngine engine) {
        this.challengeBits = new byte[Utils.numBytes(engine.numMPCRounds * 2)];
        this.proofs = new Proof[engine.numMPCRounds];
        for (int i = 0; i < this.proofs.length; ++i) {
            this.proofs[i] = new Proof(engine);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Proof {
        final byte[] seed1;
        final byte[] seed2;
        final int[] inputShare;
        final byte[] communicatedBits;
        final byte[] view3Commitment;
        final byte[] view3UnruhG;

        Proof(PicnicEngine engine) {
            this.seed1 = new byte[engine.seedSizeBytes];
            this.seed2 = new byte[engine.seedSizeBytes];
            this.inputShare = new int[engine.stateSizeWords];
            this.communicatedBits = new byte[engine.andSizeBytes];
            this.view3Commitment = new byte[engine.digestSizeBytes];
            this.view3UnruhG = (byte[])(engine.UnruhGWithInputBytes > 0 ? new byte[engine.UnruhGWithInputBytes] : null);
        }
    }
}

