/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.ntruprime;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.KEM;
import javax.crypto.KEMSpi;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMGenerator;
import org.bouncycastle.pqc.jcajce.provider.Util;
import org.bouncycastle.pqc.jcajce.provider.ntruprime.BCSNTRUPrimePublicKey;
import org.bouncycastle.util.Arrays;

class SNTRUPrimeEncapsulatorSpi
implements KEMSpi.EncapsulatorSpi {
    private final BCSNTRUPrimePublicKey publicKey;
    private final KTSParameterSpec parameterSpec;
    private final SNTRUPrimeKEMGenerator kemGen;

    public SNTRUPrimeEncapsulatorSpi(BCSNTRUPrimePublicKey publicKey, KTSParameterSpec parameterSpec, SecureRandom random) {
        this.publicKey = publicKey;
        this.parameterSpec = parameterSpec;
        this.kemGen = new SNTRUPrimeKEMGenerator(random);
    }

    @Override
    public KEM.Encapsulated engineEncapsulate(int from, int to, String algorithm) {
        Objects.checkFromToIndex(from, to, this.engineSecretSize());
        Objects.requireNonNull(algorithm, "null algorithm");
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && algorithm.equals("Generic")) {
            algorithm = this.parameterSpec.getKeyAlgorithmName();
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && !this.parameterSpec.getKeyAlgorithmName().equals(algorithm)) {
            throw new UnsupportedOperationException(this.parameterSpec.getKeyAlgorithmName() + " does not match " + algorithm);
        }
        boolean useKDF = this.parameterSpec.getKdfAlgorithm() != null;
        SecretWithEncapsulation secEnc = this.kemGen.generateEncapsulated(this.publicKey.getKeyParams());
        byte[] encapsulation = secEnc.getEncapsulation();
        byte[] secret = secEnc.getSecret();
        if (useKDF) {
            try {
                secret = Util.makeKeyBytes(this.parameterSpec, secret);
            }
            catch (InvalidKeyException e) {
                throw new IllegalStateException(e);
            }
        }
        byte[] secretKey = Arrays.copyOfRange(secret, from, to);
        return new KEM.Encapsulated(new SecretKeySpec(secretKey, algorithm), encapsulation, null);
    }

    @Override
    public int engineSecretSize() {
        return this.parameterSpec.getKeySize() / 8;
    }

    @Override
    public int engineEncapsulationSize() {
        return this.publicKey.getKeyParams().getParameters().getRoundedPolynomialBytes() + 32;
    }
}

