/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru;

import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Polynomial {
    public short[] coeffs;
    protected NTRUParameterSet params;

    public Polynomial(NTRUParameterSet params) {
        this.coeffs = new short[params.n()];
        this.params = params;
    }

    static short bothNegativeMask(short x, short y) {
        return (short)((x & y) >>> 15);
    }

    static short mod3(short a) {
        return (short)((a & 0xFFFF) % 3);
    }

    static byte mod3(byte a) {
        return (byte)((a & 0xFF) % 3);
    }

    static int modQ(int x, int q) {
        return x % q;
    }

    public void mod3PhiN() {
        int n = this.params.n();
        for (int i = 0; i < n; ++i) {
            this.coeffs[i] = Polynomial.mod3((short)(this.coeffs[i] + 2 * this.coeffs[n - 1]));
        }
    }

    public void modQPhiN() {
        int n = this.params.n();
        for (int i = 0; i < n; ++i) {
            this.coeffs[i] = (short)(this.coeffs[i] - this.coeffs[n - 1]);
        }
    }

    public abstract byte[] sqToBytes(int var1);

    public abstract void sqFromBytes(byte[] var1);

    public byte[] rqSumZeroToBytes(int len) {
        return this.sqToBytes(len);
    }

    public void rqSumZeroFromBytes(byte[] a) {
        int n = this.coeffs.length;
        this.sqFromBytes(a);
        this.coeffs[n - 1] = 0;
        for (int i = 0; i < this.params.packDegree(); ++i) {
            int n2 = n - 1;
            this.coeffs[n2] = (short)(this.coeffs[n2] - this.coeffs[i]);
        }
    }

    public byte[] s3ToBytes(int messageSize) {
        byte c;
        int i;
        byte[] msg = new byte[messageSize];
        for (i = 0; i < this.params.packDegree() / 5; ++i) {
            c = (byte)(this.coeffs[5 * i + 4] & 0xFF);
            c = (byte)(3 * c + this.coeffs[5 * i + 3] & 0xFF);
            c = (byte)(3 * c + this.coeffs[5 * i + 2] & 0xFF);
            c = (byte)(3 * c + this.coeffs[5 * i + 1] & 0xFF);
            msg[i] = c = (byte)(3 * c + this.coeffs[5 * i + 0] & 0xFF);
        }
        if (this.params.packDegree() > this.params.packDegree() / 5 * 5) {
            i = this.params.packDegree() / 5;
            c = 0;
            for (int j = this.params.packDegree() - 5 * i - 1; j >= 0; --j) {
                c = (byte)(3 * c + this.coeffs[5 * i + j] & 0xFF);
            }
            msg[i] = c;
        }
        return msg;
    }

    public void s3FromBytes(byte[] msg) {
        byte c;
        int i;
        int n = this.coeffs.length;
        for (i = 0; i < this.params.packDegree() / 5; ++i) {
            c = msg[i];
            this.coeffs[5 * i + 0] = c;
            this.coeffs[5 * i + 1] = (short)((c & 0xFF) * 171 >>> 9);
            this.coeffs[5 * i + 2] = (short)((c & 0xFF) * 57 >>> 9);
            this.coeffs[5 * i + 3] = (short)((c & 0xFF) * 19 >>> 9);
            this.coeffs[5 * i + 4] = (short)((c & 0xFF) * 203 >>> 14);
        }
        if (this.params.packDegree() > this.params.packDegree() / 5 * 5) {
            i = this.params.packDegree() / 5;
            c = msg[i];
            int j = 0;
            while (5 * i + j < this.params.packDegree()) {
                this.coeffs[5 * i + j] = c;
                c = (byte)((c & 0xFF) * 171 >> 9);
                ++j;
            }
        }
        this.coeffs[n - 1] = 0;
        this.mod3PhiN();
    }

    public void sqMul(Polynomial a, Polynomial b) {
        this.rqMul(a, b);
        this.modQPhiN();
    }

    public void rqMul(Polynomial a, Polynomial b) {
        int n = this.coeffs.length;
        for (int k = 0; k < n; ++k) {
            int i;
            this.coeffs[k] = 0;
            for (i = 1; i < n - k; ++i) {
                int n2 = k;
                this.coeffs[n2] = (short)(this.coeffs[n2] + a.coeffs[k + i] * b.coeffs[n - i]);
            }
            for (i = 0; i < k + 1; ++i) {
                int n3 = k;
                this.coeffs[n3] = (short)(this.coeffs[n3] + a.coeffs[k - i] * b.coeffs[i]);
            }
        }
    }

    public void s3Mul(Polynomial a, Polynomial b) {
        this.rqMul(a, b);
        this.mod3PhiN();
    }

    public abstract void lift(Polynomial var1);

    public void rqToS3(Polynomial a) {
        int n = this.coeffs.length;
        int i = 0;
        while (i < n) {
            this.coeffs[i] = (short)Polynomial.modQ(a.coeffs[i] & 0xFFFF, this.params.q());
            short flag = (short)(this.coeffs[i] >>> this.params.logQ() - 1);
            int n2 = i++;
            this.coeffs[n2] = (short)(this.coeffs[n2] + (flag << 1 - (this.params.logQ() & 1)));
        }
        this.mod3PhiN();
    }

    public abstract void r2Inv(Polynomial var1);

    void r2Inv(Polynomial a, Polynomial f, Polynomial g, Polynomial v, Polynomial w) {
        int i;
        int n = this.coeffs.length;
        w.coeffs[0] = 1;
        for (i = 0; i < n; ++i) {
            f.coeffs[i] = 1;
        }
        for (i = 0; i < n - 1; ++i) {
            g.coeffs[n - 2 - i] = (short)((a.coeffs[i] ^ a.coeffs[n - 1]) & 1);
        }
        g.coeffs[n - 1] = 0;
        int delta = 1;
        for (int loop = 0; loop < 2 * (n - 1) - 1; ++loop) {
            for (i = n - 1; i > 0; --i) {
                v.coeffs[i] = v.coeffs[i - 1];
            }
            v.coeffs[0] = 0;
            short sign = (short)(g.coeffs[0] & f.coeffs[0]);
            short swap = Polynomial.bothNegativeMask((short)(-delta), -g.coeffs[0]);
            delta = (short)(delta ^ swap & (delta ^ -delta));
            delta = (short)(delta + 1);
            i = 0;
            while (i < n) {
                short t = (short)(swap & (f.coeffs[i] ^ g.coeffs[i]));
                int n2 = i;
                f.coeffs[n2] = (short)(f.coeffs[n2] ^ t);
                int n3 = i;
                g.coeffs[n3] = (short)(g.coeffs[n3] ^ t);
                t = (short)(swap & (v.coeffs[i] ^ w.coeffs[i]));
                int n4 = i;
                v.coeffs[n4] = (short)(v.coeffs[n4] ^ t);
                int n5 = i++;
                w.coeffs[n5] = (short)(w.coeffs[n5] ^ t);
            }
            for (i = 0; i < n; ++i) {
                g.coeffs[i] = (short)(g.coeffs[i] ^ sign & f.coeffs[i]);
            }
            for (i = 0; i < n; ++i) {
                w.coeffs[i] = (short)(w.coeffs[i] ^ sign & v.coeffs[i]);
            }
            for (i = 0; i < n - 1; ++i) {
                g.coeffs[i] = g.coeffs[i + 1];
            }
            g.coeffs[n - 1] = 0;
        }
        for (i = 0; i < n - 1; ++i) {
            this.coeffs[i] = v.coeffs[n - 2 - i];
        }
        this.coeffs[n - 1] = 0;
    }

    public abstract void rqInv(Polynomial var1);

    void rqInv(Polynomial a, Polynomial ai2, Polynomial b, Polynomial c, Polynomial s) {
        ai2.r2Inv(a);
        this.r2InvToRqInv(ai2, a, b, c, s);
    }

    private void r2InvToRqInv(Polynomial ai, Polynomial a, Polynomial b, Polynomial c, Polynomial s) {
        int i;
        int n = this.coeffs.length;
        for (i = 0; i < n; ++i) {
            b.coeffs[i] = -a.coeffs[i];
        }
        for (i = 0; i < n; ++i) {
            this.coeffs[i] = ai.coeffs[i];
        }
        c.rqMul(this, b);
        c.coeffs[0] = (short)(c.coeffs[0] + 2);
        s.rqMul(c, this);
        c.rqMul(s, b);
        c.coeffs[0] = (short)(c.coeffs[0] + 2);
        this.rqMul(c, s);
        c.rqMul(this, b);
        c.coeffs[0] = (short)(c.coeffs[0] + 2);
        s.rqMul(c, this);
        c.rqMul(s, b);
        c.coeffs[0] = (short)(c.coeffs[0] + 2);
        this.rqMul(c, s);
    }

    public abstract void s3Inv(Polynomial var1);

    void s3Inv(Polynomial a, Polynomial f, Polynomial g, Polynomial v, Polynomial w) {
        short sign;
        int i;
        int n = this.coeffs.length;
        w.coeffs[0] = 1;
        for (i = 0; i < n; ++i) {
            f.coeffs[i] = 1;
        }
        for (i = 0; i < n - 1; ++i) {
            g.coeffs[n - 2 - i] = Polynomial.mod3((short)((a.coeffs[i] & 3) + 2 * (a.coeffs[n - 1] & 3)));
        }
        g.coeffs[n - 1] = 0;
        int delta = 1;
        for (int loop = 0; loop < 2 * (n - 1) - 1; ++loop) {
            for (i = n - 1; i > 0; --i) {
                v.coeffs[i] = v.coeffs[i - 1];
            }
            v.coeffs[0] = 0;
            sign = Polynomial.mod3((byte)(2 * g.coeffs[0] * f.coeffs[0]));
            short swap = Polynomial.bothNegativeMask((short)(-delta), -g.coeffs[0]);
            delta = (short)(delta ^ swap & (delta ^ -delta));
            delta = (short)(delta + 1);
            i = 0;
            while (i < n) {
                short t = (short)(swap & (f.coeffs[i] ^ g.coeffs[i]));
                int n2 = i;
                f.coeffs[n2] = (short)(f.coeffs[n2] ^ t);
                int n3 = i;
                g.coeffs[n3] = (short)(g.coeffs[n3] ^ t);
                t = (short)(swap & (v.coeffs[i] ^ w.coeffs[i]));
                int n4 = i;
                v.coeffs[n4] = (short)(v.coeffs[n4] ^ t);
                int n5 = i++;
                w.coeffs[n5] = (short)(w.coeffs[n5] ^ t);
            }
            for (i = 0; i < n; ++i) {
                g.coeffs[i] = Polynomial.mod3((byte)(g.coeffs[i] + sign * f.coeffs[i]));
            }
            for (i = 0; i < n; ++i) {
                w.coeffs[i] = Polynomial.mod3((byte)(w.coeffs[i] + sign * v.coeffs[i]));
            }
            for (i = 0; i < n - 1; ++i) {
                g.coeffs[i] = g.coeffs[i + 1];
            }
            g.coeffs[n - 1] = 0;
        }
        sign = f.coeffs[0];
        for (i = 0; i < n - 1; ++i) {
            this.coeffs[i] = Polynomial.mod3((byte)(sign * v.coeffs[n - 2 - i]));
        }
        this.coeffs[n - 1] = 0;
    }

    public void z3ToZq() {
        int n = this.coeffs.length;
        for (int i = 0; i < n; ++i) {
            this.coeffs[i] = (short)(this.coeffs[i] | -(this.coeffs[i] >>> 1) & this.params.q() - 1);
        }
    }

    public void trinaryZqToZ3() {
        int n = this.coeffs.length;
        for (int i = 0; i < n; ++i) {
            this.coeffs[i] = (short)Polynomial.modQ(this.coeffs[i] & 0xFFFF, this.params.q());
            this.coeffs[i] = (short)(3 & (this.coeffs[i] ^ this.coeffs[i] >>> this.params.logQ() - 1));
        }
    }
}

