/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.lms;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.lms.LMSContext;
import org.bouncycastle.pqc.crypto.lms.LMSContextBasedSigner;
import org.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPublicKey;
import org.bouncycastle.pqc.jcajce.provider.lms.DigestUtil;

public class LMSSignatureSpi
extends Signature {
    private Digest digest;
    private MessageSigner signer;
    private SecureRandom random;
    private LMSContextBasedSigner lmOtsSigner;
    private LMSContextBasedVerifier lmOtsVerifier;

    protected LMSSignatureSpi(String algorithm) {
        super(algorithm);
    }

    protected LMSSignatureSpi(String sigName, Digest digest) {
        super(sigName);
        this.digest = digest;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCLMSPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to XMSS");
        }
        this.digest = new NullDigest();
        this.digest.reset();
        this.lmOtsVerifier = (LMSContextBasedVerifier)((Object)((BCLMSPublicKey)publicKey).getKeyParams());
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCLMSPrivateKey) {
            this.lmOtsSigner = (LMSContextBasedSigner)((Object)((BCLMSPrivateKey)privateKey).getKeyParams());
            if (this.lmOtsSigner.getUsagesRemaining() == 0L) {
                throw new InvalidKeyException("private key exhausted");
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to LMS");
        }
        this.digest = null;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.digest == null) {
            this.digest = this.getSigner();
        }
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (this.digest == null) {
            this.digest = this.getSigner();
        }
        this.digest.update(b, off, len);
    }

    private Digest getSigner() throws SignatureException {
        try {
            return this.lmOtsSigner.generateLMSContext();
        }
        catch (ExhaustedPrivateKeyException e) {
            throw new SignatureException(e.getMessage(), e);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.digest == null) {
            this.digest = this.getSigner();
        }
        try {
            byte[] sig = this.lmOtsSigner.generateSignature((LMSContext)this.digest);
            this.digest = null;
            return sig;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw new SignatureException(e.getMessage(), e);
            }
            throw new SignatureException(e.toString(), e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        LMSContext context = this.lmOtsVerifier.generateLMSContext(sigBytes);
        byte[] hash = DigestUtil.getDigestResult(this.digest);
        context.update(hash, 0, hash.length);
        return this.lmOtsVerifier.verify(context);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class generic
    extends LMSSignatureSpi {
        public generic() {
            super("LMS", new NullDigest());
        }
    }
}

