/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEKeyParameters;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEParameters;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEPrivateKeyParameters;

public class SIKEKEMExtractor
implements EncapsulatedSecretExtractor {
    private SIKEEngine engine;
    private SIKEKeyParameters key;

    public SIKEKEMExtractor(SIKEPrivateKeyParameters privParams) {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SIKEKEM", 0, privParams, CryptoServicePurpose.DECRYPTION));
        this.key = privParams;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(SIKEParameters param) {
        this.engine = param.getEngine();
    }

    public byte[] extractSecret(byte[] encapsulation) {
        return this.extractSecret(encapsulation, this.engine.getDefaultSessionKeySize());
    }

    public byte[] extractSecret(byte[] encapsulation, int sessionKeySizeInBits) {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        byte[] session_key = new byte[sessionKeySizeInBits / 8];
        this.engine.crypto_kem_dec(session_key, encapsulation, ((SIKEPrivateKeyParameters)this.key).getPrivateKey());
        return session_key;
    }

    public int getEncapsulationLength() {
        return this.engine.getCipherTextSize();
    }
}

