/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import org.bouncycastle.pqc.legacy.crypto.sike.PointProj;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;
import org.bouncycastle.util.Pack;

class Fpx {
    private SIKEEngine engine;

    Fpx(SIKEEngine engine) {
        this.engine = engine;
    }

    private void mp_shiftl1(long[] x, int nwords) {
        for (int i = nwords - 1; i > 0; --i) {
            x[i] = x[i] << 1 ^ x[i - 1] >>> 63;
        }
        x[0] = x[0] << 1;
    }

    protected void sqr_Fp2_cycl(long[][] a, long[] one) {
        long[] t0 = new long[this.engine.params.NWORDS_FIELD];
        this.fpaddPRIME(a[0], a[1], t0);
        this.fpsqr_mont(t0, t0);
        this.fpsubPRIME(t0, one, a[1]);
        this.fpsqr_mont(a[0], t0);
        this.fpaddPRIME(t0, t0, t0);
        this.fpsubPRIME(t0, one, a[0]);
    }

    protected void mont_n_way_inv(long[][][] vec, int n, long[][][] out) {
        int i;
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.fp2copy(vec[0], out[0]);
        for (i = 1; i < n; ++i) {
            this.fp2mul_mont(out[i - 1], vec[i], out[i]);
        }
        this.fp2copy(out[n - 1], t1);
        this.fp2inv_mont_bingcd(t1);
        for (i = n - 1; i >= 1; --i) {
            this.fp2mul_mont(out[i - 1], t1, out[i]);
            this.fp2mul_mont(t1, vec[i], t1);
        }
        this.fp2copy(t1, out[0]);
    }

    protected void fpcopy(long[] a, int aOffset, long[] c) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            c[i] = a[i + aOffset];
        }
    }

    protected void mp2_add(long[][] a, long[][] b, long[][] c) {
        this.mp_add(a[0], b[0], c[0], this.engine.params.NWORDS_FIELD);
        this.mp_add(a[1], b[1], c[1], this.engine.params.NWORDS_FIELD);
    }

    protected void fp2correction(long[][] a) {
        this.fpcorrectionPRIME(a[0]);
        this.fpcorrectionPRIME(a[1]);
    }

    protected int mp_add(long[] a, long[] b, long[] c, int nwords) {
        int carry = 0;
        for (int i = 0; i < nwords; ++i) {
            long tempReg = a[i] + (long)carry;
            c[i] = b[i] + tempReg;
            carry = this.is_digit_lessthan_ct(tempReg, carry) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
        return carry;
    }

    private int mp_add(long[] a, int aOffset, long[] b, long[] c, int cOffset, int nwords) {
        int carry = 0;
        for (int i = 0; i < nwords; ++i) {
            long tempReg = a[i + aOffset] + (long)carry;
            c[i + cOffset] = b[i] + tempReg;
            carry = this.is_digit_lessthan_ct(tempReg, carry) | this.is_digit_lessthan_ct(c[i + cOffset], tempReg);
        }
        return carry;
    }

    private int mp_add(long[] a, int aOffset, long[] b, int bOffset, long[] c, int cOffset, int nwords) {
        int carry = 0;
        for (int i = 0; i < nwords; ++i) {
            long tempReg = a[i + aOffset] + (long)carry;
            c[i + cOffset] = b[i + bOffset] + tempReg;
            carry = this.is_digit_lessthan_ct(tempReg, carry) | this.is_digit_lessthan_ct(c[i + cOffset], tempReg);
        }
        return carry;
    }

    private int is_digit_lessthan_ct(long x, long y) {
        return (int)((x ^ (x ^ y | x - y ^ y)) >>> 63);
    }

    private int is_digit_nonzero_ct(long x) {
        return (int)((x | 0L - x) >>> 63);
    }

    private int is_digit_zero_ct(long x) {
        return 1 ^ this.is_digit_nonzero_ct(x);
    }

    void fp2neg(long[][] a) {
        this.fpnegPRIME(a[0]);
        this.fpnegPRIME(a[1]);
    }

    protected boolean is_felm_zero(long[] x) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            if (x[i] == 0L) continue;
            return false;
        }
        return true;
    }

    private boolean is_felm_lt(long[] x, long[] y) {
        for (int i = this.engine.params.NWORDS_FIELD - 1; i >= 0; --i) {
            if (x[i] + Long.MIN_VALUE < y[i] + Long.MIN_VALUE) {
                return true;
            }
            if (x[i] + Long.MIN_VALUE <= y[i] + Long.MIN_VALUE) continue;
            return false;
        }
        return false;
    }

    private static boolean is_felm_even(long[] x) {
        return (x[0] & 1L) == 0L;
    }

    protected boolean is_sqr_fp2(long[][] a, long[] s) {
        int i;
        long[] a0 = new long[this.engine.params.NWORDS_FIELD];
        long[] a1 = new long[this.engine.params.NWORDS_FIELD];
        long[] z = new long[this.engine.params.NWORDS_FIELD];
        long[] temp = new long[this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(a[0], a0);
        this.fpsqr_mont(a[1], a1);
        this.fpaddPRIME(a0, a1, z);
        this.fpcopy(z, 0, s);
        for (i = 0; i < this.engine.params.OALICE_BITS - 2; ++i) {
            this.fpsqr_mont(s, s);
        }
        for (i = 0; i < this.engine.params.OBOB_EXPON; ++i) {
            this.fpsqr_mont(s, temp);
            this.fpmul_mont(s, temp, s);
        }
        this.fpsqr_mont(s, temp);
        this.fpcorrectionPRIME(temp);
        this.fpcorrectionPRIME(z);
        return Fpx.subarrayEquals(temp, z, this.engine.params.NWORDS_FIELD);
    }

    private void fpinv_mont_bingcd_partial(long[] a, long[] x1, int[] k) {
        long[] u = new long[this.engine.params.NWORDS_FIELD];
        long[] v = new long[this.engine.params.NWORDS_FIELD];
        long[] x2 = new long[this.engine.params.NWORDS_FIELD];
        this.fpcopy(a, 0, u);
        this.fpcopy(this.engine.params.PRIME, 0, v);
        this.fpzero(x1);
        x1[0] = 1L;
        this.fpzero(x2);
        k[0] = 0;
        while (!this.is_felm_zero(v)) {
            int cwords = (k[0] + 1) / 64 + 1;
            if (cwords < this.engine.params.NWORDS_FIELD) {
                if (Fpx.is_felm_even(v)) {
                    this.mp_shiftr1(v);
                    this.mp_shiftl1(x1, cwords);
                } else if (Fpx.is_felm_even(u)) {
                    this.mp_shiftr1(u);
                    this.mp_shiftl1(x2, cwords);
                } else if (!this.is_felm_lt(v, u)) {
                    this.mp_sub(v, u, v, this.engine.params.NWORDS_FIELD);
                    this.mp_shiftr1(v);
                    this.mp_add(x1, x2, x2, cwords);
                    this.mp_shiftl1(x1, cwords);
                } else {
                    this.mp_sub(u, v, u, this.engine.params.NWORDS_FIELD);
                    this.mp_shiftr1(u);
                    this.mp_add(x1, x2, x1, cwords);
                    this.mp_shiftl1(x2, cwords);
                }
            } else if (Fpx.is_felm_even(v)) {
                this.mp_shiftr1(v);
                this.mp_shiftl1(x1, this.engine.params.NWORDS_FIELD);
            } else if (Fpx.is_felm_even(u)) {
                this.mp_shiftr1(u);
                this.mp_shiftl1(x2, this.engine.params.NWORDS_FIELD);
            } else if (!this.is_felm_lt(v, u)) {
                this.mp_sub(v, u, v, this.engine.params.NWORDS_FIELD);
                this.mp_shiftr1(v);
                this.mp_add(x1, x2, x2, this.engine.params.NWORDS_FIELD);
                this.mp_shiftl1(x1, this.engine.params.NWORDS_FIELD);
            } else {
                this.mp_sub(u, v, u, this.engine.params.NWORDS_FIELD);
                this.mp_shiftr1(u);
                this.mp_add(x1, x2, x1, this.engine.params.NWORDS_FIELD);
                this.mp_shiftl1(x2, this.engine.params.NWORDS_FIELD);
            }
            k[0] = k[0] + 1;
        }
        if (this.is_felm_lt(this.engine.params.PRIME, x1)) {
            this.mp_sub(x1, this.engine.params.PRIME, x1, this.engine.params.NWORDS_FIELD);
        }
    }

    private void power2_setup(long[] x, int mark, int nwords) {
        int i;
        for (i = 0; i < nwords; ++i) {
            x[i] = 0L;
        }
        i = 0;
        while (mark >= 0) {
            if (mark < 64) {
                x[i] = 1L << mark;
            }
            mark -= 64;
            ++i;
        }
    }

    private void fpinv_mont_bingcd(long[] a) {
        long[] x = new long[this.engine.params.NWORDS_FIELD];
        long[] t = new long[this.engine.params.NWORDS_FIELD];
        int[] k = new int[1];
        if (this.is_felm_zero(a)) {
            return;
        }
        this.fpinv_mont_bingcd_partial(a, x, k);
        if (k[0] <= this.engine.params.MAXBITS_FIELD) {
            this.fpmul_mont(x, this.engine.params.Montgomery_R2, x);
            k[0] = k[0] + this.engine.params.MAXBITS_FIELD;
        }
        this.fpmul_mont(x, this.engine.params.Montgomery_R2, x);
        this.power2_setup(t, 2 * this.engine.params.MAXBITS_FIELD - k[0], this.engine.params.NWORDS_FIELD);
        this.fpmul_mont(x, t, a);
    }

    protected void fp2inv_mont_bingcd(long[][] a) {
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(a[0], t1[0]);
        this.fpsqr_mont(a[1], t1[1]);
        this.fpaddPRIME(t1[0], t1[1], t1[0]);
        this.fpinv_mont_bingcd(t1[0]);
        this.fpnegPRIME(a[1]);
        this.fpmul_mont(a[0], t1[0], a[0]);
        this.fpmul_mont(a[1], t1[0], a[1]);
    }

    protected void fp2div2(long[][] a, long[][] c) {
        this.fpdiv2_PRIME(a[0], c[0]);
        this.fpdiv2_PRIME(a[1], c[1]);
    }

    private void fpdiv2_PRIME(long[] a, long[] c) {
        int carry = 0;
        long mask = 0L - (a[0] & 1L);
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            long tempReg = a[i] + (long)carry;
            c[i] = (this.engine.params.PRIME[i] & mask) + tempReg;
            carry = this.is_digit_lessthan_ct(tempReg, carry) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
        this.mp_shiftr1(c);
    }

    private void mp_subPRIME_p2(long[] a, long[] b, long[] c) {
        long tempReg;
        int i;
        int borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i] - b[i];
            int borrowReg = this.is_digit_lessthan_ct(a[i], b[i]) | borrow & this.is_digit_zero_ct(tempReg);
            c[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
        borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = c[i] + (long)borrow;
            c[i] = this.engine.params.PRIMEx2[i] + tempReg;
            borrow = this.is_digit_lessthan_ct(tempReg, borrow) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
    }

    private void mp_subPRIME_p4(long[] a, long[] b, long[] c) {
        long tempReg;
        int i;
        int borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i] - b[i];
            int borrowReg = this.is_digit_lessthan_ct(a[i], b[i]) | borrow & this.is_digit_zero_ct(tempReg);
            c[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
        borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = c[i] + (long)borrow;
            c[i] = this.engine.params.PRIMEx4[i] + tempReg;
            borrow = this.is_digit_lessthan_ct(tempReg, borrow) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
    }

    private void digit_x_digit(long a, long b, long[] c) {
        long mask_low = 0xFFFFFFFFL;
        long mask_high = -4294967296L;
        long al = a & mask_low;
        long ah = a >>> 32;
        long bl = b & mask_low;
        long bh = b >>> 32;
        long albl = al * bl;
        long albh = al * bh;
        long ahbl = ah * bl;
        long ahbh = ah * bh;
        c[0] = albl & mask_low;
        long res1 = albl >>> 32;
        long res2 = ahbl & mask_low;
        long res3 = albh & mask_low;
        long temp = res1 + res2 + res3;
        long carry = temp >>> 32;
        c[0] = c[0] ^ temp << 32;
        res1 = ahbl >>> 32;
        res2 = albh >>> 32;
        res3 = ahbh & mask_low;
        temp = res1 + res2 + res3 + carry;
        c[1] = temp & mask_low;
        carry = temp & mask_high;
        c[1] = c[1] ^ (ahbh & mask_high) + carry;
    }

    private void rdc_mont(long[] ma, long[] mc) {
        int carry;
        long tempReg;
        long temp;
        int j;
        int i;
        int count = this.engine.params.PRIME_ZERO_WORDS;
        long t = 0L;
        long u = 0L;
        long v = 0L;
        long[] UV = new long[2];
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            mc[i] = 0L;
        }
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            for (j = 0; j < i; ++j) {
                if (j >= i - this.engine.params.PRIME_ZERO_WORDS + 1) continue;
                this.digit_x_digit(mc[j], this.engine.params.PRIMEp1[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            tempReg = ma[i];
            carry = this.is_digit_lessthan_ct(v += tempReg, tempReg);
            u += (long)carry;
            t += (long)(carry &= this.is_digit_zero_ct(u));
            mc[i] = v;
            v = u;
            u = t;
            t = 0L;
        }
        for (i = this.engine.params.NWORDS_FIELD; i < 2 * this.engine.params.NWORDS_FIELD - 1; ++i) {
            if (count > 0) {
                --count;
            }
            for (j = i - this.engine.params.NWORDS_FIELD + 1; j < this.engine.params.NWORDS_FIELD; ++j) {
                if (j >= this.engine.params.NWORDS_FIELD - count) continue;
                this.digit_x_digit(mc[j], this.engine.params.PRIMEp1[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            tempReg = ma[i];
            carry = this.is_digit_lessthan_ct(v += tempReg, tempReg);
            u += (long)carry;
            t += (long)(carry &= this.is_digit_zero_ct(u));
            mc[i - this.engine.params.NWORDS_FIELD] = v;
            v = u;
            u = t;
            t = 0L;
        }
        tempReg = ma[2 * this.engine.params.NWORDS_FIELD - 1];
        carry = this.is_digit_lessthan_ct(v += tempReg, tempReg);
        mc[this.engine.params.NWORDS_FIELD - 1] = v;
    }

    protected static boolean subarrayEquals(long[] a, long[] b, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected static boolean subarrayEquals(long[][] a, long[][] b, int length) {
        int nwords_feild = b[0].length;
        for (int i = 0; i < length; ++i) {
            if (a[i / nwords_feild][i % nwords_feild] == b[i / nwords_feild][i % nwords_feild]) continue;
            return false;
        }
        return true;
    }

    protected static boolean subarrayEquals(long[][] a, long[][] b, int bOffset, int length) {
        int nwords_feild = b[0].length;
        for (int i = 0; i < length; ++i) {
            if (a[i / nwords_feild][i % nwords_feild] == b[(i + bOffset) / nwords_feild][(i + bOffset) % nwords_feild]) continue;
            return false;
        }
        return true;
    }

    protected static boolean subarrayEquals(long[][] a, long[] b, int bOffset, int length) {
        int nwords_field = a[0].length;
        for (int i = 0; i < length; ++i) {
            if (a[i / nwords_field][i % nwords_field] == b[i + bOffset]) continue;
            return false;
        }
        return true;
    }

    void sqrt_Fp2(long[][] u, long[][] y) {
        int i;
        long[] t0 = new long[this.engine.params.NWORDS_FIELD];
        long[] t1 = new long[this.engine.params.NWORDS_FIELD];
        long[] t2 = new long[this.engine.params.NWORDS_FIELD];
        long[] t3 = new long[this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(u[0], t0);
        this.fpsqr_mont(u[1], t1);
        this.fpaddPRIME(t0, t1, t0);
        this.fpcopy(t0, 0, t1);
        for (i = 0; i < this.engine.params.OALICE_BITS - 2; ++i) {
            this.fpsqr_mont(t1, t1);
        }
        for (i = 0; i < this.engine.params.OBOB_EXPON; ++i) {
            this.fpsqr_mont(t1, t0);
            this.fpmul_mont(t1, t0, t1);
        }
        this.fpaddPRIME(u[0], t1, t0);
        this.fpdiv2_PRIME(t0, t0);
        this.fpcopy(t0, 0, t2);
        this.fpinv_chain_mont(t2);
        this.fpmul_mont(t0, t2, t1);
        this.fpmul_mont(t2, u[1], t2);
        this.fpdiv2_PRIME(t2, t2);
        this.fpsqr_mont(t1, t3);
        this.fpcorrectionPRIME(t0);
        this.fpcorrectionPRIME(t3);
        if (Fpx.subarrayEquals(t0, t3, this.engine.params.NWORDS_FIELD)) {
            this.fpcopy(t1, 0, y[0]);
            this.fpcopy(t2, 0, y[1]);
        } else {
            this.fpnegPRIME(t1);
            this.fpcopy(t2, 0, y[0]);
            this.fpcopy(t1, 0, y[1]);
        }
    }

    protected void fp2sqr_mont(long[][] a, long[][] c) {
        long[] t1 = new long[this.engine.params.NWORDS_FIELD];
        long[] t2 = new long[this.engine.params.NWORDS_FIELD];
        long[] t3 = new long[this.engine.params.NWORDS_FIELD];
        this.mp_add(a[0], a[1], t1, this.engine.params.NWORDS_FIELD);
        this.mp_subPRIME_p4(a[0], a[1], t2);
        this.mp_add(a[0], a[0], t3, this.engine.params.NWORDS_FIELD);
        this.fpmul_mont(t1, t2, c[0]);
        this.fpmul_mont(t3, a[1], c[1]);
    }

    protected void fpaddPRIME(long[] a, long[] b, long[] c) {
        long tempReg;
        int i;
        int carry = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i] + (long)carry;
            c[i] = b[i] + tempReg;
            carry = this.is_digit_lessthan_ct(tempReg, carry) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
        carry = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = c[i] - this.engine.params.PRIMEx2[i];
            int borrowReg = this.is_digit_lessthan_ct(c[i], this.engine.params.PRIMEx2[i]) | carry & this.is_digit_zero_ct(tempReg);
            c[i] = tempReg - (long)carry;
            carry = borrowReg;
        }
        long mask = 0 - carry;
        carry = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = c[i] + (long)carry;
            c[i] = (this.engine.params.PRIMEx2[i] & mask) + tempReg;
            carry = this.is_digit_lessthan_ct(tempReg, carry) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
    }

    protected void cube_Fp2_cycl(long[][] a, long[] one) {
        long[] t0 = new long[this.engine.params.NWORDS_FIELD];
        this.fpaddPRIME(a[0], a[0], t0);
        this.fpsqr_mont(t0, t0);
        this.fpsubPRIME(t0, one, t0);
        this.fpmul_mont(a[1], t0, a[1]);
        this.fpsubPRIME(t0, one, t0);
        this.fpsubPRIME(t0, one, t0);
        this.fpmul_mont(a[0], t0, a[0]);
    }

    protected void fpsubPRIME(long[] a, long[] b, int bOffset, long[] c) {
        long tempReg;
        int i;
        int borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i] - b[i + bOffset];
            int borrowReg = this.is_digit_lessthan_ct(a[i], b[i + bOffset]) | borrow & this.is_digit_zero_ct(tempReg);
            c[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
        long mask = 0 - borrow;
        borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = c[i] + (long)borrow;
            c[i] = (this.engine.params.PRIMEx2[i] & mask) + tempReg;
            borrow = this.is_digit_lessthan_ct(tempReg, borrow) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
    }

    protected void fpsubPRIME(long[] a, int aOffset, long[] b, long[] c) {
        long tempReg;
        int i;
        int borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i + aOffset] - b[i];
            int borrowReg = this.is_digit_lessthan_ct(a[i + aOffset], b[i]) | borrow & this.is_digit_zero_ct(tempReg);
            c[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
        long mask = 0 - borrow;
        borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = c[i] + (long)borrow;
            c[i] = (this.engine.params.PRIMEx2[i] & mask) + tempReg;
            borrow = this.is_digit_lessthan_ct(tempReg, borrow) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
    }

    protected void fpsubPRIME(long[] a, long[] b, long[] c) {
        long tempReg;
        int i;
        int borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i] - b[i];
            int borrowReg = this.is_digit_lessthan_ct(a[i], b[i]) | borrow & this.is_digit_zero_ct(tempReg);
            c[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
        long mask = 0 - borrow;
        borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = c[i] + (long)borrow;
            c[i] = (this.engine.params.PRIMEx2[i] & mask) + tempReg;
            borrow = this.is_digit_lessthan_ct(tempReg, borrow) | this.is_digit_lessthan_ct(c[i], tempReg);
        }
    }

    protected void fpnegPRIME(long[] a) {
        int borrow = 0;
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            long tempReg = this.engine.params.PRIMEx2[i] - a[i];
            int borrowReg = this.is_digit_lessthan_ct(this.engine.params.PRIMEx2[i], a[i]) | borrow & this.is_digit_zero_ct(tempReg);
            a[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
    }

    protected void from_fp2mont(long[][] ma, long[][] c) {
        this.from_mont(ma[0], c[0]);
        this.from_mont(ma[1], c[1]);
    }

    protected void fp2_encode(long[][] x, byte[] enc, int encOffset) {
        long[][] t = new long[2][this.engine.params.NWORDS_FIELD];
        this.from_fp2mont(x, t);
        this.encode_to_bytes(t[0], enc, encOffset, this.engine.params.FP2_ENCODED_BYTES / 2);
        this.encode_to_bytes(t[1], enc, encOffset + this.engine.params.FP2_ENCODED_BYTES / 2, this.engine.params.FP2_ENCODED_BYTES / 2);
    }

    protected void fp2_decode(byte[] x, long[][] dec, int xOffset) {
        this.decode_to_digits(x, xOffset, dec[0], this.engine.params.FP2_ENCODED_BYTES / 2, this.engine.params.NWORDS_FIELD);
        this.decode_to_digits(x, xOffset + this.engine.params.FP2_ENCODED_BYTES / 2, dec[1], this.engine.params.FP2_ENCODED_BYTES / 2, this.engine.params.NWORDS_FIELD);
        this.to_fp2mont(dec, dec);
    }

    protected void to_Montgomery_mod_order(long[] a, long[] mc, long[] order, long[] Montgomery_rprime, long[] Montgomery_Rprime) {
        this.Montgomery_multiply_mod_order(a, Montgomery_Rprime, mc, order, Montgomery_rprime);
    }

    protected void Montgomery_multiply_mod_order(long[] ma, long[] mb, long[] mc, long[] order, long[] Montgomery_rprime) {
        int i;
        int cout = 0;
        int bout = 0;
        long[] P = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] Q = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] temp = new long[2 * this.engine.params.NWORDS_ORDER];
        this.multiply(ma, mb, P, this.engine.params.NWORDS_ORDER);
        this.multiply(P, Montgomery_rprime, Q, this.engine.params.NWORDS_ORDER);
        this.multiply(Q, order, temp, this.engine.params.NWORDS_ORDER);
        cout = this.mp_add(P, temp, temp, 2 * this.engine.params.NWORDS_ORDER);
        for (i = 0; i < this.engine.params.NWORDS_ORDER; ++i) {
            mc[i] = temp[this.engine.params.NWORDS_ORDER + i];
        }
        bout = this.mp_sub(mc, order, mc, this.engine.params.NWORDS_ORDER);
        long mask = cout - bout;
        for (i = 0; i < this.engine.params.NWORDS_ORDER; ++i) {
            temp[i] = order[i] & mask;
        }
        this.mp_add(mc, temp, mc, this.engine.params.NWORDS_ORDER);
    }

    protected void inv_mod_orderA(long[] a, long[] c) {
        int s = 0;
        long[] am1 = new long[this.engine.params.NWORDS_ORDER];
        long[] tmp1 = new long[this.engine.params.NWORDS_ORDER];
        long[] tmp2 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] one = new long[this.engine.params.NWORDS_ORDER];
        long[] order = new long[this.engine.params.NWORDS_ORDER];
        long mask = -1L >>> this.engine.params.NBITS_ORDER - this.engine.params.OALICE_BITS;
        order[this.engine.params.NWORDS_ORDER - 1] = 1L << 64 - (this.engine.params.NBITS_ORDER - this.engine.params.OALICE_BITS);
        one[0] = 1L;
        this.mp_sub(a, one, am1, this.engine.params.NWORDS_ORDER);
        if ((a[0] & 1L) == 0L || this.is_zero(am1, this.engine.params.NWORDS_ORDER)) {
            this.copy_words(a, c, this.engine.params.NWORDS_ORDER);
            int n = this.engine.params.NWORDS_ORDER - 1;
            c[n] = c[n] & mask;
        } else {
            this.mp_sub(order, am1, c, this.engine.params.NWORDS_ORDER);
            this.mp_add(c, one, c, this.engine.params.NWORDS_ORDER);
            this.copy_words(am1, tmp1, this.engine.params.NWORDS_ORDER);
            while ((tmp1[0] & 1L) == 0L) {
                ++s;
                this.mp_shiftr1(tmp1, this.engine.params.NWORDS_ORDER);
            }
            int f = this.engine.params.OALICE_BITS / s;
            for (int i = 1; i < f; i <<= 1) {
                this.multiply(am1, am1, tmp2, this.engine.params.NWORDS_ORDER);
                this.copy_words(tmp2, am1, this.engine.params.NWORDS_ORDER);
                int n = this.engine.params.NWORDS_ORDER - 1;
                am1[n] = am1[n] & mask;
                this.mp_add(am1, one, tmp1, this.engine.params.NWORDS_ORDER);
                int n2 = this.engine.params.NWORDS_ORDER - 1;
                tmp1[n2] = tmp1[n2] & mask;
                this.multiply(c, tmp1, tmp2, this.engine.params.NWORDS_ORDER);
                this.copy_words(tmp2, c, this.engine.params.NWORDS_ORDER);
                int n3 = this.engine.params.NWORDS_ORDER - 1;
                c[n3] = c[n3] & mask;
            }
        }
    }

    protected void multiply(long[] a, long[] b, long[] c, int nwords) {
        long temp;
        int j;
        int i;
        long t = 0L;
        long u = 0L;
        long v = 0L;
        long[] UV = new long[2];
        for (i = 0; i < nwords; ++i) {
            for (j = 0; j <= i; ++j) {
                this.digit_x_digit(a[j], b[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            c[i] = v;
            v = u;
            u = t;
            t = 0L;
        }
        for (i = nwords; i < 2 * nwords - 1; ++i) {
            for (j = i - nwords + 1; j < nwords; ++j) {
                this.digit_x_digit(a[j], b[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            c[i] = v;
            v = u;
            u = t;
            t = 0L;
        }
        c[2 * nwords - 1] = v;
    }

    private boolean is_zero_mod_order(long[] x) {
        for (int i = 0; i < this.engine.params.NWORDS_ORDER; ++i) {
            if (x[i] == 0L) continue;
            return false;
        }
        return true;
    }

    private boolean is_even_mod_order(long[] x) {
        return (x[0] & 1L ^ 1L) == 1L;
    }

    private boolean is_lt_mod_order(long[] x, long[] y) {
        for (int i = this.engine.params.NWORDS_ORDER - 1; i >= 0; --i) {
            if (x[i] + Long.MIN_VALUE < y[i] + Long.MIN_VALUE) {
                return true;
            }
            if (x[i] + Long.MIN_VALUE <= y[i] + Long.MIN_VALUE) continue;
            return false;
        }
        return false;
    }

    private boolean is_zero(long[] a, int nwords) {
        for (int i = 0; i < nwords; ++i) {
            if (a[i] == 0L) continue;
            return false;
        }
        return true;
    }

    private void Montgomery_inversion_mod_order_bingcd_partial(long[] a, long[] x1, int[] k, long[] order) {
        long[] u = new long[this.engine.params.NWORDS_ORDER];
        long[] v = new long[this.engine.params.NWORDS_ORDER];
        long[] x2 = new long[this.engine.params.NWORDS_ORDER];
        this.copy_words(a, u, this.engine.params.NWORDS_ORDER);
        this.copy_words(order, v, this.engine.params.NWORDS_ORDER);
        this.copy_words(x2, x1, this.engine.params.NWORDS_ORDER);
        x1[0] = 1L;
        k[0] = 0;
        while (!this.is_zero_mod_order(v)) {
            int cwords = (k[0] + 1) / 64 + 1;
            if (cwords < this.engine.params.NWORDS_ORDER) {
                if (this.is_even_mod_order(v)) {
                    this.mp_shiftr1(v, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftl1(x1, cwords);
                } else if (this.is_even_mod_order(u)) {
                    this.mp_shiftr1(u, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftl1(x2, cwords);
                } else if (!this.is_lt_mod_order(v, u)) {
                    this.mp_sub(v, u, v, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftr1(v, this.engine.params.NWORDS_ORDER);
                    this.mp_add(x1, x2, x2, cwords);
                    this.mp_shiftl1(x1, cwords);
                } else {
                    this.mp_sub(u, v, u, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftr1(u, this.engine.params.NWORDS_ORDER);
                    this.mp_add(x1, x2, x1, cwords);
                    this.mp_shiftl1(x2, cwords);
                }
            } else if (this.is_even_mod_order(v)) {
                this.mp_shiftr1(v, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(x1, this.engine.params.NWORDS_ORDER);
            } else if (this.is_even_mod_order(u)) {
                this.mp_shiftr1(u, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(x2, this.engine.params.NWORDS_ORDER);
            } else if (!this.is_lt_mod_order(v, u)) {
                this.mp_sub(v, u, v, this.engine.params.NWORDS_ORDER);
                this.mp_shiftr1(v, this.engine.params.NWORDS_ORDER);
                this.mp_add(x1, x2, x2, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(x1, this.engine.params.NWORDS_ORDER);
            } else {
                this.mp_sub(u, v, u, this.engine.params.NWORDS_ORDER);
                this.mp_shiftr1(u, this.engine.params.NWORDS_ORDER);
                this.mp_add(x1, x2, x1, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(x2, this.engine.params.NWORDS_ORDER);
            }
            k[0] = k[0] + 1;
        }
        if (this.is_lt_mod_order(order, x1)) {
            this.mp_sub(x1, order, x1, this.engine.params.NWORDS_ORDER);
        }
    }

    protected void Montgomery_inversion_mod_order_bingcd(long[] a, long[] c, long[] order, long[] Montgomery_rprime, long[] Montgomery_Rprime) {
        long[] x = new long[this.engine.params.NWORDS_ORDER];
        long[] t = new long[this.engine.params.NWORDS_ORDER];
        int[] k = new int[1];
        if (this.is_zero(a, this.engine.params.NWORDS_ORDER)) {
            this.copy_words(t, c, this.engine.params.NWORDS_ORDER);
            return;
        }
        this.Montgomery_inversion_mod_order_bingcd_partial(a, x, k, order);
        if (k[0] <= this.engine.params.NBITS_ORDER) {
            this.Montgomery_multiply_mod_order(x, Montgomery_Rprime, x, order, Montgomery_rprime);
            k[0] = k[0] + this.engine.params.NBITS_ORDER;
        }
        this.Montgomery_multiply_mod_order(x, Montgomery_Rprime, x, order, Montgomery_rprime);
        this.power2_setup(t, 2 * this.engine.params.NBITS_ORDER - k[0], this.engine.params.NWORDS_ORDER);
        this.Montgomery_multiply_mod_order(x, t, c, order, Montgomery_rprime);
    }

    protected void from_Montgomery_mod_order(long[] ma, long[] c, long[] order, long[] Montgomery_rprime) {
        long[] one = new long[this.engine.params.NWORDS_ORDER];
        one[0] = 1L;
        this.Montgomery_multiply_mod_order(ma, one, c, order, Montgomery_rprime);
    }

    protected int mod3(long[] a) {
        int r = 0;
        int[] val = Pack.littleEndianToInt(Pack.longToLittleEndian(a), 0, a.length * 2);
        for (int i = 2 * this.engine.params.NWORDS_ORDER - 1; i >= 0; --i) {
            long temp = (long)r << 32 | (long)val[i] & 0xFFFFFFFFL;
            r = (int)(temp % 3L);
        }
        return r;
    }

    protected void to_fp2mont(long[][] a, long[][] mc) {
        this.to_mont(a[0], mc[0]);
        this.to_mont(a[1], mc[1]);
    }

    private void to_mont(long[] a, long[] mc) {
        this.fpmul_mont(a, this.engine.params.Montgomery_R2, mc);
    }

    protected void fpcorrectionPRIME(long[] a) {
        long tempReg;
        int i;
        int borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i] - this.engine.params.PRIME[i];
            int borrowReg = this.is_digit_lessthan_ct(a[i], this.engine.params.PRIME[i]) | borrow & this.is_digit_zero_ct(tempReg);
            a[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
        long mask = 0 - borrow;
        borrow = 0;
        for (i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            tempReg = a[i] + (long)borrow;
            a[i] = (this.engine.params.PRIME[i] & mask) + tempReg;
            borrow = this.is_digit_lessthan_ct(tempReg, borrow) | this.is_digit_lessthan_ct(a[i], tempReg);
        }
    }

    protected byte cmp_f2elm(long[][] x, long[][] y) {
        long[][] a = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] b = new long[2][this.engine.params.NWORDS_FIELD];
        int r = 0;
        this.fp2copy(x, a);
        this.fp2copy(y, b);
        this.fp2correction(a);
        this.fp2correction(b);
        for (int i = this.engine.params.NWORDS_FIELD - 1; i >= 0; --i) {
            r = (byte)((long)r | (a[0][i] ^ b[0][i] | a[1][i] ^ b[1][i]));
        }
        return (byte)(-r >>> 7);
    }

    protected void encode_to_bytes(long[] x, byte[] enc, int encOffset, int nbytes) {
        byte[] test = new byte[nbytes * 4 + 7 & 0xFFFFFFF8];
        Pack.longToLittleEndian(x, test, 0);
        System.arraycopy(test, 0, enc, encOffset, nbytes);
    }

    protected void decode_to_digits(byte[] x, int xOffset, long[] dec, int nbytes, int ndigits) {
        dec[ndigits - 1] = 0L;
        byte[] temp = new byte[nbytes + 7 & 0xFFFFFFF8];
        System.arraycopy(x, xOffset, temp, 0, nbytes);
        Pack.littleEndianToLong(temp, 0, dec);
    }

    protected void fp2_conj(long[][] v, long[][] r) {
        this.fpcopy(v[0], 0, r[0]);
        this.fpcopy(v[1], 0, r[1]);
        if (!this.is_felm_zero(r[1])) {
            this.fpnegPRIME(r[1]);
        }
    }

    private void from_mont(long[] ma, long[] c) {
        long[] one = new long[this.engine.params.NWORDS_FIELD];
        one[0] = 1L;
        this.fpmul_mont(ma, one, c);
        this.fpcorrectionPRIME(c);
    }

    private void mp_shiftr1(long[] x) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD - 1; ++i) {
            x[i] = x[i] >>> 1 ^ x[i + 1] << 63;
        }
        int n = this.engine.params.NWORDS_FIELD - 1;
        x[n] = x[n] >>> 1;
    }

    private void mp_shiftr1(long[] x, int nwords) {
        for (int i = 0; i < nwords - 1; ++i) {
            x[i] = x[i] >>> 1 ^ x[i + 1] << 63;
        }
        int n = nwords - 1;
        x[n] = x[n] >>> 1;
    }

    protected void fp2copy(long[][] a, long[][] c) {
        this.fpcopy(a[0], 0, c[0]);
        this.fpcopy(a[1], 0, c[1]);
    }

    protected void fp2copy(long[][] a, int aOffset, long[][] c) {
        this.fpcopy(a[0 + aOffset], 0, c[0]);
        this.fpcopy(a[1 + aOffset], 0, c[1]);
    }

    protected void fp2copy(long[] a, int aOffset, long[][] c) {
        this.fpcopy(a, aOffset, c[0]);
        this.fpcopy(a, aOffset + this.engine.params.NWORDS_FIELD, c[1]);
    }

    protected void fpzero(long[] a) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            a[i] = 0L;
        }
    }

    protected void mp2_sub_p2(long[][] a, long[][] b, long[][] c) {
        this.mp_subPRIME_p2(a[0], b[0], c[0]);
        this.mp_subPRIME_p2(a[1], b[1], c[1]);
    }

    protected void mp_mul(long[] a, long[] b, long[] c, int nwords) {
        long temp;
        int j;
        int i;
        long t = 0L;
        long u = 0L;
        long v = 0L;
        long[] UV = new long[2];
        for (i = 0; i < nwords; ++i) {
            for (j = 0; j <= i; ++j) {
                this.digit_x_digit(a[j], b[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            c[i] = v;
            v = u;
            u = t;
            t = 0L;
        }
        for (i = nwords; i < 2 * nwords - 1; ++i) {
            for (j = i - nwords + 1; j < nwords; ++j) {
                this.digit_x_digit(a[j], b[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            c[i] = v;
            v = u;
            u = t;
            t = 0L;
        }
        c[2 * nwords - 1] = v;
    }

    protected void mp_mul(long[] a, int aOffset, long[] b, long[] c, int nwords) {
        long temp;
        int j;
        int i;
        long t = 0L;
        long u = 0L;
        long v = 0L;
        long[] UV = new long[2];
        for (i = 0; i < nwords; ++i) {
            for (j = 0; j <= i; ++j) {
                this.digit_x_digit(a[j + aOffset], b[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            c[i] = v;
            v = u;
            u = t;
            t = 0L;
        }
        for (i = nwords; i < 2 * nwords - 1; ++i) {
            for (j = i - nwords + 1; j < nwords; ++j) {
                this.digit_x_digit(a[j + aOffset], b[i - j], UV);
                temp = UV[0];
                v += temp;
                temp = UV[1] + (long)this.is_digit_lessthan_ct(v, temp);
                t += (long)this.is_digit_lessthan_ct(u += temp, temp);
            }
            c[i] = v;
            v = u;
            u = t;
            t = 0L;
        }
        c[2 * nwords - 1] = v;
    }

    protected void fp2mul_mont(long[][] a, long[][] b, long[][] c) {
        long[] t1 = new long[this.engine.params.NWORDS_FIELD];
        long[] t2 = new long[this.engine.params.NWORDS_FIELD];
        long[] tt1 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] tt2 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] tt3 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_add(a[0], a[1], t1, this.engine.params.NWORDS_FIELD);
        this.mp_add(b[0], b[1], t2, this.engine.params.NWORDS_FIELD);
        this.mp_mul(a[0], b[0], tt1, this.engine.params.NWORDS_FIELD);
        this.mp_mul(a[1], b[1], tt2, this.engine.params.NWORDS_FIELD);
        this.mp_mul(t1, t2, tt3, this.engine.params.NWORDS_FIELD);
        this.mp_dblsubfast(tt1, tt2, tt3);
        this.mp_subaddfast(tt1, tt2, tt1);
        this.rdc_mont(tt3, c[1]);
        this.rdc_mont(tt1, c[0]);
    }

    protected void fp2mul_mont(long[][] a, long[][] b, int bOffset, long[][] c) {
        long[] t1 = new long[this.engine.params.NWORDS_FIELD];
        long[] t2 = new long[this.engine.params.NWORDS_FIELD];
        long[] tt1 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] tt2 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] tt3 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_add(a[0], a[1], t1, this.engine.params.NWORDS_FIELD);
        this.mp_add(b[0 + bOffset], b[bOffset + 1], t2, this.engine.params.NWORDS_FIELD);
        this.mp_mul(a[0], b[bOffset + 0], tt1, this.engine.params.NWORDS_FIELD);
        this.mp_mul(a[1], b[bOffset + 1], tt2, this.engine.params.NWORDS_FIELD);
        this.mp_mul(t1, t2, tt3, this.engine.params.NWORDS_FIELD);
        this.mp_dblsubfast(tt1, tt2, tt3);
        this.mp_subaddfast(tt1, tt2, tt1);
        this.rdc_mont(tt3, c[1]);
        this.rdc_mont(tt1, c[0]);
    }

    protected void fp2mul_mont(long[][] a, long[] b, int bOffset, long[][] c) {
        long[] t1 = new long[this.engine.params.NWORDS_FIELD];
        long[] t2 = new long[this.engine.params.NWORDS_FIELD];
        long[] tt1 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] tt2 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] tt3 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_add(a[0], a[1], t1, this.engine.params.NWORDS_FIELD);
        this.mp_add(b, bOffset, b, bOffset + this.engine.params.NWORDS_FIELD, t2, 0, this.engine.params.NWORDS_FIELD);
        this.mp_mul(b, bOffset, a[0], tt1, this.engine.params.NWORDS_FIELD);
        this.mp_mul(b, bOffset + this.engine.params.NWORDS_FIELD, a[1], tt2, this.engine.params.NWORDS_FIELD);
        this.mp_mul(t1, t2, tt3, this.engine.params.NWORDS_FIELD);
        this.mp_dblsubfast(tt1, tt2, tt3);
        this.mp_subaddfast(tt1, tt2, tt1);
        this.rdc_mont(tt3, c[1]);
        this.rdc_mont(tt1, c[0]);
    }

    private void mp_dblsubfast(long[] a, long[] b, long[] c) {
        this.mp_sub(c, a, c, 2 * this.engine.params.NWORDS_FIELD);
        this.mp_sub(c, b, c, 2 * this.engine.params.NWORDS_FIELD);
    }

    protected int mp_sub(long[] a, long[] b, long[] c, int nwords) {
        int borrow = 0;
        for (int i = 0; i < nwords; ++i) {
            long tempReg = a[i] - b[i];
            int borrowReg = this.is_digit_lessthan_ct(a[i], b[i]) | borrow & this.is_digit_zero_ct(tempReg);
            c[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
        return borrow;
    }

    protected boolean is_orderelm_lt(long[] x, long[] y) {
        for (int i = this.engine.params.NWORDS_ORDER - 1; i >= 0; --i) {
            if (x[i] + Long.MIN_VALUE < y[i] + Long.MIN_VALUE) {
                return true;
            }
            if (x[i] + Long.MIN_VALUE <= y[i] + Long.MIN_VALUE) continue;
            return false;
        }
        return false;
    }

    private void mp_subaddfast(long[] a, long[] b, long[] c) {
        long[] t1 = new long[this.engine.params.NWORDS_FIELD];
        long mask = 0L - (long)this.mp_sub(a, b, c, 2 * this.engine.params.NWORDS_FIELD);
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            t1[i] = this.engine.params.PRIME[i] & mask;
        }
        this.mp_add(c, this.engine.params.NWORDS_FIELD, t1, c, this.engine.params.NWORDS_FIELD, this.engine.params.NWORDS_FIELD);
    }

    protected void fpsqr_mont(long[] ma, long[] mc) {
        long[] temp = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_mul(ma, ma, temp, this.engine.params.NWORDS_FIELD);
        this.rdc_mont(temp, mc);
    }

    private void fpinv_mont(long[] a) {
        long[] tt = new long[this.engine.params.NWORDS_FIELD];
        this.fpcopy(a, 0, tt);
        this.fpinv_chain_mont(tt);
        this.fpsqr_mont(tt, tt);
        this.fpsqr_mont(tt, tt);
        this.fpmul_mont(a, tt, a);
    }

    protected void fp2inv_mont(long[][] a) {
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(a[0], t1[0]);
        this.fpsqr_mont(a[1], t1[1]);
        this.fpaddPRIME(t1[0], t1[1], t1[0]);
        this.fpinv_mont(t1[0]);
        this.fpnegPRIME(a[1]);
        this.fpmul_mont(a[0], t1[0], a[0]);
        this.fpmul_mont(a[1], t1[0], a[1]);
    }

    protected void mul3(byte[] a) {
        long[] temp1 = new long[this.engine.params.NWORDS_ORDER];
        long[] temp2 = new long[this.engine.params.NWORDS_ORDER];
        this.decode_to_digits(a, 0, temp1, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.mp_add(temp1, temp1, temp2, this.engine.params.NWORDS_ORDER);
        this.mp_add(temp1, temp2, temp1, this.engine.params.NWORDS_ORDER);
        this.encode_to_bytes(temp1, a, 0, this.engine.params.SECRETKEY_B_BYTES);
    }

    protected byte ct_compare(byte[] a, byte[] b, int len) {
        int r = 0;
        for (int i = 0; i < len; ++i) {
            r = (byte)(r | a[i] ^ b[i]);
        }
        return (byte)(-r >>> 7);
    }

    protected void ct_cmov(byte[] r, byte[] a, int len, byte selector) {
        for (int i = 0; i < len; ++i) {
            int n = i;
            r[n] = (byte)(r[n] ^ selector & (a[i] ^ r[i]));
        }
    }

    protected void copy_words(long[] a, long[] c, int nwords) {
        for (int i = 0; i < nwords; ++i) {
            c[i] = a[i];
        }
    }

    protected void fp2shl(long[][] a, int k, long[][] c) {
        this.fp2copy(a, c);
        for (int j = 0; j < k; ++j) {
            this.fp2add(c, c, c);
        }
    }

    protected void copy_words(PointProj a, PointProj c) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            c.X[0][i] = a.X[0][i];
            c.X[1][i] = a.X[1][i];
            c.Z[0][i] = a.Z[0][i];
            c.Z[1][i] = a.Z[1][i];
        }
    }

    void Montgomery_neg(long[] a, long[] order) {
        int borrow = 0;
        for (int i = 0; i < this.engine.params.NWORDS_ORDER; ++i) {
            long tempReg = order[i] - a[i];
            int borrowReg = this.is_digit_lessthan_ct(order[i], a[i]) | borrow & this.is_digit_zero_ct(tempReg);
            a[i] = tempReg - (long)borrow;
            borrow = borrowReg;
        }
    }

    protected void fp2add(long[][] a, long[][] b, long[][] c) {
        this.fpaddPRIME(a[0], b[0], c[0]);
        this.fpaddPRIME(a[1], b[1], c[1]);
    }

    protected void fp2sub(long[][] a, long[][] b, long[][] c) {
        this.fpsubPRIME(a[0], b[0], c[0]);
        this.fpsubPRIME(a[1], b[1], c[1]);
    }

    protected void fpmul_mont(long[] ma, long[] mb, long[] mc) {
        long[] temp = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_mul(ma, mb, temp, this.engine.params.NWORDS_FIELD);
        this.rdc_mont(temp, mc);
    }

    protected void fpmul_mont(long[] ma, int maOffset, long[] mb, long[] mc) {
        long[] temp = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_mul(ma, maOffset, mb, temp, this.engine.params.NWORDS_FIELD);
        this.rdc_mont(temp, mc);
    }

    private void fpinv_chain_mont(long[] a) {
        long[] tt;
        long[][] t;
        int j;
        int i;
        if (this.engine.params.NBITS_FIELD == 434) {
            long[] tt2 = new long[this.engine.params.NWORDS_FIELD];
            long[][] t2 = new long[31][this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(a, tt2);
            this.fpmul_mont(a, tt2, t2[0]);
            for (i = 0; i <= 29; ++i) {
                this.fpmul_mont(t2[i], tt2, t2[i + 1]);
            }
            this.fpcopy(a, 0, tt2);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[5], tt2, tt2);
            for (i = 0; i < 10; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[14], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[3], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[23], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[13], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[24], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[7], tt2, tt2);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[12], tt2, tt2);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[30], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[1], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[30], tt2, tt2);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[21], tt2, tt2);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[2], tt2, tt2);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[19], tt2, tt2);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[1], tt2, tt2);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[24], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[26], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[16], tt2, tt2);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[10], tt2, tt2);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[6], tt2, tt2);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[0], tt2, tt2);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[20], tt2, tt2);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[9], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[25], tt2, tt2);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[30], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[26], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(a, tt2, tt2);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[28], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[6], tt2, tt2);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[10], tt2, tt2);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt2, tt2);
            }
            this.fpmul_mont(t2[22], tt2, tt2);
            for (j = 0; j < 35; ++j) {
                for (i = 0; i < 6; ++i) {
                    this.fpsqr_mont(tt2, tt2);
                }
                this.fpmul_mont(t2[30], tt2, tt2);
            }
            this.fpcopy(tt2, 0, a);
        }
        if (this.engine.params.NBITS_FIELD == 503) {
            t = new long[15][this.engine.params.NWORDS_FIELD];
            tt = new long[this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(a, tt);
            this.fpmul_mont(a, tt, t[0]);
            for (i = 0; i <= 13; ++i) {
                this.fpmul_mont(t[i], tt, t[i + 1]);
            }
            this.fpcopy(a, 0, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(a, tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[8], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[9], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[0], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(a, tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[8], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(a, tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[10], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[0], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[10], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[10], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[3], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 12; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[12], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[8], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[12], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[11], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[14], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[14], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[8], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(a, tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[4], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[7], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(a, tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[0], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[11], tt, tt);
            for (i = 0; i < 5; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[13], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[1], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[10], tt, tt);
            for (j = 0; j < 49; ++j) {
                for (i = 0; i < 5; ++i) {
                    this.fpsqr_mont(tt, tt);
                }
                this.fpmul_mont(t[14], tt, tt);
            }
            this.fpcopy(tt, 0, a);
        }
        if (this.engine.params.NBITS_FIELD == 610) {
            t = new long[31][this.engine.params.NWORDS_FIELD];
            tt = new long[this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(a, tt);
            this.fpmul_mont(a, tt, t[0]);
            for (i = 0; i <= 29; ++i) {
                this.fpmul_mont(t[i], tt, t[i + 1]);
            }
            this.fpcopy(a, 0, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[30], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[25], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[28], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[7], tt, tt);
            for (i = 0; i < 11; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[11], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(a, tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[0], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[3], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[16], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[24], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[28], tt, tt);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[16], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[4], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[3], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[20], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[11], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[14], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[15], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[0], tt, tt);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[15], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[19], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[9], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[27], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[28], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[29], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[1], tt, tt);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[3], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[30], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[25], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[28], tt, tt);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[22], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[3], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[22], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[7], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[9], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[4], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[20], tt, tt);
            for (i = 0; i < 11; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[10], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[26], tt, tt);
            for (i = 0; i < 11; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (j = 0; j < 50; ++j) {
                for (i = 0; i < 6; ++i) {
                    this.fpsqr_mont(tt, tt);
                }
                this.fpmul_mont(t[30], tt, tt);
            }
            this.fpcopy(tt, 0, a);
        }
        if (this.engine.params.NBITS_FIELD == 751) {
            t = new long[27][this.engine.params.NWORDS_FIELD];
            tt = new long[this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(a, tt);
            this.fpmul_mont(a, tt, t[0]);
            this.fpmul_mont(t[0], tt, t[1]);
            this.fpmul_mont(t[1], tt, t[2]);
            this.fpmul_mont(t[2], tt, t[3]);
            this.fpmul_mont(t[3], tt, t[3]);
            for (i = 3; i <= 8; ++i) {
                this.fpmul_mont(t[i], tt, t[i + 1]);
            }
            this.fpmul_mont(t[9], tt, t[9]);
            for (i = 9; i <= 20; ++i) {
                this.fpmul_mont(t[i], tt, t[i + 1]);
            }
            this.fpmul_mont(t[21], tt, t[21]);
            for (i = 21; i <= 24; ++i) {
                this.fpmul_mont(t[i], tt, t[i + 1]);
            }
            this.fpmul_mont(t[25], tt, t[25]);
            this.fpmul_mont(t[25], tt, t[26]);
            this.fpcopy(a, 0, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[20], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[24], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[11], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[8], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[23], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 9; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 10; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[15], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[13], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[26], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[20], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[11], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[10], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[14], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[4], tt, tt);
            for (i = 0; i < 10; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[18], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[1], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[22], tt, tt);
            for (i = 0; i < 10; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[6], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[24], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[9], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[18], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[17], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(a, tt, tt);
            for (i = 0; i < 10; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[16], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[7], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[0], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[12], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[19], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[22], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[25], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[10], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[22], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[18], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[4], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[14], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[13], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[23], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[21], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[23], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[12], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[9], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[3], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[13], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[17], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[26], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[5], tt, tt);
            for (i = 0; i < 8; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[8], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[2], tt, tt);
            for (i = 0; i < 6; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[11], tt, tt);
            for (i = 0; i < 7; ++i) {
                this.fpsqr_mont(tt, tt);
            }
            this.fpmul_mont(t[20], tt, tt);
            for (j = 0; j < 61; ++j) {
                for (i = 0; i < 6; ++i) {
                    this.fpsqr_mont(tt, tt);
                }
                this.fpmul_mont(t[26], tt, tt);
            }
            this.fpcopy(tt, 0, a);
        }
    }
}

