/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.saber;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

abstract class Symmetric {
    Symmetric() {
    }

    abstract void hash_h(byte[] var1, byte[] var2, int var3);

    abstract void hash_g(byte[] var1, byte[] var2);

    abstract void prf(byte[] var1, byte[] var2, int var3, int var4);

    static class AesSymmetric
    extends Symmetric {
        private final SHA256Digest sha256Digest = new SHA256Digest();
        private final SHA512Digest sha512Digest = new SHA512Digest();
        private final SICBlockCipher cipher = new SICBlockCipher(new AESEngine());

        AesSymmetric() {
        }

        void hash_h(byte[] out, byte[] in, int outOffset) {
            this.sha256Digest.update(in, 0, in.length);
            this.sha256Digest.doFinal(out, outOffset);
        }

        void hash_g(byte[] out, byte[] in) {
            this.sha512Digest.update(in, 0, in.length);
            this.sha512Digest.doFinal(out, 0);
        }

        void prf(byte[] out, byte[] in, int inLen, int outLen) {
            ParametersWithIV kp = new ParametersWithIV(new KeyParameter(in, 0, inLen), new byte[16]);
            this.cipher.init(true, kp);
            byte[] buf = new byte[outLen];
            this.cipher.processBytes(buf, 0, outLen, out, 0);
        }
    }

    static class ShakeSymmetric
    extends Symmetric {
        private final SHA3Digest sha3Digest256;
        private final SHA3Digest sha3Digest512;
        private final Xof shakeDigest = new SHAKEDigest(128);

        ShakeSymmetric() {
            this.sha3Digest256 = new SHA3Digest(256);
            this.sha3Digest512 = new SHA3Digest(512);
        }

        void hash_h(byte[] out, byte[] in, int outOffset) {
            this.sha3Digest256.update(in, 0, in.length);
            this.sha3Digest256.doFinal(out, outOffset);
        }

        void hash_g(byte[] out, byte[] in) {
            this.sha3Digest512.update(in, 0, in.length);
            this.sha3Digest512.doFinal(out, 0);
        }

        void prf(byte[] out, byte[] in, int inLen, int outLen) {
            this.shakeDigest.reset();
            this.shakeDigest.update(in, 0, inLen);
            this.shakeDigest.doFinal(out, 0, outLen);
        }
    }
}

